/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.validator.rule.impl;

import cn.vonce.validator.annotation.VChinese;
import cn.vonce.validator.helper.WhatType;
import cn.vonce.validator.model.FieldInfo;
import cn.vonce.validator.rule.AbstractValidate;
import cn.vonce.validator.utils.CheckChineseUtil;

public class ValidateChinese
extends AbstractValidate<VChinese> {
    @Override
    public WhatType[] type() {
        return new WhatType[]{WhatType.STRING_TYPE};
    }

    @Override
    public String getAnticipate(VChinese valid) {
        String anticipate = "'\u4e2d\u6587\u6c49\u5b57\u4e0d\u5305\u542b\u4e2d\u6587\u7b26\u53f7\u7684\u5b57\u7b26\u4e32'";
        if (valid.val() == VChinese.ChineseType.HAS_CHINESE_NOT_HAS_SYMBOL) {
            anticipate = "'\u5305\u542b\u4e2d\u6587\u6c49\u5b57\u4f46\u4e0d\u5305\u542b\u4e2d\u6587\u7b26\u53f7\u7684\u5b57\u7b26\u4e32'";
        } else if (valid.val() == VChinese.ChineseType.IS_CHINESE_HAS_SYMBOL) {
            anticipate = "'\u4e2d\u6587\u6c49\u5b57\u6216\u8005\u4e2d\u6587\u7b26\u53f7\u7684\u5b57\u7b26\u4e32'";
        } else if (valid.val() == VChinese.ChineseType.HAS_CHINESE_HAS_SYMBOL) {
            anticipate = "'\u5305\u542b\u4e2d\u6587\u6c49\u5b57\u6216\u8005\u4e2d\u6587\u7b26\u53f7\u7684\u5b57\u7b26\u4e32'";
        }
        return anticipate;
    }

    @Override
    public boolean check(VChinese valid, FieldInfo fieldInfo) {
        switch (valid.val()) {
            case IS_CHINESE_NOT_HAS_SYMBOL: {
                if (CheckChineseUtil.isChineseByRange(fieldInfo.getValue().toString())) break;
                return false;
            }
            case HAS_CHINESE_NOT_HAS_SYMBOL: {
                if (CheckChineseUtil.hasChineseByRange(fieldInfo.getValue().toString())) break;
                return false;
            }
            case IS_CHINESE_HAS_SYMBOL: {
                if (CheckChineseUtil.isChinese(fieldInfo.getValue().toString())) break;
                return false;
            }
            case HAS_CHINESE_HAS_SYMBOL: {
                if (CheckChineseUtil.hasChinese(fieldInfo.getValue().toString())) break;
                return false;
            }
        }
        return true;
    }
}

