/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.validator.rule.impl;

import cn.vonce.validator.annotation.VBoolean;
import cn.vonce.validator.helper.WhatType;
import cn.vonce.validator.model.FieldInfo;
import cn.vonce.validator.rule.AbstractValidate;

public class ValidateBoolean
extends AbstractValidate<VBoolean> {
    @Override
    public WhatType[] type() {
        return new WhatType[]{WhatType.STRING_TYPE, WhatType.BOOL_TYPE};
    }

    @Override
    public String getAnticipate(VBoolean valid) {
        String anticipate = "'\u5e03\u5c14\u7c7b\u578b'";
        if (valid.val() == VBoolean.BoolValue.TRUE) {
            anticipate = "'\u5e03\u5c14\u503ctrue'";
        } else if (valid.val() == VBoolean.BoolValue.FALSE) {
            anticipate = "'\u5e03\u5c14\u503cfalse'";
        }
        return anticipate;
    }

    @Override
    public boolean check(VBoolean valid, FieldInfo fieldInfo) {
        switch (valid.val()) {
            case NORMAL: {
                if (fieldInfo.getValue().toString().equals("true") || fieldInfo.getValue().toString().equals("false")) break;
                return false;
            }
            case TRUE: {
                if (fieldInfo.getValue().toString().equals("true")) break;
                return false;
            }
            case FALSE: {
                if (fieldInfo.getValue().toString().equals("false")) break;
                return false;
            }
        }
        return true;
    }
}

