/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.validator.rule;

import cn.vonce.validator.helper.ValidatorHelper;
import cn.vonce.validator.helper.WhatType;
import cn.vonce.validator.model.FieldInfo;
import cn.vonce.validator.model.FieldResult;
import cn.vonce.validator.rule.ValidateRule;
import cn.vonce.validator.utils.ValidatorUtil;
import java.lang.annotation.Annotation;

public abstract class AbstractValidate<T extends Annotation>
implements ValidateRule<T> {
    public abstract WhatType[] type();

    public abstract String getAnticipate(T var1);

    public abstract boolean check(T var1, FieldInfo var2);

    @Override
    public FieldResult handle(T valid, FieldInfo fieldInfo) {
        String tips = ValidatorUtil.getTips(fieldInfo.getName(), fieldInfo.getTips(), this.getAnticipate(valid));
        if (ValidatorUtil.isNeedValidation(fieldInfo.getOnlyWhenNotEmpty(), fieldInfo.getValue())) {
            if (fieldInfo.getValue() == null) {
                return new FieldResult(fieldInfo.getName(), tips, ValidatorUtil.getNullError());
            }
            WhatType thisType = ValidatorHelper.whatType(fieldInfo.getValue().getClass().getSimpleName());
            boolean accordWith = false;
            if (this.type() != null) {
                for (WhatType whatType : this.type()) {
                    if (thisType != whatType) continue;
                    accordWith = true;
                    break;
                }
            }
            if (!accordWith) {
                return new FieldResult(fieldInfo.getName(), tips, ValidatorUtil.getTypeError(this.type()));
            }
            if (!this.check(valid, fieldInfo)) {
                return new FieldResult(fieldInfo.getName(), tips, ValidatorUtil.getAnticipateError(this.getAnticipate(valid)));
            }
        }
        return new FieldResult(true, fieldInfo.getName());
    }
}

