/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.validator.intercept;

import cn.vonce.validator.annotation.VBean;
import cn.vonce.validator.config.ResultConfig;
import cn.vonce.validator.enumerate.ResultCode;
import cn.vonce.validator.enumerate.ResultType;
import cn.vonce.validator.exception.ValidatorException;
import cn.vonce.validator.helper.ValidatorHelper;
import cn.vonce.validator.model.BeanResult;
import cn.vonce.validator.model.FieldResult;
import cn.vonce.validator.utils.ReflectJdkUtil;
import cn.vonce.validator.utils.RequestDataUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ValidatorInterceptor
implements MethodInterceptor {
    private final Logger logger = LoggerFactory.getLogger(ValidatorInterceptor.class);

    public Object invoke(MethodInvocation arg0) throws Throwable {
        String fullName = arg0.getMethod().getReturnType().getSimpleName() + " " + arg0.getThis().getClass().getName() + "." + arg0.getMethod().getName();
        if (fullName.indexOf("$$") > -1) {
            return arg0.proceed();
        }
        if (arg0.getArguments().length == 0) {
            return arg0.proceed();
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        HttpServletResponse response = null;
        BeanResult beanResult = new BeanResult(true, "\u6821\u9a8c\u901a\u8fc7");
        for (int i = 0; i < arg0.getArguments().length; ++i) {
            VBean validBean;
            Object object = arg0.getArguments()[i];
            Annotation[] annotations = arg0.getMethod().getParameterAnnotations()[i];
            if (request == null && object instanceof HttpServletRequest) {
                request = (HttpServletRequest)object;
            }
            if (response == null && object instanceof HttpServletResponse) {
                response = (HttpServletResponse)object;
            }
            if ((validBean = ValidatorHelper.getAnnotation(annotations, VBean.class)) != null) {
                beanResult = ValidatorHelper.validBean(object, validBean.group(), validBean.interrupt());
                break;
            }
            List<FieldResult> validFieldResultList = ValidatorHelper.valid(annotations, arg0.getMethod().getName() + "\u65b9\u6cd5\u7b2c" + (i + 1) + "\u4e2a\u53c2\u6570", object, null, "", true);
            if (validFieldResultList.isEmpty()) continue;
            beanResult = new BeanResult("\u6821\u9a8c\u5b58\u5728" + validFieldResultList.size() + "\u6761\u9519\u8bef", validFieldResultList);
            break;
        }
        this.logger.info("\u6b63\u5728\u6821\u9a8c\u53c2\u6570: " + fullName);
        this.logger.info("\u8bf7\u6c42URL\u53c2\u6570: " + RequestDataUtil.getParameters(request.getParameterMap()));
        if (!beanResult.isPass()) {
            String[] names;
            String tips = beanResult.getFieldResultList().get(0).getTips();
            this.logger.warn(beanResult.getMessage() + "\uff0c\u8be6\u60c5\u8bf7\u770b: " + beanResult.getFieldResultList());
            this.logger.info("\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7: " + fullName);
            WebApplicationContext webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getServletContext());
            ResultConfig validatorConfig = null;
            if (webApplicationContext != null && (names = webApplicationContext.getBeanNamesForType(ResultConfig.class)) != null && names.length > 0) {
                validatorConfig = (ResultConfig)webApplicationContext.getBean(names[0]);
            }
            if (validatorConfig != null && validatorConfig.getResultType() == ResultType.RETURN_TIPS && validatorConfig.getResultTemplate() != null) {
                ArrayList classList = new ArrayList();
                classList.add(validatorConfig.getResultTemplate().getClass());
                classList.addAll(Arrays.asList(validatorConfig.getResultTemplate().getClass().getInterfaces()));
                if (classList.contains(arg0.getMethod().getReturnType())) {
                    Object resultTemplate = validatorConfig.getResultTemplate();
                    Class<?> clazz = validatorConfig.getResultTemplate().getClass();
                    String codeFieldName = validatorConfig.getCodeFieldName();
                    String msgFieldName = validatorConfig.getMsgFieldName();
                    Object result = this.copy(resultTemplate);
                    if (result instanceof Map) {
                        Object code = ReflectJdkUtil.instance().invoke(clazz, resultTemplate, "get", codeFieldName);
                        Object msg = ReflectJdkUtil.instance().invoke(clazz, resultTemplate, "get", msgFieldName);
                        if (code == null) {
                            ReflectJdkUtil.instance().invoke(clazz, result, "put", new Class[]{Object.class, Object.class}, new Object[]{codeFieldName, ResultCode.PARAMETER.getCode()});
                        }
                        if (msg == null) {
                            ReflectJdkUtil.instance().invoke(clazz, result, "put", new Class[]{Object.class, Object.class}, new Object[]{msgFieldName, tips});
                        }
                    } else {
                        Object code = ReflectJdkUtil.instance().get(clazz, resultTemplate, codeFieldName);
                        Object msg = ReflectJdkUtil.instance().get(clazz, resultTemplate, msgFieldName);
                        if (code == null) {
                            ReflectJdkUtil.instance().set(clazz, result, codeFieldName, ResultCode.PARAMETER.getCode());
                        }
                        if (msg == null) {
                            ReflectJdkUtil.instance().set(clazz, result, msgFieldName, tips);
                        }
                    }
                    return result;
                }
            } else if (validatorConfig != null && validatorConfig.getResultType() == ResultType.THROW_TIPS) {
                throw new ValidatorException("\u53c2\u6570\u6821\u9a8c\u5931\u8d25'" + tips + "'");
            }
            switch (arg0.getMethod().getReturnType().getName()) {
                case "java.lang.String": {
                    return tips;
                }
                case "java.util.Map": 
                case "java.util.HashMap": {
                    return this.defaultResult(tips);
                }
                case "com.alibaba.fastjson.JSONObject": 
                case "cn.hutool.json.JSONObject": {
                    return this.jsonResult(tips, arg0.getMethod().getReturnType(), validatorConfig);
                }
            }
            if (response != null) {
                this.writer(tips, request, response);
                return null;
            }
            throw new ValidatorException("\u53c2\u6570\u6821\u9a8c\u5931\u8d25'" + tips + "'");
        }
        this.logger.info("\u53c2\u6570\u6821\u9a8c\u901a\u8fc7: " + fullName);
        return arg0.proceed();
    }

    private Map<String, Object> defaultResult(String tips) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("code", ResultCode.PARAMETER.getCode());
        data.put("msg", tips);
        return data;
    }

    private Object jsonResult(String tips, Class<?> clazz, ResultConfig validatorConfig) {
        Object data = null;
        try {
            data = clazz.newInstance();
            ReflectJdkUtil.instance().invoke(clazz, data, "put", new Class[]{Object.class, Object.class}, new Object[]{validatorConfig.getCodeFieldName(), ResultCode.PARAMETER.getCode()});
            ReflectJdkUtil.instance().invoke(clazz, data, "put", new Class[]{Object.class, Object.class}, new Object[]{validatorConfig.getMsgFieldName(), tips});
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writer(String tips, HttpServletRequest request, HttpServletResponse response) {
        try (PrintWriter printWriter = null;){
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json; charset=utf-8");
            printWriter = response.getWriter();
            String data = "{\"code\":" + ResultCode.PARAMETER.getCode() + ",\"msg\":\"" + tips + "\"}";
            printWriter.write(data);
            this.logger.info(request.getServletPath() + " \u7684\u54cd\u5e94\u5185\u5bb9\uff1a" + data);
        }
    }

    private Object copy(Object target) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(target);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        return ois.readObject();
    }
}

