/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.validator.helper;

import cn.vonce.validator.annotation.Validate;
import cn.vonce.validator.helper.WhatType;
import cn.vonce.validator.model.BeanResult;
import cn.vonce.validator.model.FieldInfo;
import cn.vonce.validator.model.FieldResult;
import cn.vonce.validator.utils.ValidatorUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorHelper {
    private static Logger logger = LoggerFactory.getLogger(ValidatorHelper.class);

    public static BeanResult validBean(Object beanObject, String group, boolean interrupt) {
        if (beanObject == null) {
            return new BeanResult("bean" + ValidatorUtil.getNullError());
        }
        Field[] fields = beanObject.getClass().getDeclaredFields();
        ArrayList<FieldResult> fieldResultList = new ArrayList<FieldResult>();
        for (int i = 0; i < fields.length; ++i) {
            try {
                fields[i].setAccessible(true);
                List<FieldResult> validFieldResultList = ValidatorHelper.valid(fields[i].getAnnotations(), fields[i].getName(), fields[i].get(beanObject), beanObject, group, interrupt);
                if (validFieldResultList == null || validFieldResultList.size() <= 0) continue;
                fieldResultList.addAll(validFieldResultList);
                if (!interrupt) continue;
                break;
            }
            catch (SecurityException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return new BeanResult("SecurityException" + e.getMessage());
            }
            catch (IllegalAccessException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return new BeanResult("SecurityException" + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return new BeanResult("SecurityException" + e.getMessage());
            }
        }
        if (!fieldResultList.isEmpty()) {
            return new BeanResult("\u6821\u9a8c\u5b58\u5728" + fieldResultList.size() + "\u6761\u9519\u8bef", fieldResultList);
        }
        return new BeanResult(true, "\u6821\u9a8c\u901a\u8fc7");
    }

    public static List<FieldResult> valid(Annotation[] annotations, String fieldName, Object fieldValue, Object beanObject, String group, boolean interrupt) {
        ArrayList<FieldResult> fieldResultList = new ArrayList<FieldResult>();
        FieldInfo fieldInfo = null;
        String annName = "";
        String annValue = "";
        boolean annOnlyWhenNotEmpty = false;
        String[] groups = null;
        try {
            for (int i = 0; i < annotations.length; ++i) {
                Validate validate = annotations[i].annotationType().getAnnotation(Validate.class);
                if (validate == null) continue;
                for (Method method : annotations[i].annotationType().getMethods()) {
                    if ("name".equals(method.getName())) {
                        Object object = method.invoke((Object)annotations[i], new Object[0]);
                        annName = (String)object;
                    }
                    if ("value".equals(method.getName())) {
                        Object object = method.invoke((Object)annotations[i], new Object[0]);
                        annValue = (String)object;
                    }
                    if ("onlyWhenNotEmpty".equals(method.getName())) {
                        Object object = method.invoke((Object)annotations[i], new Object[0]);
                        annOnlyWhenNotEmpty = (Boolean)object;
                    }
                    if (!"group".equals(method.getName())) continue;
                    Object object = method.invoke((Object)annotations[i], new Object[0]);
                    groups = (String[])object;
                }
                boolean isMust = false;
                for (void var18_33 : groups) {
                    if (!var18_33.equals(group)) continue;
                    isMust = true;
                    break;
                }
                if (!isMust) continue;
                fieldInfo = new FieldInfo();
                fieldInfo.setName(ValidatorUtil.getFieldName(fieldName, annName));
                fieldInfo.setTips(annValue);
                fieldInfo.setValue(fieldValue);
                fieldInfo.setBean(beanObject);
                fieldInfo.setOnlyWhenNotEmpty(annOnlyWhenNotEmpty);
                Method method = validate.type().getMethod("handle", Annotation.class, FieldInfo.class);
                FieldResult fieldResult = (FieldResult)method.invoke(validate.type().newInstance(), annotations[i], fieldInfo);
                if (fieldResult == null || fieldResult.getPass()) continue;
                fieldResultList.add(fieldResult);
                if (!interrupt) {
                    continue;
                }
                break;
            }
        }
        catch (SecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
            fieldResultList.add(new FieldResult("'" + fieldInfo.getName() + "'", "\u51fa\u73b0\u5f02\u5e38", "SecurityException\uff1a" + e.getMessage()));
            return fieldResultList;
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
            fieldResultList.add(new FieldResult("'" + fieldInfo.getName() + "'", "\u51fa\u73b0\u5f02\u5e38", "IllegalAccessException\uff1a" + e.getMessage()));
            return fieldResultList;
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            fieldResultList.add(new FieldResult("'" + fieldInfo.getName() + "'", "\u51fa\u73b0\u5f02\u5e38", "IllegalArgumentException\uff1a" + e.getMessage()));
            return fieldResultList;
        }
        catch (InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
            fieldResultList.add(new FieldResult("'" + fieldInfo.getName() + "'", "\u51fa\u73b0\u5f02\u5e38", "InvocationTargetException\uff1a" + e.getMessage()));
            return fieldResultList;
        }
        catch (NoSuchMethodException e) {
            logger.error(e.getMessage(), (Throwable)e);
            fieldResultList.add(new FieldResult("'" + fieldInfo.getName() + "'", "\u51fa\u73b0\u5f02\u5e38", "NoSuchMethodException\uff1a" + e.getMessage()));
            return fieldResultList;
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            fieldResultList.add(new FieldResult("'" + fieldInfo.getName() + "'", "\u51fa\u73b0\u5f02\u5e38", "InstantiationException\uff1a" + e.getMessage()));
            return fieldResultList;
        }
        return fieldResultList;
    }

    public static <T extends Annotation> T getAnnotation(Annotation[] annotations, Class<T> annotationClass) {
        Annotation t = null;
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().getName().equals(annotationClass.getName())) continue;
            t = (Annotation)annotationClass.cast(annotation);
        }
        return (T)t;
    }

    public static WhatType whatType(String typeName) {
        WhatType whatType = null;
        switch (typeName) {
            case "String": 
            case "Char": {
                whatType = WhatType.STRING_TYPE;
                break;
            }
            case "Boolean": {
                whatType = WhatType.BOOL_TYPE;
                break;
            }
            case "byte": 
            case "Byte": 
            case "short": 
            case "Short": 
            case "int": 
            case "Integer": 
            case "long": 
            case "Long": 
            case "float": 
            case "Float": 
            case "double": 
            case "Double": {
                whatType = WhatType.VALUE_TYPE;
                break;
            }
            case "Date": {
                whatType = WhatType.DATE_TYPE;
                break;
            }
            default: {
                whatType = WhatType.OTHER_TYPE;
            }
        }
        return whatType;
    }
}

