/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.validator.utils;

import cn.vonce.common.utils.StringUtil;
import cn.vonce.validator.helper.WhatType;

public class ValidatorUtil {
    public static boolean isNeedValidation(boolean onlyWhenNotEmpty, Object fieldValue) {
        if (onlyWhenNotEmpty) {
            return StringUtil.isNotEmpty((Object)fieldValue) != false;
        }
        return true;
    }

    public static String getFieldName(String fieldName, String annotationName) {
        return StringUtil.isEmpty((Object)annotationName) != false ? fieldName : annotationName;
    }

    public static String getTypeName(WhatType type) {
        switch (type) {
            case STRING_TYPE: {
                return "\u5b57\u7b26\u4e32";
            }
            case BOOL_TYPE: {
                return "\u5e03\u5c14";
            }
            case VALUE_TYPE: {
                return "\u6570\u503c";
            }
            case DATE_TYPE: {
                return "\u65e5\u671f";
            }
            case OBJECT_TYPE: {
                return "\u5bf9\u8c61";
            }
        }
        return null;
    }

    public static String getTips(String fieldName, String annotationTips, String defaultTips) {
        if (StringUtil.isEmpty((Object)annotationTips).booleanValue()) {
            return String.format("'%s'\u5fc5\u987b\u662f%s", fieldName, defaultTips);
        }
        return annotationTips;
    }

    public static String getNullError() {
        return "\u7b49\u4e8enull";
    }

    public static String getTypeError(WhatType[] type) {
        StringBuffer stringbuffer = new StringBuffer();
        for (int i = 0; i < type.length; ++i) {
            stringbuffer.append(ValidatorUtil.getTypeName(type[i]));
            if (i >= type.length - 1) continue;
            stringbuffer.append(",");
        }
        return String.format("\u4ec5\u652f\u6301%s\u7c7b\u578b\u6821\u9a8c", stringbuffer.toString());
    }

    public static String getAnticipateError(String anticipate) {
        return String.format("\u4e0d\u7b26\u5408%s\u7684\u9884\u671f", anticipate);
    }
}

