/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.validator.rule.impl;

import cn.vonce.validator.annotation.VRangeValue;
import cn.vonce.validator.helper.WhatType;
import cn.vonce.validator.model.FieldInfo;
import cn.vonce.validator.rule.AbstractValidate;
import org.apache.commons.lang.math.NumberUtils;

public class ValidateRangeValue
extends AbstractValidate<VRangeValue> {
    @Override
    public WhatType[] type() {
        return new WhatType[]{WhatType.STRING_TYPE, WhatType.VALUE_TYPE};
    }

    @Override
    public String getAnticipate(VRangeValue valid) {
        return String.format("'\u8bbe\u7f6e\u7684\u503c\u8303\u56f4max{%f},min{%f}'", valid.max(), valid.min());
    }

    @Override
    public boolean check(VRangeValue valid, FieldInfo fieldInfo) {
        if (!NumberUtils.isNumber((String)fieldInfo.getValue().toString())) {
            return false;
        }
        double value = Double.parseDouble(fieldInfo.getValue().toString());
        return !(value > valid.max()) && !(value < valid.min());
    }
}

