/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.validator.intercept;

import cn.vonce.common.base.BaseController;
import cn.vonce.common.utils.RequestDataUtil;
import cn.vonce.validator.annotation.VBean;
import cn.vonce.validator.helper.ValidatorHelper;
import cn.vonce.validator.model.BeanResult;
import cn.vonce.validator.model.FieldResult;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

public class ValidatorInterceptor
implements MethodInterceptor {
    private final Logger logger = LoggerFactory.getLogger(ValidatorInterceptor.class);

    public Object invoke(MethodInvocation arg0) throws Throwable {
        String fullName = arg0.getMethod().getReturnType().getSimpleName() + " " + arg0.getThis().getClass().getName() + "." + arg0.getMethod().getName();
        ResponseBody responseBody = arg0.getMethod().getAnnotation(ResponseBody.class);
        RestController restController = arg0.getThis().getClass().getAnnotation(RestController.class);
        BaseController baseController = arg0.getThis() instanceof BaseController ? (BaseController)arg0.getThis() : new BaseController();
        BeanResult beanResult = new BeanResult(true, "\u6821\u9a8c\u901a\u8fc7");
        for (int i = 0; i < arg0.getArguments().length; ++i) {
            VBean validBean;
            Object object = arg0.getArguments()[i];
            Annotation[] annotations = arg0.getMethod().getParameterAnnotations()[i];
            if (baseController.getRequest() == null && object instanceof HttpServletRequest) {
                baseController.setRequest((HttpServletRequest)object);
            }
            if (baseController.getResponse() == null && object instanceof HttpServletResponse) {
                baseController.setResponse((HttpServletResponse)object);
            }
            if ((validBean = ValidatorHelper.getAnnotation(annotations, VBean.class)) != null) {
                beanResult = ValidatorHelper.validBean(object, validBean.group(), validBean.interrupt());
                break;
            }
            List<FieldResult> validFieldResultList = ValidatorHelper.valid(annotations, arg0.getMethod().getName() + "\u65b9\u6cd5\u53c2\u6570" + (i + 1), object, null, "", true);
            if (validFieldResultList.isEmpty()) continue;
            beanResult = new BeanResult(validFieldResultList.get(0).getTips(), validFieldResultList);
            break;
        }
        this.logger.info("\u6b63\u5728\u6821\u9a8c\u53c2\u6570\uff1a" + fullName);
        if (baseController.getRequest() != null) {
            this.logger.info("\u8bf7\u6c42URL\u53c2\u6570\uff1a" + RequestDataUtil.getParameters((Map)baseController.getRequest().getParameterMap()));
        } else {
            this.logger.info("\u8bf7\u6c42URL\u53c2\u6570\uff1a\u8be5\u65b9\u6cd5\u7f3a\u5c11HttpServletRequest\u53c2\u6570\u65e0\u6cd5\u8bfb\u53d6\u8bf7\u6c42URL\u53c2\u6570 ");
        }
        if (!beanResult.isPass()) {
            this.logger.warn("\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7\uff1a" + fullName);
            this.logger.warn("\u54cd\u5e94\u5185\u5bb9\uff1a" + beanResult.getMessage());
            if (!(arg0.getMethod().getReturnType().getName().equals("void") || responseBody == null && restController == null)) {
                return baseController.parameterHint(beanResult.getMessage());
            }
            if (baseController.getRequest() != null && baseController.getResponse() != null) {
                baseController.parameterHintJSONP(beanResult.getMessage());
            } else {
                this.logger.error("\u53c2\u6570\u9519\u8bef\uff1a" + beanResult.getMessage());
            }
            return null;
        }
        this.logger.info("\u53c2\u6570\u6821\u9a8c\u901a\u8fc7\uff1a" + fullName);
        return arg0.proceed();
    }
}

