/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.valid.rule;

import cn.vonce.common.uitls.CheckChineseUtil;
import cn.vonce.common.uitls.IdCardUtil;
import cn.vonce.common.uitls.ValidatorUtil;
import cn.vonce.valid.annotation.VChinese;
import cn.vonce.valid.annotation.VEmail;
import cn.vonce.valid.annotation.VEqualTo;
import cn.vonce.valid.annotation.VIDCard;
import cn.vonce.valid.annotation.VIPAddr;
import cn.vonce.valid.annotation.VMaxLength;
import cn.vonce.valid.annotation.VMaxValue;
import cn.vonce.valid.annotation.VMinLength;
import cn.vonce.valid.annotation.VMinValue;
import cn.vonce.valid.annotation.VNotEmpty;
import cn.vonce.valid.annotation.VNotNull;
import cn.vonce.valid.annotation.VPassword;
import cn.vonce.valid.annotation.VPhoneNum;
import cn.vonce.valid.annotation.VRangeLength;
import cn.vonce.valid.annotation.VRangeValue;
import cn.vonce.valid.annotation.VSQLInject;
import cn.vonce.valid.annotation.VUrl;
import cn.vonce.valid.annotation.VUserName;
import cn.vonce.valid.helper.ValidFieldHelper;
import java.lang.reflect.Field;
import java.text.ParseException;

public class ValidFieldDefault {
    public String validNotNull(VNotNull valid, Object valueObject, Object beanObject) {
        String message = null;
        if (valueObject == null) {
            message = valid.value();
        }
        return message;
    }

    public String validNotEmpty(VNotEmpty valid, Object valueObject, Object beanObject) {
        String message = null;
        if (valueObject == null) {
            message = valid.value();
        } else if (ValidFieldHelper.whatIsType(valueObject.getClass().getSimpleName()) == ValidFieldHelper.WhatIsType.STRING_TYPE && "".equals(valueObject.toString().trim())) {
            message = valid.value();
        }
        return message;
    }

    public String validMaxLength(VMaxLength valid, Object valueObject, Object beanObject) {
        String message = null;
        if (valueObject == null) {
            message = valid.value();
        } else if (ValidFieldHelper.whatIsType(valueObject.getClass().getSimpleName()) == ValidFieldHelper.WhatIsType.STRING_TYPE && valid != null && valueObject != null && valueObject.toString().trim().length() > valid.val()) {
            message = valid.value();
        }
        return message;
    }

    public String validMinLength(VMinLength valid, Object valueObject, Object beanObject) {
        String message = null;
        if (valueObject == null) {
            message = valid.value();
        } else if (ValidFieldHelper.whatIsType(valueObject.getClass().getSimpleName()) == ValidFieldHelper.WhatIsType.STRING_TYPE && valid != null && valueObject != null && valueObject.toString().trim().length() < valid.val()) {
            message = valid.value();
        }
        return message;
    }

    public String validRangeLength(VRangeLength valid, Object valueObject, Object beanObject) {
        String message = null;
        if (valueObject == null) {
            message = valid.value();
        } else if (ValidFieldHelper.whatIsType(valueObject.getClass().getSimpleName()) == ValidFieldHelper.WhatIsType.STRING_TYPE && valid != null && valueObject != null && (valueObject.toString().trim().length() > valid.max() || valueObject.toString().trim().length() < valid.min())) {
            message = valid.value();
        }
        return message;
    }

    public String validRangeValue(VRangeValue valid, Object valueObject, Object beanObject) {
        String message = null;
        if (valueObject == null) {
            message = valid.value();
        } else if ((ValidFieldHelper.whatIsType(valueObject.getClass().getSimpleName()) == ValidFieldHelper.WhatIsType.STRING_TYPE || ValidFieldHelper.whatIsType(valueObject.getClass().getSimpleName()) == ValidFieldHelper.WhatIsType.VALUE_TYPE) && valid != null && valueObject != null) {
            double value = 0.0;
            try {
                value = Double.parseDouble(valueObject.toString().trim());
            }
            catch (NumberFormatException e) {
                message = valid.name() + "\u8be5\u5b57\u6bb5\u503c\u7c7b\u578b\u4e0d\u6b63\u786e\uff1a" + e.getMessage();
                return message;
            }
            if (value > valid.max() || value < valid.min()) {
                message = valid.name() + String.format(valid.value(), valid.max(), valid.min());
            }
        }
        return message;
    }

    public String validMaxValue(VMaxValue valid, Object valueObject, Object beanObject) {
        String message = null;
        if (valueObject == null) {
            message = valid.value();
        } else if ((ValidFieldHelper.whatIsType(valueObject.getClass().getSimpleName()) == ValidFieldHelper.WhatIsType.STRING_TYPE || ValidFieldHelper.whatIsType(valueObject.getClass().getSimpleName()) == ValidFieldHelper.WhatIsType.VALUE_TYPE) && valid != null && valueObject != null) {
            double val = 0.0;
            try {
                val = Double.parseDouble(valueObject.toString().trim());
            }
            catch (NumberFormatException e) {
                message = valid.name() + "\u8be5\u5b57\u6bb5\u503c\u7c7b\u578b\u4e0d\u6b63\u786e\uff1a" + e.getMessage();
                return message;
            }
            if (val > valid.val()) {
                message = valid.name() + String.format(valid.value(), valid.value());
            }
        }
        return message;
    }

    public String validMinValue(VMinValue valid, Object valueObject, Object beanObject) {
        String message = null;
        if (valueObject == null) {
            message = valid.value();
        } else if ((ValidFieldHelper.whatIsType(valueObject.getClass().getSimpleName()) == ValidFieldHelper.WhatIsType.STRING_TYPE || ValidFieldHelper.whatIsType(valueObject.getClass().getSimpleName()) == ValidFieldHelper.WhatIsType.VALUE_TYPE) && valid != null) {
            double value = 0.0;
            try {
                value = Double.parseDouble(valueObject.toString().trim());
            }
            catch (NumberFormatException e) {
                message = valid.name() + "\u8be5\u5b57\u6bb5\u503c\u7c7b\u578b\u4e0d\u6b63\u786e\uff1a" + e.getMessage();
                return message;
            }
            if (value < valid.val()) {
                message = valid.name() + String.format(valid.value(), valid.value());
            }
        }
        return message;
    }

    public String validUserName(VUserName valid, Object valueObject, Object beanObject) {
        String message = null;
        if (valueObject == null) {
            message = valid.value();
        } else if (!(ValidFieldHelper.whatIsType(valueObject.getClass().getSimpleName()) != ValidFieldHelper.WhatIsType.STRING_TYPE || valueObject != null && ValidatorUtil.isUsername((String)valueObject.toString().trim()))) {
            message = valid.value();
        }
        return message;
    }

    public String validPassword(VPassword valid, Object valueObject, Object beanObject) {
        String message = null;
        if (valueObject == null) {
            message = valid.value();
        } else if (!(ValidFieldHelper.whatIsType(valueObject.getClass().getSimpleName()) != ValidFieldHelper.WhatIsType.STRING_TYPE || valueObject != null && ValidatorUtil.isPassword((String)valueObject.toString().trim()))) {
            message = valid.value();
        }
        return message;
    }

    public String validPhoneNum(VPhoneNum valid, Object valueObject, Object beanObject) {
        String message = null;
        if (valueObject == null) {
            message = valid.value();
        } else if (ValidFieldHelper.whatIsType(valueObject.getClass().getSimpleName()) == ValidFieldHelper.WhatIsType.STRING_TYPE) {
            switch (valid.phoneType()) {
                case MOBILEPHONE: {
                    if (ValidatorUtil.isMobilePhone((String)valueObject.toString().trim())) break;
                    message = valid.value();
                    break;
                }
                case TELEPHONE: {
                    if (ValidatorUtil.isTelePhone((String)valueObject.toString().trim())) break;
                    message = valid.value();
                    break;
                }
                case CHINATELECOM: {
                    if (ValidatorUtil.isChinaTelecom((String)valueObject.toString().trim())) break;
                    message = valid.value();
                    break;
                }
                case CHINAUNICOM: {
                    if (ValidatorUtil.isChinaUnicom((String)valueObject.toString().trim())) break;
                    message = valid.value();
                    break;
                }
                case CHINAMOBILE: {
                    if (ValidatorUtil.isChinaMobile((String)valueObject.toString().trim())) break;
                    message = valid.value();
                }
            }
        }
        return message;
    }

    public String validEmail(VEmail valid, Object valueObject, Object beanObject) {
        String message = null;
        if (valueObject == null) {
            message = valid.value();
        } else if (!(ValidFieldHelper.whatIsType(valueObject.getClass().getSimpleName()) != ValidFieldHelper.WhatIsType.STRING_TYPE || valueObject != null && ValidatorUtil.isEmail((String)valueObject.toString().trim()))) {
            message = valid.value();
        }
        return message;
    }

    public String validChinese(VChinese valid, Object valueObject, Object beanObject) {
        String message = null;
        if (valueObject == null) {
            message = valid.value();
        } else if (ValidFieldHelper.whatIsType(valueObject.getClass().getSimpleName()) == ValidFieldHelper.WhatIsType.STRING_TYPE && valid != null) {
            if (valid.val() == VChinese.ChineseType.IS_CHINESE_NOT_HAS_SYMBOL) {
                if (!CheckChineseUtil.hasChineseByRange((String)valueObject.toString().trim())) {
                    message = valid.name() + valid.value();
                }
            } else if (valid.val() == VChinese.ChineseType.HAS_CHINESE_NOT_HAS_SYMBOL) {
                if (!CheckChineseUtil.hasChineseByRange((String)valueObject.toString().trim())) {
                    message = valid.name() + valid.value();
                }
            } else if (valid.val() == VChinese.ChineseType.IS_CHINESE_HAS_SYMBOL) {
                if (!CheckChineseUtil.hasChineseByRange((String)valueObject.toString().trim())) {
                    message = valid.name() + valid.value();
                }
            } else if (valid.val() == VChinese.ChineseType.HAS_CHINESE_HAS_SYMBOL && !CheckChineseUtil.hasChineseByRange((String)valueObject.toString().trim())) {
                message = valid.name() + valid.value();
            }
        }
        return message;
    }

    public String validIDCard(VIDCard valid, Object valueObject, Object beanObject) {
        String message = null;
        if (valueObject == null) {
            message = valid.value();
        } else if (ValidFieldHelper.whatIsType(valueObject.getClass().getSimpleName()) == ValidFieldHelper.WhatIsType.STRING_TYPE) {
            IdCardUtil.Result result = null;
            try {
                result = IdCardUtil.validate((String)valueObject.toString().trim());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            if (valueObject == null || !result.isOk()) {
                message = valid.name() + result.getMessage();
            }
        }
        return message;
    }

    public String validUrl(VUrl valid, Object valueObject, Object beanObject) {
        String message = null;
        if (valueObject == null) {
            message = valid.message();
        } else if (ValidFieldHelper.whatIsType(valueObject.getClass().getSimpleName()) == ValidFieldHelper.WhatIsType.STRING_TYPE && valid.value() && (valueObject == null || !ValidatorUtil.isUrl((String)valueObject.toString().trim()))) {
            message = valid.message();
        }
        return message;
    }

    public String validIPAddr(VIPAddr valid, Object valueObject, Object beanObject) {
        String message = null;
        if (valueObject == null) {
            message = valid.value();
        } else if (ValidFieldHelper.whatIsType(valueObject.getClass().getSimpleName()) == ValidFieldHelper.WhatIsType.STRING_TYPE && !ValidatorUtil.isIPAddr((String)valueObject.toString().trim())) {
            message = valid.value();
        }
        return message;
    }

    public String validEqualTo(VEqualTo valid, Object valueObject, Object beanObject) {
        String message = null;
        if (valueObject == null) {
            message = valid.value();
        } else if (ValidFieldHelper.whatIsType(valueObject.getClass().getSimpleName()) == ValidFieldHelper.WhatIsType.STRING_TYPE) {
            Object contrastValue = "";
            if (beanObject != null && !valid.field().equals("")) {
                contrastValue = valid.field();
                try {
                    Field field = beanObject.getClass().getDeclaredField(valid.field());
                    field.setAccessible(true);
                    contrastValue = field.get(beanObject);
                }
                catch (NoSuchFieldException e) {
                    message = e.getMessage();
                }
                catch (SecurityException e) {
                    message = e.getMessage();
                }
                catch (IllegalArgumentException e) {
                    message = e.getMessage();
                }
                catch (IllegalAccessException e) {
                    message = e.getMessage();
                }
            } else {
                contrastValue = valid.val();
            }
            if (!valueObject.equals(contrastValue)) {
                message = valid.value();
            }
        }
        return message;
    }

    public String validSQLInject(VSQLInject valid, Object valueObject, Object beanObject) {
        String message = null;
        if (valueObject != null && ValidFieldHelper.whatIsType(valueObject.getClass().getSimpleName()) == ValidFieldHelper.WhatIsType.STRING_TYPE && !ValidatorUtil.isSQLInject((String)valueObject.toString())) {
            message = valid.value();
        }
        return message;
    }
}

