/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.valid.helper;

import cn.vonce.valid.annotation.VBean;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ValidFieldHelper {
    public static List<String> validBean(Object beanObject, String group, boolean interrupt) {
        ArrayList<String> messageList = new ArrayList<String>();
        if (beanObject == null) {
            messageList.add("bean\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return messageList;
        }
        Field[] fields = beanObject.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                fields[i].setAccessible(true);
                Object value = fields[i].get(beanObject);
                List<String> mList = ValidFieldHelper.valid(fields[i].getAnnotations(), value, beanObject, group, interrupt);
                if (mList == null || mList.size() <= 0) continue;
                messageList.addAll(mList);
                if (!interrupt) continue;
                break;
            }
            catch (SecurityException e) {
                messageList.add(e.getMessage());
                continue;
            }
            catch (IllegalAccessException e) {
                messageList.add(e.getMessage());
                continue;
            }
            catch (IllegalArgumentException e) {
                messageList.add(e.getMessage());
            }
        }
        return messageList;
    }

    public static List<String> valid(Annotation[] annotations, Object valueObject, Object beanObject, String group, boolean interrupt) {
        ArrayList<String> messageList = new ArrayList<String>();
        try {
            for (int i = 0; i < annotations.length; ++i) {
                String message;
                Method[] methods;
                if (annotations[i] instanceof VBean) continue;
                String typeName = null;
                String methodName = null;
                String[] groups = null;
                for (Method method : methods = annotations[i].annotationType().getMethods()) {
                    Object var15_23 = null;
                    if ("type".equals(method.getName())) {
                        Object object = method.invoke((Object)annotations[i], new Object[0]);
                        typeName = object.toString().split(" ")[1];
                    }
                    if ("method".equals(method.getName())) {
                        Object object = method.invoke((Object)annotations[i], new Object[0]);
                        methodName = object.toString();
                    }
                    if (!"group".equals(method.getName())) continue;
                    Object object = method.invoke((Object)annotations[i], new Object[0]);
                    groups = (String[])object;
                }
                if (typeName == null || methodName == null || groups == null) continue;
                boolean isMust = false;
                for (void var15_30 : groups) {
                    if (!var15_30.equals(group)) continue;
                    isMust = true;
                    break;
                }
                if (!isMust || (message = ValidFieldHelper.execute(typeName, methodName, groups, annotations[i], valueObject, beanObject, group)) == null || message.equals("")) continue;
                messageList.add(message);
                if (!interrupt) {
                    continue;
                }
                break;
            }
        }
        catch (SecurityException e) {
            messageList.add(e.getMessage());
        }
        catch (IllegalAccessException e) {
            messageList.add(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            messageList.add(e.getMessage());
        }
        catch (InvocationTargetException e) {
            messageList.add(e.getMessage());
        }
        return messageList;
    }

    private static String execute(String typeName, String methodName, String[] groups, Annotation annotation, Object valueObject, Object beanObject, String group) {
        String messageExpand;
        block10: {
            messageExpand = null;
            try {
                if (!"".equals(methodName)) {
                    Object methodResult;
                    Class<?> clazz = Class.forName(typeName);
                    Method method = clazz.getMethod(methodName, annotation.annotationType(), Object.class, Object.class);
                    if (method != null && (methodResult = method.invoke(clazz.newInstance(), annotation, valueObject, beanObject)) != null) {
                        messageExpand = ValidFieldHelper.whatIsType(methodResult.getClass().getSimpleName()) != WhatIsType.STRING_TYPE ? "\u8be5\u9a8c\u8bc1\u65b9\u6cd5\u8fd4\u56de\u503c\u4e0d\u6b63\u786e\uff1a" + typeName + "." + methodName : methodResult.toString();
                    }
                    break block10;
                }
                return "\u5b57\u6bb5\u9a8c\u8bc1\u5931\u8d25\uff0c\u8be5\u6ce8\u89e3\u672a\u6307\u5b9a\u9a8c\u8bc1\u65b9\u6cd5\uff1a" + annotation.annotationType().getName();
            }
            catch (SecurityException e) {
                messageExpand = e.getMessage();
            }
            catch (IllegalAccessException e) {
                messageExpand = e.getMessage();
            }
            catch (IllegalArgumentException e) {
                messageExpand = e.getMessage();
            }
            catch (InvocationTargetException e) {
                messageExpand = e.getMessage();
            }
            catch (NoSuchMethodException e) {
                messageExpand = "\u6ca1\u6709\u627e\u5230\u8be5\u65b9\u6cd5\uff0c\u8bf7\u68c0\u67e5\u65b9\u6cd5\u540d\u4e0e\u53c2\u6570\u662f\u5426\u6b63\u786e\uff1a" + e.getMessage();
            }
            catch (ClassNotFoundException e) {
                messageExpand = "\u6ca1\u6709\u627e\u5230\u8be5\u7c7b\uff1a" + e.getMessage();
            }
            catch (InstantiationException e) {
                messageExpand = e.getMessage();
            }
        }
        return messageExpand;
    }

    public static <T extends Annotation> T getAnnotation(Annotation[] annotations, Class<T> annotationClass) {
        Annotation t = null;
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().getName().equals(annotationClass.getName())) continue;
            t = (Annotation)annotationClass.cast(annotation);
        }
        return (T)t;
    }

    public static WhatIsType whatIsType(String typeName) {
        WhatIsType whatIsType = null;
        switch (typeName) {
            case "String": 
            case "Char": {
                whatIsType = WhatIsType.STRING_TYPE;
                break;
            }
            case "Boolean": {
                whatIsType = WhatIsType.BOOL_TYPE;
                break;
            }
            case "byte": 
            case "short": 
            case "int": 
            case "long": 
            case "float": 
            case "double": 
            case "Byte": 
            case "Short": 
            case "Integer": 
            case "Long": 
            case "Float": 
            case "Double": {
                whatIsType = WhatIsType.VALUE_TYPE;
                break;
            }
            case "Date": {
                whatIsType = WhatIsType.DATE_TYPE;
                break;
            }
            default: {
                whatIsType = WhatIsType.OBJECT_TYPE;
            }
        }
        return whatIsType;
    }

    public static enum WhatIsType {
        STRING_TYPE,
        VALUE_TYPE,
        BOOL_TYPE,
        DATE_TYPE,
        OBJECT_TYPE;

    }
}

