/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.spring.config;

import cn.vonce.sql.config.SqlBeanConfig;
import cn.vonce.sql.config.SqlBeanMeta;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.core.JdbcTemplate;

public class SpringJdbcAutoConfig {
    private Logger logger = LoggerFactory.getLogger(SpringJdbcAutoConfig.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired(required=false)
    private SqlBeanConfig sqlBeanConfig;

    @Bean(name={"sqlBeanMetaForSpringJdbc"})
    public SqlBeanMeta sqlBeanMeta() {
        try {
            Connection connection = this.jdbcTemplate.getDataSource().getConnection();
            SqlBeanMeta sqlBeanMeta = SqlBeanMeta.build((SqlBeanConfig)this.sqlBeanConfig, (DatabaseMetaData)connection.getMetaData());
            connection.close();
            return sqlBeanMeta;
        }
        catch (SQLException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

