/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.spring.config;

import cn.vonce.sql.config.SqlBeanConfig;
import cn.vonce.sql.config.SqlBeanMeta;
import cn.vonce.sql.java.mapper.MybatisSqlBeanMapperInterceptor;
import cn.vonce.sql.spring.config.ConditionalOnUseMybatis;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;

public class MybatisAutoConfig {
    private Logger logger = LoggerFactory.getLogger(MybatisAutoConfig.class);
    @Autowired(required=false)
    private SqlSessionFactoryBean sqlSessionFactoryBean;
    @Autowired
    private BeanFactory beanFactory;
    @Autowired(required=false)
    private SqlBeanConfig sqlBeanConfig;

    @Bean
    @Conditional(value={ConditionalOnUseMybatis.class})
    public Interceptor interceptor() throws Exception {
        List interceptorList;
        MybatisSqlBeanMapperInterceptor mybatisMapperInterceptor = new MybatisSqlBeanMapperInterceptor();
        SqlSessionFactory sqlSessionFactory = null;
        if (this.sqlSessionFactoryBean != null) {
            sqlSessionFactory = this.sqlSessionFactoryBean.getObject();
        } else {
            try {
                sqlSessionFactory = (SqlSessionFactory)this.beanFactory.getBean(SqlSessionFactory.class);
            }
            catch (Exception e) {
                this.logger.info("MybatisAutoConfig\uff1a{}", (Object)e.getMessage());
            }
        }
        if (sqlSessionFactory != null && (interceptorList = sqlSessionFactory.getConfiguration().getInterceptors()) != null && !interceptorList.stream().anyMatch(item -> item instanceof MybatisSqlBeanMapperInterceptor)) {
            sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)mybatisMapperInterceptor);
        }
        return mybatisMapperInterceptor;
    }

    @Bean(name={"sqlBeanConfigForMybatis"})
    @Conditional(value={ConditionalOnUseMybatis.class})
    public SqlBeanMeta sqlBeanMeta() {
        try {
            SqlSessionFactory sqlSessionFactory = null;
            if (this.sqlSessionFactoryBean != null) {
                sqlSessionFactory = this.sqlSessionFactoryBean.getObject();
            } else {
                try {
                    sqlSessionFactory = (SqlSessionFactory)this.beanFactory.getBean(SqlSessionFactory.class);
                }
                catch (Exception e) {
                    this.logger.info("MybatisAutoConfig\uff1a{}", (Object)e.getMessage());
                }
            }
            Connection connection = sqlSessionFactory.getConfiguration().getEnvironment().getDataSource().getConnection();
            SqlBeanMeta sqlBeanMeta = SqlBeanMeta.build((SqlBeanConfig)this.sqlBeanConfig, (DatabaseMetaData)connection.getMetaData());
            connection.close();
            return sqlBeanMeta;
        }
        catch (SQLException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

