/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.spring.service;

import cn.vonce.sql.bean.Alter;
import cn.vonce.sql.bean.Column;
import cn.vonce.sql.bean.ColumnInfo;
import cn.vonce.sql.bean.Delete;
import cn.vonce.sql.bean.Insert;
import cn.vonce.sql.bean.Paging;
import cn.vonce.sql.bean.Select;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.bean.TableInfo;
import cn.vonce.sql.bean.Update;
import cn.vonce.sql.config.SqlBeanMeta;
import cn.vonce.sql.define.ColumnFun;
import cn.vonce.sql.define.ConditionHandle;
import cn.vonce.sql.enumerate.DbType;
import cn.vonce.sql.exception.SqlBeanException;
import cn.vonce.sql.helper.Wrapper;
import cn.vonce.sql.java.annotation.DbSwitch;
import cn.vonce.sql.java.annotation.DbTransactional;
import cn.vonce.sql.java.enumerate.DbRole;
import cn.vonce.sql.java.service.BaseSqlBeanServiceImpl;
import cn.vonce.sql.page.PageHelper;
import cn.vonce.sql.page.PagingService;
import cn.vonce.sql.page.ResultData;
import cn.vonce.sql.provider.SqlBeanProvider;
import cn.vonce.sql.service.AdvancedDbManageService;
import cn.vonce.sql.service.SqlBeanService;
import cn.vonce.sql.spring.config.UseSpringJdbc;
import cn.vonce.sql.spring.mapper.SpringJdbcSqlBeanMapper;
import cn.vonce.sql.uitls.DateUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@UseSpringJdbc
@Service
public class SpringJdbcSqlBeanServiceImpl<T, ID>
extends BaseSqlBeanServiceImpl<T>
implements SqlBeanService<T, ID>,
AdvancedDbManageService<T> {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private final Class<?> clazz;
    @Autowired
    @Qualifier(value="sqlBeanMetaForSpringJdbc")
    private SqlBeanMeta sqlBeanMeta;

    public SpringJdbcSqlBeanServiceImpl() {
        List classes = SqlBeanUtil.getGenericTypeBySuperclass(((Object)((Object)this)).getClass());
        this.clazz = !classes.isEmpty() ? (Class)classes.get(0) : null;
    }

    public SqlBeanMeta getSqlBeanMeta() {
        return super.setSqlBeanMeta(this.sqlBeanMeta);
    }

    public Long getAutoIncrId() {
        return (Long)SpringJdbcSqlBeanServiceImpl.singleResult(this.jdbcTemplate.query(SqlBeanProvider.lastInsertIdSql(), new SpringJdbcSqlBeanMapper(this.clazz, Long.class)));
    }

    public Class<?> getBeanClass() {
        return this.clazz;
    }

    @DbSwitch(value=DbRole.SLAVE)
    public T selectById(ID id) {
        if (id == null) {
            return null;
        }
        return SpringJdbcSqlBeanServiceImpl.singleResult(this.jdbcTemplate.query(SqlBeanProvider.selectByIdSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, null, id), new SpringJdbcSqlBeanMapper(this.clazz, this.clazz)));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> R selectById(Class<R> returnType, ID id) {
        if (id == null) {
            return null;
        }
        return (R)SpringJdbcSqlBeanServiceImpl.singleResult(this.jdbcTemplate.query(SqlBeanProvider.selectByIdSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, returnType, id), new SpringJdbcSqlBeanMapper(this.clazz, returnType)));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> selectByIds(ID ... ids) {
        if (ids == null || ids.length == 0) {
            throw new SqlBeanException("selectByIds\u65b9\u6cd5ids\u53c2\u6570\u5fc5\u987b\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.jdbcTemplate.query(SqlBeanProvider.selectByIdsSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, null, (Object[])ids), new SpringJdbcSqlBeanMapper(this.clazz, this.clazz));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> selectByIds(Class<R> returnType, ID ... ids) {
        if (ids == null || ids.length == 0) {
            throw new SqlBeanException("selectByIds\u65b9\u6cd5ids\u53c2\u6570\u5fc5\u987b\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.jdbcTemplate.query(SqlBeanProvider.selectByIdsSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, returnType, (Object[])ids), new SpringJdbcSqlBeanMapper(this.clazz, returnType));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public T selectOne(Select select) {
        return SpringJdbcSqlBeanServiceImpl.singleResult(this.jdbcTemplate.query(SqlBeanProvider.selectSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, null, (Select)select), new SpringJdbcSqlBeanMapper(this.clazz, this.clazz)));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> R selectOne(Class<R> returnType, Select select) {
        return (R)SpringJdbcSqlBeanServiceImpl.singleResult(this.jdbcTemplate.query(SqlBeanProvider.selectSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, returnType, (Select)select), new SpringJdbcSqlBeanMapper(this.clazz, returnType)));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public Map<String, Object> selectMap(Select select) {
        return (Map)SpringJdbcSqlBeanServiceImpl.singleResult(this.jdbcTemplate.query(SqlBeanProvider.selectSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, null, (Select)select), new SpringJdbcSqlBeanMapper(this.clazz, Map.class)));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public T selectOneBy(String where, Object ... args) {
        return SpringJdbcSqlBeanServiceImpl.singleResult(this.jdbcTemplate.query(SqlBeanProvider.selectBySql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, null, null, (String)where, (Object[])args), new SpringJdbcSqlBeanMapper(this.clazz, this.clazz)));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> R selectOneBy(Class<R> returnType, String where, Object ... args) {
        return (R)SpringJdbcSqlBeanServiceImpl.singleResult(this.jdbcTemplate.query(SqlBeanProvider.selectBySql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, returnType, null, (String)where, (Object[])args), new SpringJdbcSqlBeanMapper(this.clazz, returnType)));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public T selectOneBy(Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        return SpringJdbcSqlBeanServiceImpl.singleResult(this.jdbcTemplate.query(SqlBeanProvider.selectSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, null, (Select)select), new SpringJdbcSqlBeanMapper(this.clazz, this.clazz)));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public T selectOneBy(ConditionHandle<T> cond) {
        return this.selectOneBy(super.conditionHandle(cond));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> R selectOneBy(Class<R> returnType, Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        return (R)SpringJdbcSqlBeanServiceImpl.singleResult(this.jdbcTemplate.query(SqlBeanProvider.selectSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, returnType, (Select)select), new SpringJdbcSqlBeanMapper(this.clazz, returnType)));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> R selectOneBy(Class<R> returnType, ConditionHandle<T> cond) {
        return this.selectOneBy(returnType, super.conditionHandle(cond));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> selectBy(Class<R> returnType, String where, Object ... args) {
        return this.jdbcTemplate.query(SqlBeanProvider.selectBySql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, returnType, null, (String)where, (Object[])args), new SpringJdbcSqlBeanMapper(this.clazz, returnType));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> selectBy(Class<R> returnType, Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        return this.jdbcTemplate.query(SqlBeanProvider.selectSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, returnType, (Select)select), new SpringJdbcSqlBeanMapper(this.clazz, returnType));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> selectBy(Class<R> returnType, ConditionHandle<T> cond) {
        return this.selectBy(returnType, super.conditionHandle(cond));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> selectBy(Class<R> returnType, Paging paging, String where, Object ... args) {
        return this.jdbcTemplate.query(SqlBeanProvider.selectBySql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, returnType, (Paging)paging, (String)where, (Object[])args), new SpringJdbcSqlBeanMapper(this.clazz, returnType));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> selectBy(Class<R> returnType, Paging paging, Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        select.page(paging.getPagenum(), paging.getPagesize(), paging.getStartByZero());
        select.orderBy(paging.getOrders());
        return this.jdbcTemplate.query(SqlBeanProvider.selectSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, returnType, (Select)select), new SpringJdbcSqlBeanMapper(this.clazz, returnType));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> selectBy(Class<R> returnType, Paging paging, ConditionHandle<T> cond) {
        return this.selectBy(returnType, super.conditionHandle(cond));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> selectBy(String where, Object ... args) {
        return this.jdbcTemplate.query(SqlBeanProvider.selectBySql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, null, null, (String)where, (Object[])args), new SpringJdbcSqlBeanMapper(this.clazz, this.clazz));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> selectBy(Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        return this.jdbcTemplate.query(SqlBeanProvider.selectSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, null, (Select)select), new SpringJdbcSqlBeanMapper(this.clazz, this.clazz));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> selectBy(ConditionHandle<T> cond) {
        return this.selectBy(super.conditionHandle(cond));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> selectBy(Paging paging, String where, Object ... args) {
        return this.jdbcTemplate.query(SqlBeanProvider.selectBySql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, null, (Paging)paging, (String)where, (Object[])args), new SpringJdbcSqlBeanMapper(this.clazz, this.clazz));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> selectBy(Paging paging, Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        select.page(paging.getPagenum(), paging.getPagesize(), paging.getStartByZero());
        select.orderBy(paging.getOrders());
        return this.jdbcTemplate.query(SqlBeanProvider.selectSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, null, (Select)select), new SpringJdbcSqlBeanMapper(this.clazz, this.clazz));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> selectBy(Paging paging, ConditionHandle<T> cond) {
        return this.selectBy(super.conditionHandle(cond));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public int countBy(String where, Object ... args) {
        return (Integer)this.jdbcTemplate.queryForObject(SqlBeanProvider.countBySql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (String)where, (Object[])args), new SpringJdbcSqlBeanMapper(this.clazz, Integer.class));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public int countBy(Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        return (Integer)this.jdbcTemplate.queryForObject(SqlBeanProvider.countSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, null, (Select)select), new SpringJdbcSqlBeanMapper(this.clazz, Integer.class));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public int countBy(ConditionHandle<T> cond) {
        return this.countBy(super.conditionHandle(cond));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public int count() {
        return (Integer)this.jdbcTemplate.queryForObject(SqlBeanProvider.countBySql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, null, null), new SpringJdbcSqlBeanMapper(this.clazz, Integer.class));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> select() {
        return this.jdbcTemplate.query(SqlBeanProvider.selectAllSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, null, null), new SpringJdbcSqlBeanMapper(this.clazz, this.clazz));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> select(Paging paging) {
        return this.jdbcTemplate.query(SqlBeanProvider.selectAllSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, null, (Paging)paging), new SpringJdbcSqlBeanMapper(this.clazz, this.clazz));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> select(Class<R> returnType) {
        return this.jdbcTemplate.query(SqlBeanProvider.selectAllSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, returnType, null), new SpringJdbcSqlBeanMapper(this.clazz, returnType));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> select(Class<R> returnType, Paging paging) {
        return this.jdbcTemplate.query(SqlBeanProvider.selectAllSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, returnType, (Paging)paging), new SpringJdbcSqlBeanMapper(this.clazz, returnType));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<Map<String, Object>> selectMapList(Select select) {
        return this.jdbcTemplate.query(SqlBeanProvider.selectSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, null, (Select)select), new SpringJdbcSqlBeanMapper(this.clazz, Map.class));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> select(Class<R> returnType, Select select) {
        return this.jdbcTemplate.query(SqlBeanProvider.selectSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, returnType, (Select)select), new SpringJdbcSqlBeanMapper(this.clazz, returnType));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> select(Select select) {
        return this.jdbcTemplate.query(SqlBeanProvider.selectSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, null, (Select)select), new SpringJdbcSqlBeanMapper(this.clazz, this.clazz));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public int count(Select select) {
        return (Integer)this.jdbcTemplate.queryForObject(SqlBeanProvider.countSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, null, (Select)select), new SpringJdbcSqlBeanMapper(this.clazz, Integer.class));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public int count(Class<?> returnType, Select select) {
        return (Integer)this.jdbcTemplate.queryForObject(SqlBeanProvider.countSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, returnType, (Select)select), Integer.class);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public ResultData<T> paging(Select select, PageHelper<T> pageHelper) {
        pageHelper.paging(select, (PagingService)this);
        return pageHelper.getResultData();
    }

    @DbSwitch(value=DbRole.SLAVE)
    public ResultData<T> paging(Select select, int pagenum, int pagesize) {
        PageHelper pageHelper = new PageHelper(Integer.valueOf(pagenum), Integer.valueOf(pagesize));
        pageHelper.paging(select, (PagingService)this);
        return pageHelper.getResultData();
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> ResultData<R> paging(Class<R> returnType, Select select, PageHelper<R> pageHelper) {
        pageHelper.paging(returnType, select, (PagingService)this);
        return pageHelper.getResultData();
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> ResultData<R> paging(Class<R> returnType, Select select, int pagenum, int pagesize) {
        PageHelper pageHelper = new PageHelper(Integer.valueOf(pagenum), Integer.valueOf(pagesize));
        pageHelper.paging(returnType, select, (PagingService)this);
        return pageHelper.getResultData();
    }

    @DbSwitch(value=DbRole.MASTER)
    public int deleteById(ID ... id) {
        if (id == null || id.length == 0) {
            throw new SqlBeanException("deleteById\u65b9\u6cd5id\u53c2\u6570\u5fc5\u987b\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.jdbcTemplate.update(SqlBeanProvider.deleteByIdSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, id));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int deleteBy(String where, Object ... args) {
        return this.jdbcTemplate.update(SqlBeanProvider.deleteBySql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (String)where, (Object[])args));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int deleteBy(Wrapper wrapper) {
        Delete delete = new Delete();
        delete.where(wrapper);
        return this.jdbcTemplate.update(SqlBeanProvider.deleteSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (Delete)delete, (boolean)false));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int deleteBy(ConditionHandle<T> cond) {
        return this.deleteBy(super.conditionHandle(cond));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int delete(Delete delete) {
        return this.jdbcTemplate.update(SqlBeanProvider.deleteSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (Delete)delete, (boolean)false));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int delete(Delete delete, boolean ignore) {
        return this.jdbcTemplate.update(SqlBeanProvider.deleteSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (Delete)delete, (boolean)ignore));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int logicallyDeleteById(ID ... id) {
        if (id == null || id.length == 0) {
            throw new SqlBeanException("logicallyDeleteById\u65b9\u6cd5id\u53c2\u6570\u5fc5\u987b\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.jdbcTemplate.update(SqlBeanProvider.logicallyDeleteByIdSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, id));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int logicallyDeleteBy(String where, Object ... args) {
        return this.jdbcTemplate.update(SqlBeanProvider.logicallyDeleteBySql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (String)where, (Object[])args));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int logicallyDeleteBy(Wrapper wrapper) {
        return this.jdbcTemplate.update(SqlBeanProvider.logicallyDeleteBySql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (Wrapper)wrapper));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int logicallyDeleteBy(ConditionHandle<T> cond) {
        return this.logicallyDeleteBy(super.conditionHandle(cond));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int update(Update update) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (Update)update, (boolean)false));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int update(Update update, boolean ignore) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (Update)update, (boolean)ignore));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateById(T bean, ID id) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateByIdSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, bean, id, (boolean)true, (boolean)false, null));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateById(T bean, ID id, boolean updateNotNull, boolean optimisticLock) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateByIdSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, bean, id, (boolean)updateNotNull, (boolean)optimisticLock, null));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateByBeanId(T bean) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateByBeanIdSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, bean, (boolean)true, (boolean)false, null));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateById(T bean, ID id, boolean updateNotNull, boolean optimisticLock, Column ... filterColumns) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateByIdSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, bean, id, (boolean)updateNotNull, (boolean)optimisticLock, (Column[])filterColumns));
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> int updateById(T bean, ID id, boolean updateNotNull, boolean optimisticLock, ColumnFun<T, R> ... filterColumns) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateByIdSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, bean, id, (boolean)updateNotNull, (boolean)optimisticLock, (Column[])SqlBeanUtil.funToColumn(filterColumns)));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, String where, Object ... args) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateBySql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, bean, (boolean)true, (boolean)false, null, (String)where, (Object[])args));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateByBeanId(T bean, boolean updateNotNull, boolean optimisticLock) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateByBeanIdSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, null));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateByBeanId(T bean, boolean updateNotNull, boolean optimisticLock, Column ... filterColumns) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateByBeanIdSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, (Column[])filterColumns));
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> int updateByBeanId(T bean, boolean updateNotNull, boolean optimisticLock, ColumnFun<T, R> ... filterColumns) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateByBeanIdSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, (Column[])SqlBeanUtil.funToColumn(filterColumns)));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, String where, Object ... args) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateBySql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, null, (String)where, (Object[])args));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, Wrapper wrapper) {
        Update update = new Update();
        update.bean(bean).notNull(true).optimisticLock(false).where(wrapper);
        return this.jdbcTemplate.update(SqlBeanProvider.updateSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (Update)update, (boolean)false));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, ConditionHandle<T> cond) {
        return this.updateBy(bean, super.conditionHandle(cond));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, Wrapper wrapper) {
        Update update = new Update();
        update.bean(bean).notNull(updateNotNull).optimisticLock(optimisticLock).where(wrapper);
        return this.jdbcTemplate.update(SqlBeanProvider.updateSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (Update)update, (boolean)false));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, ConditionHandle<T> cond) {
        return this.updateBy(bean, updateNotNull, optimisticLock, super.conditionHandle(cond));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, Column[] filterColumns, String where, Object ... args) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateBySql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, (Column[])filterColumns, (String)where, (Object[])args));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, Wrapper wrapper, Column ... filterColumns) {
        Update update = new Update();
        update.bean(bean).notNull(updateNotNull).optimisticLock(optimisticLock).filterFields(filterColumns).where(wrapper);
        return this.jdbcTemplate.update(SqlBeanProvider.updateSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (Update)update, (boolean)false));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, ConditionHandle<T> cond, Column ... filterColumns) {
        return this.updateBy(bean, updateNotNull, optimisticLock, super.conditionHandle(cond), filterColumns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, Wrapper wrapper, ColumnFun<T, R> ... filterColumns) {
        return this.updateBy(bean, updateNotNull, optimisticLock, wrapper, SqlBeanUtil.funToColumn(filterColumns));
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, ConditionHandle<T> cond, ColumnFun<T, R> ... filterColumns) {
        return this.updateBy(bean, updateNotNull, optimisticLock, super.conditionHandle(cond), SqlBeanUtil.funToColumn(filterColumns));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateByBean(T bean, String where) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateByBeanSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, bean, (boolean)true, (boolean)false, (String)where, null));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateByBean(T bean, boolean updateNotNull, boolean optimisticLock, String where) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateByBeanSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, (String)where, null));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateByBean(T bean, boolean updateNotNull, boolean optimisticLock, String where, Column ... filterColumns) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateByBeanSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, (String)where, (Column[])filterColumns));
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> int updateByBean(T bean, boolean updateNotNull, boolean optimisticLock, String where, ColumnFun<T, R> ... filterColumns) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateByBeanSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, (String)where, (Column[])SqlBeanUtil.funToColumn(filterColumns)));
    }

    @Transactional
    @DbTransactional
    @DbSwitch(value=DbRole.MASTER)
    public int insert(T ... bean) {
        if (bean == null || bean.length == 0) {
            throw new SqlBeanException("insert\u65b9\u6cd5bean\u53c2\u6570\u5fc5\u987b\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        int count = this.jdbcTemplate.update(SqlBeanProvider.insertBeanSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, bean));
        super.setAutoIncrId(this.clazz, Arrays.asList(bean));
        return count;
    }

    @Transactional
    @DbTransactional
    @DbSwitch(value=DbRole.MASTER)
    public int insert(Collection<T> beanList) {
        if (beanList == null || beanList.size() == 0) {
            throw new SqlBeanException("insert\u65b9\u6cd5beanList\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        int count = this.jdbcTemplate.update(SqlBeanProvider.insertBeanSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, beanList));
        super.setAutoIncrId(this.clazz, beanList);
        return count;
    }

    @Transactional
    @DbTransactional
    @DbSwitch(value=DbRole.MASTER)
    public int insert(Insert insert) {
        int count = this.jdbcTemplate.update(SqlBeanProvider.insertBeanSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (Object)insert));
        super.setAutoIncrId(this.clazz, (Collection)insert.getBean());
        return count;
    }

    @DbSwitch(value=DbRole.MASTER)
    public String backup() {
        String targetTableName = SqlBeanUtil.getTable(this.clazz).getName() + "_" + DateUtil.dateToString((Date)new Date(), (String)"yyyyMMddHHmmssSSS");
        this.jdbcTemplate.update(SqlBeanProvider.backupSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, null, null, (String)targetTableName, null));
        return targetTableName;
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(String targetTableName) {
        this.jdbcTemplate.update(SqlBeanProvider.backupSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, null, null, (String)targetTableName, null));
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(String targetSchema, String targetTableName) {
        this.jdbcTemplate.update(SqlBeanProvider.backupSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, null, (String)targetSchema, (String)targetTableName, null));
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(Wrapper wrapper, String targetSchema, String targetTableName) {
        this.jdbcTemplate.update(SqlBeanProvider.backupSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (Wrapper)wrapper, (String)targetSchema, (String)targetTableName, null));
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(ConditionHandle<T> cond, String targetSchema, String targetTableName) {
        this.backup(super.conditionHandle(cond), targetSchema, targetTableName);
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(Wrapper wrapper, String targetTableName, Column ... columns) {
        this.jdbcTemplate.update(SqlBeanProvider.backupSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (Wrapper)wrapper, null, (String)targetTableName, (Column[])columns));
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(ConditionHandle<T> cond, String targetTableName, Column ... columns) {
        this.backup(super.conditionHandle(cond), targetTableName, columns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> void backup(Wrapper wrapper, String targetTableName, ColumnFun<T, R> ... columns) {
        this.jdbcTemplate.update(SqlBeanProvider.backupSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (Wrapper)wrapper, null, (String)targetTableName, (Column[])SqlBeanUtil.funToColumn(columns)));
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> void backup(ConditionHandle<T> cond, String targetTableName, ColumnFun<T, R> ... columns) {
        this.backup(super.conditionHandle(cond), targetTableName, columns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(Wrapper wrapper, String targetSchema, String targetTableName, Column ... columns) {
        this.jdbcTemplate.update(SqlBeanProvider.backupSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (Wrapper)wrapper, (String)targetSchema, (String)targetTableName, (Column[])columns));
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(ConditionHandle<T> cond, String targetSchema, String targetTableName, Column ... columns) {
        this.backup(super.conditionHandle(cond), targetSchema, targetTableName, columns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> void backup(Wrapper wrapper, String targetSchema, String targetTableName, ColumnFun<T, R> ... columns) {
        this.jdbcTemplate.update(SqlBeanProvider.backupSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (Wrapper)wrapper, (String)targetSchema, (String)targetTableName, (Column[])SqlBeanUtil.funToColumn(columns)));
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> void backup(ConditionHandle<T> cond, String targetSchema, String targetTableName, ColumnFun<T, R> ... columns) {
        this.backup(super.conditionHandle(cond), targetSchema, targetTableName, columns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int copy(Wrapper wrapper, String targetTableName) {
        return this.jdbcTemplate.update(SqlBeanProvider.copySql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (Wrapper)wrapper, null, (String)targetTableName, null));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int copy(ConditionHandle<T> cond, String targetTableName) {
        return this.copy(super.conditionHandle(cond), targetTableName);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int copy(Wrapper wrapper, String targetSchema, String targetTableName) {
        return this.jdbcTemplate.update(SqlBeanProvider.copySql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (Wrapper)wrapper, (String)targetSchema, (String)targetTableName, null));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int copy(ConditionHandle<T> cond, String targetSchema, String targetTableName) {
        return this.copy(super.conditionHandle(cond), targetSchema, targetTableName);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int copy(Wrapper wrapper, String targetTableName, Column ... columns) {
        return this.jdbcTemplate.update(SqlBeanProvider.copySql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (Wrapper)wrapper, null, (String)targetTableName, (Column[])columns));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int copy(ConditionHandle<T> cond, String targetTableName, Column ... columns) {
        return this.copy(super.conditionHandle(cond), targetTableName, columns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> int copy(Wrapper wrapper, String targetTableName, ColumnFun<T, R> ... columns) {
        return this.jdbcTemplate.update(SqlBeanProvider.copySql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (Wrapper)wrapper, null, (String)targetTableName, (Column[])SqlBeanUtil.funToColumn(columns)));
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> int copy(ConditionHandle<T> cond, String targetTableName, ColumnFun<T, R> ... columns) {
        return this.copy(super.conditionHandle(cond), targetTableName, columns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int copy(Wrapper wrapper, String targetSchema, String targetTableName, Column ... columns) {
        return this.jdbcTemplate.update(SqlBeanProvider.copySql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (Wrapper)wrapper, (String)targetSchema, (String)targetTableName, (Column[])columns));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int copy(ConditionHandle<T> cond, String targetSchema, String targetTableName, Column ... columns) {
        return this.copy(super.conditionHandle(cond), targetSchema, targetTableName, columns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> int copy(Wrapper wrapper, String targetSchema, String targetTableName, ColumnFun<T, R> ... columns) {
        return this.jdbcTemplate.update(SqlBeanProvider.copySql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (Wrapper)wrapper, (String)targetSchema, (String)targetTableName, (Column[])SqlBeanUtil.funToColumn(columns)));
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> int copy(ConditionHandle<T> cond, String targetSchema, String targetTableName, ColumnFun<T, R> ... columns) {
        return this.copy(super.conditionHandle(cond), targetSchema, targetTableName, columns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int alter(Table table, List<ColumnInfo> columnInfoList) {
        List sqlList = SqlBeanProvider.buildAlterSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, columnInfoList);
        int count = 0;
        if (sqlList != null && sqlList.size() > 0) {
            for (String sql : sqlList) {
                count += this.jdbcTemplate.update(sql);
            }
        }
        return count;
    }

    @DbSwitch(value=DbRole.MASTER)
    public int alter(Alter alter) {
        ArrayList<Alter> alterList = new ArrayList<Alter>();
        alterList.add(alter);
        return this.alter(alterList);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int alter(List<Alter> alterList) {
        List sqlList = SqlBeanProvider.alterSql((DbType)this.getSqlBeanMeta().getDbType(), alterList);
        int count = 0;
        if (sqlList != null && sqlList.size() > 0) {
            for (String sql : sqlList) {
                count += this.jdbcTemplate.update(sql);
            }
        }
        return count;
    }

    @DbSwitch(value=DbRole.MASTER)
    public int alterRemarks(String remarks) {
        if (this.getSqlBeanMeta().getDbType() == DbType.SQLite || this.getSqlBeanMeta().getDbType() == DbType.Derby) {
            return 0;
        }
        String sql = SqlBeanProvider.alterRemarksSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (String)remarks);
        return this.jdbcTemplate.update(sql);
    }

    @DbSwitch(value=DbRole.MASTER)
    public List<String> getSchemas(String name) {
        if (this.getSqlBeanMeta().getDbType() == DbType.SQLite) {
            return null;
        }
        String sql = SqlBeanProvider.databaseSql((SqlBeanMeta)this.getSqlBeanMeta(), (String)name);
        return this.jdbcTemplate.query(sql, new SpringJdbcSqlBeanMapper(this.clazz, String.class));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int createSchema(String name) {
        if (this.getSqlBeanMeta().getDbType() == DbType.SQLite || this.getSqlBeanMeta().getDbType() == DbType.Oracle) {
            return 0;
        }
        String sql = SqlBeanProvider.createSchemaSql((SqlBeanMeta)this.getSqlBeanMeta(), (String)name);
        return this.jdbcTemplate.update(sql);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int dropSchema(String name) {
        if (this.getSqlBeanMeta().getDbType() == DbType.SQLite || this.getSqlBeanMeta().getDbType() == DbType.Oracle) {
            return 0;
        }
        String sql = SqlBeanProvider.dropSchemaSql((SqlBeanMeta)this.getSqlBeanMeta(), (String)name);
        return this.jdbcTemplate.update(sql);
    }

    @DbSwitch(value=DbRole.MASTER)
    public void dropTable() {
        List nameList;
        SqlBeanMeta sqlBeanMeta = this.getSqlBeanMeta();
        if (sqlBeanMeta.getDbType() != DbType.MySQL && sqlBeanMeta.getDbType() != DbType.MariaDB && sqlBeanMeta.getDbType() != DbType.Postgresql && sqlBeanMeta.getDbType() != DbType.SQLServer && sqlBeanMeta.getDbType() != DbType.H2 && ((nameList = this.jdbcTemplate.queryForList(SqlBeanProvider.selectTableListSql((SqlBeanMeta)sqlBeanMeta, (String)SqlBeanUtil.getTable(this.clazz).getSchema(), (String)SqlBeanUtil.getTable(this.clazz).getName()), TableInfo.class)) == null || nameList.isEmpty())) {
            return;
        }
        this.jdbcTemplate.update(SqlBeanProvider.dropTableSql((SqlBeanMeta)sqlBeanMeta, this.clazz));
    }

    @DbSwitch(value=DbRole.MASTER)
    public void createTable() {
        this.jdbcTemplate.update(SqlBeanProvider.createTableSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz));
    }

    @DbSwitch(value=DbRole.MASTER)
    public void dropAndCreateTable() {
        this.dropTable();
        this.createTable();
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<TableInfo> getTableList() {
        return this.getTableList(SqlBeanUtil.getTable(this.clazz).getSchema(), null);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<TableInfo> getTableList(String tableName) {
        return this.getTableList(SqlBeanUtil.getTable(this.clazz).getSchema(), tableName);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<TableInfo> getTableList(String schema, String tableName) {
        return this.jdbcTemplate.query(SqlBeanProvider.selectTableListSql((SqlBeanMeta)this.getSqlBeanMeta(), (String)schema, (String)tableName), new SpringJdbcSqlBeanMapper(TableInfo.class, TableInfo.class));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<ColumnInfo> getColumnInfoList() {
        Table table = SqlBeanUtil.getTable(this.clazz);
        return this.getColumnInfoList(table.getSchema(), table.getName());
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<ColumnInfo> getColumnInfoList(String tableName) {
        return this.getColumnInfoList(SqlBeanUtil.getTable(this.clazz).getSchema(), tableName);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<ColumnInfo> getColumnInfoList(String schema, String tableName) {
        List columnInfoList = this.jdbcTemplate.query(SqlBeanProvider.selectColumnListSql((SqlBeanMeta)this.getSqlBeanMeta(), (String)schema, (String)tableName), new SpringJdbcSqlBeanMapper(ColumnInfo.class, ColumnInfo.class));
        super.handleColumnInfo(columnInfoList);
        return columnInfoList;
    }

    private static <T> T singleResult(Collection<T> results) {
        int size;
        int n = size = results != null ? results.size() : 0;
        if (size == 0) {
            return null;
        }
        if (results.size() > 1) {
            throw new SqlBeanException("\u6267\u884c\u8fd4\u56de\u7684\u7ed3\u679c\u4e0d\u6b62\u4e00\u6761, size: " + results.size());
        }
        return results.iterator().next();
    }
}

