/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.spring.service;

import cn.vonce.sql.bean.Alter;
import cn.vonce.sql.bean.Column;
import cn.vonce.sql.bean.ColumnInfo;
import cn.vonce.sql.bean.Delete;
import cn.vonce.sql.bean.Insert;
import cn.vonce.sql.bean.Paging;
import cn.vonce.sql.bean.Select;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.bean.TableInfo;
import cn.vonce.sql.bean.Update;
import cn.vonce.sql.config.SqlBeanMeta;
import cn.vonce.sql.define.ColumnFun;
import cn.vonce.sql.define.ConditionHandle;
import cn.vonce.sql.enumerate.DbType;
import cn.vonce.sql.exception.SqlBeanException;
import cn.vonce.sql.helper.Wrapper;
import cn.vonce.sql.java.annotation.DbSwitch;
import cn.vonce.sql.java.annotation.DbTransactional;
import cn.vonce.sql.java.dao.MybatisSqlBeanDao;
import cn.vonce.sql.java.enumerate.DbRole;
import cn.vonce.sql.java.service.BaseSqlBeanServiceImpl;
import cn.vonce.sql.page.PageHelper;
import cn.vonce.sql.page.PagingService;
import cn.vonce.sql.page.ResultData;
import cn.vonce.sql.provider.SqlBeanProvider;
import cn.vonce.sql.service.AdvancedDbManageService;
import cn.vonce.sql.service.SqlBeanService;
import cn.vonce.sql.spring.config.UseMybatis;
import cn.vonce.sql.uitls.DateUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@UseMybatis
@Service
public class MybatisSqlBeanServiceImpl<T, ID>
extends BaseSqlBeanServiceImpl<T>
implements SqlBeanService<T, ID>,
AdvancedDbManageService<T> {
    @Autowired
    private MybatisSqlBeanDao<T> mybatisSqlBeanDao;
    private final Class<?> clazz;
    @Autowired
    @Qualifier(value="sqlBeanConfigForMybatis")
    private SqlBeanMeta sqlBeanMeta;

    public MybatisSqlBeanServiceImpl() {
        List classes = SqlBeanUtil.getGenericTypeBySuperclass(((Object)((Object)this)).getClass());
        this.clazz = !classes.isEmpty() ? (Class)classes.get(0) : null;
    }

    public SqlBeanMeta getSqlBeanMeta() {
        return super.setSqlBeanMeta(this.sqlBeanMeta);
    }

    public Long getAutoIncrId() {
        if (this.getSqlBeanMeta().getDbType() == DbType.MySQL || this.getSqlBeanMeta().getDbType() == DbType.MariaDB) {
            return this.mybatisSqlBeanDao.lastInsertId();
        }
        return null;
    }

    public Class<?> getBeanClass() {
        return this.clazz;
    }

    @DbSwitch(value=DbRole.SLAVE)
    public T selectById(ID id) {
        if (id == null) {
            return null;
        }
        return (T)this.mybatisSqlBeanDao.selectById(this.getSqlBeanMeta(), this.clazz, id);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> R selectById(Class<R> returnType, ID id) {
        if (id == null) {
            return null;
        }
        return (R)this.mybatisSqlBeanDao.selectByIdO(this.getSqlBeanMeta(), this.clazz, returnType, id);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> selectByIds(ID ... ids) {
        if (ids == null || ids.length == 0) {
            throw new SqlBeanException("selectByIds\u65b9\u6cd5ids\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.mybatisSqlBeanDao.selectByIds(this.getSqlBeanMeta(), this.clazz, (Object[])ids);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> selectByIds(Class<R> returnType, ID ... ids) {
        if (ids == null || ids.length == 0) {
            throw new SqlBeanException("selectByIds\u65b9\u6cd5ids\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.mybatisSqlBeanDao.selectByIdsO(this.getSqlBeanMeta(), this.clazz, returnType, (Object[])ids);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public T selectOne(Select select) {
        return (T)this.mybatisSqlBeanDao.selectOne(this.getSqlBeanMeta(), this.clazz, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> R selectOne(Class<R> returnType, Select select) {
        return (R)this.mybatisSqlBeanDao.selectOneO(this.getSqlBeanMeta(), this.clazz, returnType, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public Map<String, Object> selectMap(Select select) {
        return this.mybatisSqlBeanDao.selectMap(this.getSqlBeanMeta(), this.clazz, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public T selectOneBy(String where, Object ... args) {
        return (T)this.mybatisSqlBeanDao.selectOneBy(this.getSqlBeanMeta(), this.clazz, where, args);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> R selectOneBy(Class<R> returnType, String where, Object ... args) {
        return (R)this.mybatisSqlBeanDao.selectOneByO(this.getSqlBeanMeta(), this.clazz, returnType, where, args);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public T selectOneBy(Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        return (T)this.mybatisSqlBeanDao.selectOne(this.getSqlBeanMeta(), this.clazz, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public T selectOneBy(ConditionHandle<T> cond) {
        return this.selectOneBy(super.conditionHandle(cond));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> R selectOneBy(Class<R> returnType, Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        return (R)this.mybatisSqlBeanDao.selectOneO(this.getSqlBeanMeta(), this.clazz, returnType, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> R selectOneBy(Class<R> returnType, ConditionHandle<T> cond) {
        return this.selectOneBy(returnType, super.conditionHandle(cond));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> selectBy(Class<R> returnType, String where, Object ... args) {
        return this.mybatisSqlBeanDao.selectByO(this.getSqlBeanMeta(), this.clazz, returnType, null, where, args);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> selectBy(Class<R> returnType, Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        return this.mybatisSqlBeanDao.selectO(this.getSqlBeanMeta(), this.clazz, returnType, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> selectBy(Class<R> returnType, ConditionHandle<T> cond) {
        return this.selectBy(returnType, super.conditionHandle(cond));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> selectBy(Class<R> returnType, Paging paging, String where, Object ... args) {
        return this.mybatisSqlBeanDao.selectByO(this.getSqlBeanMeta(), this.clazz, returnType, paging, where, args);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> selectBy(Class<R> returnType, Paging paging, Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        select.page(paging.getPagenum(), paging.getPagesize(), paging.getStartByZero());
        select.orderBy(paging.getOrders());
        return this.mybatisSqlBeanDao.selectO(this.getSqlBeanMeta(), this.clazz, returnType, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> selectBy(Class<R> returnType, Paging paging, ConditionHandle<T> cond) {
        return this.selectBy(returnType, paging, super.conditionHandle(cond));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> selectBy(String where, Object ... args) {
        return this.mybatisSqlBeanDao.selectBy(this.getSqlBeanMeta(), this.clazz, null, where, args);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> selectBy(Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        return this.mybatisSqlBeanDao.select(this.getSqlBeanMeta(), this.clazz, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> selectBy(ConditionHandle<T> cond) {
        return this.selectBy(super.conditionHandle(cond));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> selectBy(Paging paging, String where, Object ... args) {
        return this.mybatisSqlBeanDao.selectBy(this.getSqlBeanMeta(), this.clazz, paging, where, args);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> selectBy(Paging paging, Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        select.page(paging.getPagenum(), paging.getPagesize(), paging.getStartByZero());
        select.orderBy(paging.getOrders());
        return this.mybatisSqlBeanDao.select(this.getSqlBeanMeta(), this.clazz, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> selectBy(Paging paging, ConditionHandle<T> cond) {
        return this.selectBy(paging, super.conditionHandle(cond));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public int countBy(String where, Object ... args) {
        return this.mybatisSqlBeanDao.countBy(this.getSqlBeanMeta(), this.clazz, where, args);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public int countBy(Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        return this.mybatisSqlBeanDao.count(this.getSqlBeanMeta(), this.clazz, null, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public int countBy(ConditionHandle<T> cond) {
        return this.countBy(super.conditionHandle(cond));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public int count() {
        return this.mybatisSqlBeanDao.countBy(this.getSqlBeanMeta(), this.clazz, null, new Object[0]);
    }

    @DbSwitch(value=DbRole.MASTER)
    public List<T> select() {
        return this.mybatisSqlBeanDao.selectAll(this.getSqlBeanMeta(), this.clazz, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public List<T> select(Paging paging) {
        return this.mybatisSqlBeanDao.selectAll(this.getSqlBeanMeta(), this.clazz, paging);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> List<R> select(Class<R> returnType) {
        return this.mybatisSqlBeanDao.selectAllO(this.getSqlBeanMeta(), this.clazz, returnType, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> List<R> select(Class<R> returnType, Paging paging) {
        return this.mybatisSqlBeanDao.selectAllO(this.getSqlBeanMeta(), this.clazz, returnType, paging);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<Map<String, Object>> selectMapList(Select select) {
        return this.mybatisSqlBeanDao.selectMapList(this.getSqlBeanMeta(), this.clazz, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> select(Class<R> returnType, Select select) {
        return this.mybatisSqlBeanDao.selectO(this.getSqlBeanMeta(), this.clazz, returnType, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> select(Select select) {
        return this.mybatisSqlBeanDao.select(this.getSqlBeanMeta(), this.clazz, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public int count(Select select) {
        return this.mybatisSqlBeanDao.count(this.getSqlBeanMeta(), this.clazz, null, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public int count(Class<?> returnType, Select select) {
        return this.mybatisSqlBeanDao.count(this.getSqlBeanMeta(), this.clazz, returnType, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public ResultData<T> paging(Select select, PageHelper<T> pageHelper) {
        pageHelper.paging(select, (PagingService)this);
        return pageHelper.getResultData();
    }

    @DbSwitch(value=DbRole.SLAVE)
    public ResultData<T> paging(Select select, int pagenum, int pagesize) {
        PageHelper pageHelper = new PageHelper(Integer.valueOf(pagenum), Integer.valueOf(pagesize));
        pageHelper.paging(select, (PagingService)this);
        return pageHelper.getResultData();
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> ResultData<R> paging(Class<R> returnType, Select select, PageHelper<R> pageHelper) {
        pageHelper.paging(returnType, select, (PagingService)this);
        return pageHelper.getResultData();
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> ResultData<R> paging(Class<R> returnType, Select select, int pagenum, int pagesize) {
        PageHelper pageHelper = new PageHelper(Integer.valueOf(pagenum), Integer.valueOf(pagesize));
        pageHelper.paging(returnType, select, (PagingService)this);
        return pageHelper.getResultData();
    }

    @DbSwitch(value=DbRole.MASTER)
    public int deleteById(ID ... id) {
        if (id == null || id.length == 0) {
            throw new SqlBeanException("deleteById\u65b9\u6cd5id\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.mybatisSqlBeanDao.deleteById(this.getSqlBeanMeta(), this.clazz, id);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int deleteBy(String where, Object ... args) {
        return this.mybatisSqlBeanDao.deleteBy(this.getSqlBeanMeta(), this.clazz, where, args);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int deleteBy(Wrapper wrapper) {
        Delete delete = new Delete();
        delete.where(wrapper);
        return this.mybatisSqlBeanDao.delete(this.getSqlBeanMeta(), this.clazz, delete, false);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int deleteBy(ConditionHandle<T> cond) {
        return this.deleteBy(super.conditionHandle(cond));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int delete(Delete delete) {
        return this.mybatisSqlBeanDao.delete(this.getSqlBeanMeta(), this.clazz, delete, false);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int delete(Delete delete, boolean ignore) {
        return this.mybatisSqlBeanDao.delete(this.getSqlBeanMeta(), this.clazz, delete, ignore);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int logicallyDeleteById(ID ... id) {
        if (id == null || id.length == 0) {
            throw new SqlBeanException("logicallyDeleteById\u65b9\u6cd5id\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.mybatisSqlBeanDao.logicallyDeleteById(this.getSqlBeanMeta(), this.clazz, id);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int logicallyDeleteBy(String where, Object ... args) {
        return this.mybatisSqlBeanDao.logicallyDeleteBy(this.getSqlBeanMeta(), this.clazz, where, args);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int logicallyDeleteBy(Wrapper wrapper) {
        return this.mybatisSqlBeanDao.logicallyDeleteByWrapper(this.getSqlBeanMeta(), this.clazz, wrapper);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int logicallyDeleteBy(ConditionHandle<T> cond) {
        return this.logicallyDeleteBy(super.conditionHandle(cond));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int update(Update<T> update) {
        return this.mybatisSqlBeanDao.update(this.getSqlBeanMeta(), this.clazz, update, false);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int update(Update<T> update, boolean ignore) {
        return this.mybatisSqlBeanDao.update(this.getSqlBeanMeta(), this.clazz, update, ignore);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateById(T bean, ID id) {
        return this.mybatisSqlBeanDao.updateById(this.getSqlBeanMeta(), this.clazz, bean, id, true, false, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateById(T bean, ID id, boolean updateNotNull, boolean optimisticLock) {
        return this.mybatisSqlBeanDao.updateById(this.getSqlBeanMeta(), this.clazz, bean, id, updateNotNull, optimisticLock, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateByBeanId(T bean) {
        return this.mybatisSqlBeanDao.updateByBeanId(this.getSqlBeanMeta(), this.clazz, bean, true, false, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateById(T bean, ID id, boolean updateNotNull, boolean optimisticLock, Column ... filterColumns) {
        return this.mybatisSqlBeanDao.updateById(this.getSqlBeanMeta(), this.clazz, bean, id, updateNotNull, optimisticLock, filterColumns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> int updateById(T bean, ID id, boolean updateNotNull, boolean optimisticLock, ColumnFun<T, R> ... filterColumns) {
        return this.mybatisSqlBeanDao.updateById(this.getSqlBeanMeta(), this.clazz, bean, id, updateNotNull, optimisticLock, SqlBeanUtil.funToColumn(filterColumns));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, String where, Object ... args) {
        return this.mybatisSqlBeanDao.updateByBeanId(this.getSqlBeanMeta(), this.clazz, bean, true, false, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateByBeanId(T bean, boolean updateNotNull, boolean optimisticLock) {
        return this.mybatisSqlBeanDao.updateByBeanId(this.getSqlBeanMeta(), this.clazz, bean, updateNotNull, optimisticLock, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateByBeanId(T bean, boolean updateNotNull, boolean optimisticLock, Column ... filterColumns) {
        return this.mybatisSqlBeanDao.updateByBeanId(this.getSqlBeanMeta(), this.clazz, bean, updateNotNull, optimisticLock, filterColumns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> int updateByBeanId(T bean, boolean updateNotNull, boolean optimisticLock, ColumnFun<T, R> ... filterColumns) {
        return this.mybatisSqlBeanDao.updateByBeanId(this.getSqlBeanMeta(), this.clazz, bean, updateNotNull, optimisticLock, SqlBeanUtil.funToColumn(filterColumns));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, String where, Object ... args) {
        return this.mybatisSqlBeanDao.updateBy(this.getSqlBeanMeta(), this.clazz, bean, updateNotNull, optimisticLock, null, where, args);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, Wrapper wrapper) {
        Update update = new Update();
        update.bean(bean).notNull(true).optimisticLock(false).where(wrapper);
        return this.mybatisSqlBeanDao.update(this.getSqlBeanMeta(), this.clazz, update, false);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, ConditionHandle<T> cond) {
        return this.updateBy(bean, super.conditionHandle(cond));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, Wrapper wrapper) {
        Update update = new Update();
        update.bean(bean).notNull(updateNotNull).optimisticLock(optimisticLock).where(wrapper);
        return this.mybatisSqlBeanDao.update(this.getSqlBeanMeta(), this.clazz, update, false);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, ConditionHandle<T> cond) {
        return this.updateBy(bean, updateNotNull, optimisticLock, super.conditionHandle(cond));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, Column[] filterColumns, String where, Object ... args) {
        return this.mybatisSqlBeanDao.updateBy(this.getSqlBeanMeta(), this.clazz, bean, updateNotNull, optimisticLock, filterColumns, where, args);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, Wrapper wrapper, Column ... filterColumns) {
        Update update = new Update();
        update.bean(bean).notNull(updateNotNull).optimisticLock(optimisticLock).filterFields(filterColumns).where(wrapper);
        return this.mybatisSqlBeanDao.update(this.getSqlBeanMeta(), this.clazz, update, false);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, ConditionHandle<T> cond, Column ... filterColumns) {
        return this.updateBy(bean, updateNotNull, optimisticLock, super.conditionHandle(cond), filterColumns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, Wrapper wrapper, ColumnFun<T, R> ... filterColumns) {
        return this.updateBy(bean, updateNotNull, optimisticLock, wrapper, SqlBeanUtil.funToColumn(filterColumns));
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, ConditionHandle<T> cond, ColumnFun<T, R> ... filterColumns) {
        return this.updateBy(bean, updateNotNull, optimisticLock, super.conditionHandle(cond), filterColumns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateByBean(T bean, String where) {
        return this.mybatisSqlBeanDao.updateByBean(this.getSqlBeanMeta(), this.clazz, bean, true, false, where, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateByBean(T bean, boolean updateNotNull, boolean optimisticLock, String where) {
        return this.mybatisSqlBeanDao.updateByBean(this.getSqlBeanMeta(), this.clazz, bean, updateNotNull, optimisticLock, where, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateByBean(T bean, boolean updateNotNull, boolean optimisticLock, String where, Column ... filterColumns) {
        return this.mybatisSqlBeanDao.updateByBean(this.getSqlBeanMeta(), this.clazz, bean, updateNotNull, optimisticLock, where, filterColumns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> int updateByBean(T bean, boolean updateNotNull, boolean optimisticLock, String where, ColumnFun<T, R> ... filterColumns) {
        return this.mybatisSqlBeanDao.updateByBean(this.getSqlBeanMeta(), this.clazz, bean, updateNotNull, optimisticLock, where, SqlBeanUtil.funToColumn(filterColumns));
    }

    @Transactional
    @DbTransactional
    @DbSwitch(value=DbRole.MASTER)
    public int insert(T ... bean) {
        if (bean == null || bean.length == 0) {
            throw new SqlBeanException("insert\u65b9\u6cd5bean\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        List<T> beanList = Arrays.asList(bean);
        int count = this.mybatisSqlBeanDao.insertBean(this.getSqlBeanMeta(), this.clazz, beanList);
        super.setAutoIncrId(this.clazz, beanList);
        return count;
    }

    @Transactional
    @DbTransactional
    @DbSwitch(value=DbRole.MASTER)
    public int insert(Collection<T> beanList) {
        if (beanList == null || beanList.size() == 0) {
            throw new SqlBeanException("insert\u65b9\u6cd5beanList\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        int count = this.mybatisSqlBeanDao.insertBean(this.getSqlBeanMeta(), this.clazz, beanList);
        super.setAutoIncrId(this.clazz, beanList);
        return count;
    }

    @Transactional
    @DbTransactional
    @DbSwitch(value=DbRole.MASTER)
    public int insert(Insert<T> insert) {
        int count = this.mybatisSqlBeanDao.insert(this.getSqlBeanMeta(), this.clazz, insert);
        super.setAutoIncrId(this.clazz, (Collection)insert.getBean());
        return count;
    }

    @DbSwitch(value=DbRole.MASTER)
    public String backup() {
        String targetTableName = SqlBeanUtil.getTable(this.clazz).getName() + "_" + DateUtil.dateToString((Date)new Date(), (String)"yyyyMMddHHmmssSSS");
        this.mybatisSqlBeanDao.backup(this.getSqlBeanMeta(), this.clazz, null, null, targetTableName, null);
        return targetTableName;
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(String targetTableName) {
        this.mybatisSqlBeanDao.backup(this.getSqlBeanMeta(), this.clazz, null, null, targetTableName, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(String targetSchema, String targetTableName) {
        this.mybatisSqlBeanDao.backup(this.getSqlBeanMeta(), this.clazz, null, targetSchema, targetTableName, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(Wrapper wrapper, String targetSchema, String targetTableName) {
        this.mybatisSqlBeanDao.backup(this.getSqlBeanMeta(), this.clazz, wrapper, targetSchema, targetTableName, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(ConditionHandle<T> cond, String targetSchema, String targetTableName) {
        this.backup(super.conditionHandle(cond), targetSchema, targetTableName);
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(Wrapper wrapper, String targetTableName, Column ... columns) {
        this.mybatisSqlBeanDao.backup(this.getSqlBeanMeta(), this.clazz, wrapper, null, targetTableName, columns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(ConditionHandle<T> cond, String targetTableName, Column ... columns) {
        this.backup(super.conditionHandle(cond), targetTableName, columns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> void backup(Wrapper wrapper, String targetTableName, ColumnFun<T, R> ... columns) {
        this.mybatisSqlBeanDao.backup(this.getSqlBeanMeta(), this.clazz, wrapper, null, targetTableName, SqlBeanUtil.funToColumn(columns));
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> void backup(ConditionHandle<T> cond, String targetTableName, ColumnFun<T, R> ... columns) {
        this.backup(super.conditionHandle(cond), targetTableName, columns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(Wrapper wrapper, String targetSchema, String targetTableName, Column ... columns) {
        this.mybatisSqlBeanDao.backup(this.getSqlBeanMeta(), this.clazz, wrapper, targetSchema, targetTableName, columns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(ConditionHandle<T> cond, String targetSchema, String targetTableName, Column ... columns) {
        this.backup(super.conditionHandle(cond), targetSchema, targetTableName, columns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> void backup(Wrapper wrapper, String targetSchema, String targetTableName, ColumnFun<T, R> ... columns) {
        this.mybatisSqlBeanDao.backup(this.getSqlBeanMeta(), this.clazz, wrapper, targetSchema, targetTableName, SqlBeanUtil.funToColumn(columns));
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> void backup(ConditionHandle<T> cond, String targetSchema, String targetTableName, ColumnFun<T, R> ... columns) {
        this.backup(super.conditionHandle(cond), targetSchema, targetTableName, columns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int copy(Wrapper wrapper, String targetTableName) {
        return this.mybatisSqlBeanDao.copy(this.getSqlBeanMeta(), this.clazz, wrapper, null, targetTableName, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int copy(ConditionHandle<T> cond, String targetTableName) {
        return this.copy(super.conditionHandle(cond), targetTableName);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int copy(Wrapper wrapper, String targetSchema, String targetTableName) {
        return this.mybatisSqlBeanDao.copy(this.getSqlBeanMeta(), this.clazz, wrapper, targetSchema, targetTableName, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int copy(ConditionHandle<T> cond, String targetSchema, String targetTableName) {
        return this.copy(super.conditionHandle(cond), targetSchema, targetTableName);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int copy(Wrapper wrapper, String targetTableName, Column ... columns) {
        return this.mybatisSqlBeanDao.copy(this.getSqlBeanMeta(), this.clazz, wrapper, null, targetTableName, columns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int copy(ConditionHandle<T> cond, String targetTableName, Column ... columns) {
        return this.copy(super.conditionHandle(cond), targetTableName, columns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> int copy(Wrapper wrapper, String targetTableName, ColumnFun<T, R> ... columns) {
        return this.mybatisSqlBeanDao.copy(this.getSqlBeanMeta(), this.clazz, wrapper, null, targetTableName, SqlBeanUtil.funToColumn(columns));
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> int copy(ConditionHandle<T> cond, String targetTableName, ColumnFun<T, R> ... columns) {
        return this.copy(super.conditionHandle(cond), targetTableName, columns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int copy(Wrapper wrapper, String targetSchema, String targetTableName, Column ... columns) {
        return this.mybatisSqlBeanDao.copy(this.getSqlBeanMeta(), this.clazz, wrapper, targetSchema, targetTableName, columns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int copy(ConditionHandle<T> cond, String targetSchema, String targetTableName, Column ... columns) {
        return this.copy(super.conditionHandle(cond), targetSchema, targetTableName, columns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> int copy(Wrapper wrapper, String targetSchema, String targetTableName, ColumnFun<T, R> ... columns) {
        return this.mybatisSqlBeanDao.copy(this.getSqlBeanMeta(), this.clazz, wrapper, targetSchema, targetTableName, SqlBeanUtil.funToColumn(columns));
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> int copy(ConditionHandle<T> cond, String targetSchema, String targetTableName, ColumnFun<T, R> ... columns) {
        return this.copy(super.conditionHandle(cond), targetSchema, targetTableName, columns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int alter(Table table, List<ColumnInfo> columnInfoList) {
        List sqlList = SqlBeanProvider.buildAlterSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, columnInfoList);
        int count = 0;
        if (sqlList != null && sqlList.size() > 0) {
            for (String sql : sqlList) {
                count += this.mybatisSqlBeanDao.executeSql(sql);
            }
        }
        return count;
    }

    @DbSwitch(value=DbRole.MASTER)
    public int alter(Alter alter) {
        ArrayList<Alter> alterList = new ArrayList<Alter>();
        alterList.add(alter);
        return this.alter(alterList);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int alter(List<Alter> alterList) {
        List sqlList = SqlBeanProvider.alterSql((DbType)this.getSqlBeanMeta().getDbType(), alterList);
        int count = 0;
        if (sqlList != null && sqlList.size() > 0) {
            for (String sql : sqlList) {
                count += this.mybatisSqlBeanDao.executeSql(sql);
            }
        }
        return count;
    }

    @DbSwitch(value=DbRole.MASTER)
    public int alterRemarks(String remarks) {
        if (this.getSqlBeanMeta().getDbType() == DbType.SQLite || this.getSqlBeanMeta().getDbType() == DbType.Derby) {
            return 0;
        }
        String sql = SqlBeanProvider.alterRemarksSql((SqlBeanMeta)this.getSqlBeanMeta(), this.clazz, (String)remarks);
        return this.mybatisSqlBeanDao.executeSql(sql);
    }

    @DbSwitch(value=DbRole.MASTER)
    public List<String> getSchemas(String name) {
        if (this.getSqlBeanMeta().getDbType() == DbType.SQLite) {
            return null;
        }
        return this.mybatisSqlBeanDao.databases(this.getSqlBeanMeta(), name);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int createSchema(String name) {
        if (this.getSqlBeanMeta().getDbType() == DbType.SQLite || this.getSqlBeanMeta().getDbType() == DbType.Oracle) {
            return 0;
        }
        return this.mybatisSqlBeanDao.createSchema(this.getSqlBeanMeta(), name);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int dropSchema(String name) {
        if (this.getSqlBeanMeta().getDbType() == DbType.SQLite || this.getSqlBeanMeta().getDbType() == DbType.Oracle) {
            return 0;
        }
        return this.mybatisSqlBeanDao.dropSchema(this.getSqlBeanMeta(), name);
    }

    @DbSwitch(value=DbRole.MASTER)
    public void dropTable() {
        List nameList;
        SqlBeanMeta sqlBeanMeta = this.getSqlBeanMeta();
        if (sqlBeanMeta.getDbType() != DbType.MySQL && sqlBeanMeta.getDbType() != DbType.MariaDB && sqlBeanMeta.getDbType() != DbType.Postgresql && sqlBeanMeta.getDbType() != DbType.SQLServer && sqlBeanMeta.getDbType() != DbType.H2 && ((nameList = this.mybatisSqlBeanDao.selectTableList(this.getSqlBeanMeta(), SqlBeanUtil.getTable(this.clazz).getSchema(), SqlBeanUtil.getTable(this.clazz).getName())) == null || nameList.isEmpty())) {
            return;
        }
        this.mybatisSqlBeanDao.drop(sqlBeanMeta, this.clazz);
    }

    @DbSwitch(value=DbRole.MASTER)
    public void createTable() {
        this.mybatisSqlBeanDao.create(this.getSqlBeanMeta(), this.clazz);
    }

    @DbSwitch(value=DbRole.MASTER)
    public void dropAndCreateTable() {
        this.dropTable();
        this.createTable();
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<TableInfo> getTableList() {
        return this.getTableList(SqlBeanUtil.getTable(this.clazz).getSchema(), null);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<TableInfo> getTableList(String tableName) {
        return this.getTableList(SqlBeanUtil.getTable(this.clazz).getSchema(), tableName);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<TableInfo> getTableList(String schema, String tableName) {
        return this.mybatisSqlBeanDao.selectTableList(this.getSqlBeanMeta(), schema, tableName);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<ColumnInfo> getColumnInfoList() {
        Table table = SqlBeanUtil.getTable(this.clazz);
        return this.getColumnInfoList(table.getSchema(), table.getName());
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<ColumnInfo> getColumnInfoList(String tableName) {
        return this.getColumnInfoList(SqlBeanUtil.getTable(this.clazz).getSchema(), tableName);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<ColumnInfo> getColumnInfoList(String schema, String tableName) {
        List columnInfoList = this.mybatisSqlBeanDao.selectColumnInfoList(this.getSqlBeanMeta(), schema, tableName);
        super.handleColumnInfo(columnInfoList);
        return columnInfoList;
    }
}

