/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.spring.config;

import cn.vonce.sql.config.SqlBeanConfig;
import cn.vonce.sql.java.config.BaseAutoCreateTableListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class AutoCreateTableListener
extends BaseAutoCreateTableListener
implements ApplicationListener<ContextRefreshedEvent> {
    private ContextRefreshedEvent contextRefreshedEvent;
    private final Lock lock = new ReentrantLock();

    public void onApplicationEvent(ContextRefreshedEvent evt) {
        this.contextRefreshedEvent = evt;
        SqlBeanConfig sqlBeanConfig = evt.getApplicationContext().getBeansOfType(SqlBeanConfig.class).values().stream().findFirst().orElse(null);
        if (!(evt.getApplicationContext().getParent() != null && evt.getApplicationContext().getParent().getParent() != null || sqlBeanConfig != null && !sqlBeanConfig.getAutoCreate())) {
            this.lock.lock();
            try {
                new Thread(() -> this.processSqlBeanServices()).start();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public <T> T getBean(String name) {
        return (T)this.contextRefreshedEvent.getApplicationContext().getBean(name);
    }

    public <T> List<T> getBeansForType(Class<T> baseType) {
        Map beanMap = this.contextRefreshedEvent.getApplicationContext().getBeansOfType(baseType);
        if (beanMap != null) {
            return new ArrayList(beanMap.values());
        }
        return null;
    }

    public List<String> getBeanNamesForType(Class<?> baseType) {
        return Arrays.asList(this.contextRefreshedEvent.getApplicationContext().getBeanNamesForType(baseType));
    }
}

