/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.spring.config;

import cn.vonce.sql.java.annotation.DbTransactional;
import cn.vonce.sql.java.config.BaseAutoConfigMultiDataSource;
import cn.vonce.sql.spring.annotation.EnableAutoConfigMultiDataSource;
import cn.vonce.sql.spring.datasource.DynamicDataSource;
import cn.vonce.sql.spring.datasource.TransactionalInterceptor;
import cn.vonce.sql.uitls.StringUtil;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.type.AnnotationMetadata;

public class AutoConfigMultiDataSource
extends BaseAutoConfigMultiDataSource
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private StandardEnvironment environment;
    private Map<String, Object> propertyMap;

    public void setEnvironment(Environment environment) {
        if (environment instanceof StandardEnvironment) {
            this.environment = (StandardEnvironment)environment;
        }
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry beanDefinitionRegistry) {
        if (!(this.environment instanceof StandardEnvironment)) {
            this.logger.warning(String.format("Expected StandardEnvironment, but found: %s", this.environment.getClass().getName()));
            return;
        }
        MutablePropertySources propertySources = this.environment.getPropertySources();
        String defaultDataSource = null;
        LinkedHashSet<String> dataSourceNameSet = new LinkedHashSet<String>();
        String dataSourcePrefix = this.getDataSourcePrefix();
        this.propertyMap = new HashMap<String, Object>();
        for (PropertySource propertySource : propertySources) {
            Object map;
            String name = propertySource.getName();
            if (propertySource.getName().indexOf("[") >= 0 && propertySource.getName().indexOf("]") >= 0) {
                name = propertySource.getName().substring(propertySource.getName().indexOf("[") + 1, propertySource.getName().indexOf("]"));
            }
            if (name.indexOf("classpath:/") >= 0) {
                name = name.substring(name.indexOf("/") + 1);
            }
            if (!name.startsWith("application") || !((map = propertySource.getSource()) instanceof Map)) continue;
            for (Map.Entry entry : ((Map)map).entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith(dataSourcePrefix)) continue;
                key = key.substring(key.indexOf(dataSourcePrefix) + dataSourcePrefix.length() + 1);
                key = key.substring(0, key.indexOf("."));
                dataSourceNameSet.add(key);
                if (defaultDataSource == null) {
                    defaultDataSource = key;
                }
                this.propertyMap.put((String)entry.getKey(), entry.getValue());
            }
        }
        Map annotationAttributeMap = annotationMetadata.getAnnotationAttributes(EnableAutoConfigMultiDataSource.class.getName());
        String anonDefaultDataSource = (String)annotationAttributeMap.get("defaultDataSource");
        if (anonDefaultDataSource != null && StringUtil.isNotBlank((Object)anonDefaultDataSource)) {
            defaultDataSource = anonDefaultDataSource;
        }
        super.config(dataSourceNameSet, defaultDataSource, (defaultTargetDataSource, dataSourceMap) -> {
            BeanDefinitionBuilder definitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(DynamicDataSource.class);
            definitionBuilder.addPropertyValue("defaultTargetDataSource", (Object)defaultTargetDataSource);
            definitionBuilder.addPropertyValue("targetDataSources", (Object)dataSourceMap);
            beanDefinitionRegistry.registerBeanDefinition("dynamicDataSource", (BeanDefinition)definitionBuilder.getBeanDefinition());
            beanDefinitionRegistry.registerBeanDefinition("sqlBeanTransactional", this.transactionalDefinition());
        });
    }

    public Map<String, Object> getPropertyMap() {
        return this.propertyMap;
    }

    public String getProperty(String key) {
        return this.environment.getProperty(key);
    }

    public String getDataSourceType() {
        return "spring.datasource.type";
    }

    public String getDataSourcePrefix() {
        return "spring.datasource.sqlbean";
    }

    private BeanDefinition transactionalDefinition() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("@annotation(" + DbTransactional.class.getName() + ")");
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultPointcutAdvisor.class);
        beanDefinitionBuilder.addPropertyValue("pointcut", (Object)pointcut);
        beanDefinitionBuilder.addPropertyValue("advice", (Object)new TransactionalInterceptor());
        return beanDefinitionBuilder.getBeanDefinition();
    }
}

