package cn.vonce.sql.spring.enumerate;

/**
 * @author Jovi
 * @email imjovi@qq.com
 * @date 2022/12/14 14:38
 */
public enum DbIsolation {


    /**
     * DEFAULT为数据源（数据库）的默认隔离级别，以目前常用的MySQL为例，默认的隔离级别通常为REPEATABLE_READ
     */
    DEFAULT,

    /**
     * 最低的隔离级别，一个事务能读取到别的事务未提交的更新数据，很不安全，可能出现丢失更新、脏读、不可重复读、幻读。
     */
    READ_UNCOMMITTED,

    /**
     * 以操作同一行数据为前提，读事务允许其他读事务和写事务，未提交的写事务禁止其他读事务和写事务。此隔离级别可以防止更新丢失、脏读，但不能防止不可重复读、幻读。此隔离级别可以通过“瞬间共享读锁”和“排他写锁”实现。
     */
    READ_COMMITTED,

    /**
     * 保证同一事务中先后执行的多次查询将返回同一结果，不受其他事务影响。以操作同一行数据为前提，读事务禁止其他写事务，但允许其他读事务，未提交的写事务禁止其他读事务和写事务。此隔离级别可以防止更新丢失、脏读、不可重复读，但不能防止幻读。
     */
    REPEATABLE_READ,

    /**
     * 所有的事务依次逐个执行，这样事务之间就完全不可能产生干扰。提供严格的事务隔离，此隔离级别可以防止更新丢失、脏读、不可重复读、幻读。如果仅仅通过“行级锁”是无法实现事务序列化的，必须通过其他机制保证新插入的数据不会被刚执行查询操作的事务访问到。
     */
    SERIALIZABLE;

}
