/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.spring.service;

import cn.vonce.sql.bean.Column;
import cn.vonce.sql.bean.ColumnInfo;
import cn.vonce.sql.bean.Delete;
import cn.vonce.sql.bean.Insert;
import cn.vonce.sql.bean.Paging;
import cn.vonce.sql.bean.Select;
import cn.vonce.sql.bean.TableInfo;
import cn.vonce.sql.bean.Update;
import cn.vonce.sql.config.SqlBeanConfig;
import cn.vonce.sql.config.SqlBeanDB;
import cn.vonce.sql.enumerate.DbType;
import cn.vonce.sql.exception.SqlBeanException;
import cn.vonce.sql.helper.Wrapper;
import cn.vonce.sql.page.PageHelper;
import cn.vonce.sql.page.PagingService;
import cn.vonce.sql.page.ResultData;
import cn.vonce.sql.provider.SqlBeanProvider;
import cn.vonce.sql.service.SqlBeanService;
import cn.vonce.sql.service.TableService;
import cn.vonce.sql.spring.annotation.DbSwitch;
import cn.vonce.sql.spring.config.UseSpringJdbc;
import cn.vonce.sql.spring.enumerate.DbRole;
import cn.vonce.sql.spring.mapper.SpringJbdcSqlBeanMapper;
import cn.vonce.sql.spring.service.BaseSqlBeanServiceImpl;
import cn.vonce.sql.uitls.DateUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@UseSpringJdbc
@Service
public class SpringJdbcSqlBeanServiceImpl<T, ID>
extends BaseSqlBeanServiceImpl
implements SqlBeanService<T, ID>,
TableService {
    private Logger logger = LoggerFactory.getLogger(SpringJdbcSqlBeanServiceImpl.class);
    @Autowired(required=false)
    private SqlBeanConfig sqlBeanConfig;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private boolean initDBInfo;
    private Class<?> clazz;

    public SpringJdbcSqlBeanServiceImpl() {
        Type[] typeArray = new Type[]{this.getClass().getGenericSuperclass()};
        if (typeArray == null || typeArray.length == 0) {
            typeArray = this.getClass().getGenericInterfaces();
        }
        for (Type type : typeArray) {
            if (!(type instanceof ParameterizedType)) continue;
            Class trueTypeClass = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
            try {
                this.clazz = this.getClass().getClassLoader().loadClass(trueTypeClass.getName());
                return;
            }
            catch (ClassNotFoundException e) {
                this.logger.error(e.getMessage());
            }
        }
    }

    @Override
    public SqlBeanConfig getSqlBeanConfig() {
        return this.sqlBeanConfig;
    }

    @Override
    public SqlBeanDB initDBInfo() {
        SqlBeanDB sqlBeanDB = new SqlBeanDB();
        if (!this.initDBInfo) {
            try {
                Connection connection = this.jdbcTemplate.getDataSource().getConnection();
                DatabaseMetaData metaData = connection.getMetaData();
                super.sqlBeanDBFill(sqlBeanDB, metaData);
                connection.close();
                this.initDBInfo = true;
            }
            catch (SQLException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return sqlBeanDB;
    }

    public Class<?> getBeanClass() {
        return this.clazz;
    }

    @DbSwitch(value=DbRole.SLAVE)
    public T selectById(ID id) {
        if (id == null) {
            return null;
        }
        return SpringJdbcSqlBeanServiceImpl.singleResult(this.jdbcTemplate.query(SqlBeanProvider.selectByIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, id), new SpringJbdcSqlBeanMapper(this.clazz, this.clazz)));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> R selectById(Class<R> returnType, ID id) {
        if (id == null) {
            return null;
        }
        return (R)SpringJdbcSqlBeanServiceImpl.singleResult(this.jdbcTemplate.query(SqlBeanProvider.selectByIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, id), new SpringJbdcSqlBeanMapper(this.clazz, returnType)));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> selectByIds(ID ... ids) {
        if (ids == null || ids.length == 0) {
            throw new SqlBeanException("selectByIds\u65b9\u6cd5ids\u53c2\u6570\u5fc5\u987b\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.jdbcTemplate.query(SqlBeanProvider.selectByIdsSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (Object[])ids), new SpringJbdcSqlBeanMapper(this.clazz, this.clazz));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> selectByIds(Class<R> returnType, ID ... ids) {
        if (ids == null || ids.length == 0) {
            throw new SqlBeanException("selectByIds\u65b9\u6cd5ids\u53c2\u6570\u5fc5\u987b\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.jdbcTemplate.query(SqlBeanProvider.selectByIdsSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, (Object[])ids), new SpringJbdcSqlBeanMapper(this.clazz, returnType));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public T selectOne(Select select) {
        return SpringJdbcSqlBeanServiceImpl.singleResult(this.jdbcTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (Select)select), new SpringJbdcSqlBeanMapper(this.clazz, this.clazz)));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> R selectOne(Class<R> returnType, Select select) {
        return (R)SpringJdbcSqlBeanServiceImpl.singleResult(this.jdbcTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, (Select)select), new SpringJbdcSqlBeanMapper(this.clazz, returnType)));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public Map<String, Object> selectMap(Select select) {
        return (Map)SpringJdbcSqlBeanServiceImpl.singleResult(this.jdbcTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (Select)select), new SpringJbdcSqlBeanMapper(this.clazz, Map.class)));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public T selectOneBy(String where, Object ... args) {
        return SpringJdbcSqlBeanServiceImpl.singleResult(this.jdbcTemplate.query(SqlBeanProvider.selectBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, null, (String)where, (Object[])args), new SpringJbdcSqlBeanMapper(this.clazz, this.clazz)));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> R selectOneBy(Class<R> returnType, String where, Object ... args) {
        return (R)SpringJdbcSqlBeanServiceImpl.singleResult(this.jdbcTemplate.query(SqlBeanProvider.selectBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, null, (String)where, (Object[])args), new SpringJbdcSqlBeanMapper(this.clazz, returnType)));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public T selectOneBy(Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        return SpringJdbcSqlBeanServiceImpl.singleResult(this.jdbcTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (Select)select), new SpringJbdcSqlBeanMapper(this.clazz, this.clazz)));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> R selectOneBy(Class<R> returnType, Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        return (R)SpringJdbcSqlBeanServiceImpl.singleResult(this.jdbcTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, (Select)select), new SpringJbdcSqlBeanMapper(this.clazz, returnType)));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> selectBy(Class<R> returnType, String where, Object ... args) {
        return this.jdbcTemplate.query(SqlBeanProvider.selectBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, null, (String)where, (Object[])args), new SpringJbdcSqlBeanMapper(this.clazz, returnType));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> selectBy(Class<R> returnType, Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        return this.jdbcTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, (Select)select), new SpringJbdcSqlBeanMapper(this.clazz, returnType));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> selectBy(Class<R> returnType, Paging paging, String where, Object ... args) {
        return this.jdbcTemplate.query(SqlBeanProvider.selectBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, (Paging)paging, (String)where, (Object[])args), new SpringJbdcSqlBeanMapper(this.clazz, returnType));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> selectBy(Class<R> returnType, Paging paging, Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        select.page(paging.getPagenum(), paging.getPagesize(), paging.getStartByZero());
        select.orderBy(paging.getOrders());
        return this.jdbcTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, (Select)select), new SpringJbdcSqlBeanMapper(this.clazz, returnType));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> selectBy(String where, Object ... args) {
        return this.jdbcTemplate.query(SqlBeanProvider.selectBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, null, (String)where, (Object[])args), new SpringJbdcSqlBeanMapper(this.clazz, this.clazz));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> selectBy(Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        return this.jdbcTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (Select)select), new SpringJbdcSqlBeanMapper(this.clazz, this.clazz));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> selectBy(Paging paging, String where, Object ... args) {
        return this.jdbcTemplate.query(SqlBeanProvider.selectBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (Paging)paging, (String)where, (Object[])args), new SpringJbdcSqlBeanMapper(this.clazz, this.clazz));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> selectBy(Paging paging, Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        select.page(paging.getPagenum(), paging.getPagesize(), paging.getStartByZero());
        select.orderBy(paging.getOrders());
        return this.jdbcTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (Select)select), new SpringJbdcSqlBeanMapper(this.clazz, this.clazz));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public int countBy(String where, Object ... args) {
        return (Integer)this.jdbcTemplate.queryForObject(SqlBeanProvider.countBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (String)where, (Object[])args), new SpringJbdcSqlBeanMapper(this.clazz, Integer.class));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public int countBy(Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        return (Integer)this.jdbcTemplate.queryForObject(SqlBeanProvider.countSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (Select)select), new SpringJbdcSqlBeanMapper(this.clazz, Integer.class));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public int count() {
        return (Integer)this.jdbcTemplate.queryForObject(SqlBeanProvider.countBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, null), new SpringJbdcSqlBeanMapper(this.clazz, Integer.class));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> select() {
        return this.jdbcTemplate.query(SqlBeanProvider.selectAllSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, null), new SpringJbdcSqlBeanMapper(this.clazz, this.clazz));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> select(Paging paging) {
        return this.jdbcTemplate.query(SqlBeanProvider.selectAllSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (Paging)paging), new SpringJbdcSqlBeanMapper(this.clazz, this.clazz));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> select(Class<R> returnType) {
        return this.jdbcTemplate.query(SqlBeanProvider.selectAllSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, null), new SpringJbdcSqlBeanMapper(this.clazz, returnType));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> select(Class<R> returnType, Paging paging) {
        return this.jdbcTemplate.query(SqlBeanProvider.selectAllSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, (Paging)paging), new SpringJbdcSqlBeanMapper(this.clazz, returnType));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<Map<String, Object>> selectMapList(Select select) {
        return this.jdbcTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (Select)select), new SpringJbdcSqlBeanMapper(this.clazz, Map.class));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> select(Class<R> returnType, Select select) {
        return this.jdbcTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, (Select)select), new SpringJbdcSqlBeanMapper(this.clazz, returnType));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> select(Select select) {
        return this.jdbcTemplate.query(SqlBeanProvider.selectSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (Select)select), new SpringJbdcSqlBeanMapper(this.clazz, this.clazz));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public int count(Select select) {
        return (Integer)this.jdbcTemplate.queryForObject(SqlBeanProvider.countSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (Select)select), new SpringJbdcSqlBeanMapper(this.clazz, Integer.class));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public int count(Class<?> returnType, Select select) {
        return (Integer)this.jdbcTemplate.queryForObject(SqlBeanProvider.countSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, returnType, (Select)select), Integer.class);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public ResultData<T> paging(Select select, PageHelper<T> pageHelper) {
        pageHelper.paging(select, (PagingService)this);
        return pageHelper.getResultData();
    }

    @DbSwitch(value=DbRole.SLAVE)
    public ResultData<T> paging(Select select, int pagenum, int pagesize) {
        PageHelper pageHelper = new PageHelper(Integer.valueOf(pagenum), Integer.valueOf(pagesize));
        pageHelper.paging(select, (PagingService)this);
        return pageHelper.getResultData();
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> ResultData<R> paging(Class<R> tClazz, Select select, PageHelper<R> pageHelper) {
        pageHelper.paging(tClazz, select, (PagingService)this);
        return pageHelper.getResultData();
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> ResultData<R> paging(Class<R> tClazz, Select select, int pagenum, int pagesize) {
        PageHelper pageHelper = new PageHelper(Integer.valueOf(pagenum), Integer.valueOf(pagesize));
        pageHelper.paging(tClazz, select, (PagingService)this);
        return pageHelper.getResultData();
    }

    @DbSwitch(value=DbRole.MASTER)
    public int deleteById(ID ... id) {
        if (id == null || id.length == 0) {
            throw new SqlBeanException("deleteById\u65b9\u6cd5id\u53c2\u6570\u5fc5\u987b\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.jdbcTemplate.update(SqlBeanProvider.deleteByIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, id));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int deleteBy(String where, Object ... args) {
        return this.jdbcTemplate.update(SqlBeanProvider.deleteBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (String)where, (Object[])args));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int deleteBy(Wrapper wrapper) {
        Delete delete = new Delete();
        delete.setLogicallyDelete(SqlBeanUtil.checkLogically(this.clazz));
        delete.where(wrapper);
        return this.jdbcTemplate.update(SqlBeanProvider.deleteSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Delete)delete, (boolean)false));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int delete(Delete delete) {
        return this.jdbcTemplate.update(SqlBeanProvider.deleteSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Delete)delete, (boolean)false));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int delete(Delete delete, boolean ignore) {
        return this.jdbcTemplate.update(SqlBeanProvider.deleteSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Delete)delete, (boolean)ignore));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int logicallyDeleteById(ID ... id) {
        if (id == null || id.length == 0) {
            throw new SqlBeanException("logicallyDeleteById\u65b9\u6cd5id\u53c2\u6570\u5fc5\u987b\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.jdbcTemplate.update(SqlBeanProvider.logicallyDeleteByIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, id));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int logicallyDeleteBy(String where, Object ... args) {
        return this.jdbcTemplate.update(SqlBeanProvider.logicallyDeleteBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (String)where, (Object[])args));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int logicallyDeleteBy(Wrapper wrapper) {
        return this.jdbcTemplate.update(SqlBeanProvider.logicallyDeleteBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Wrapper)wrapper));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int update(Update update) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Update)update, (boolean)false));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int update(Update update, boolean ignore) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Update)update, (boolean)ignore));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateById(T bean, ID id) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateByIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, id, (boolean)true, (boolean)false, null));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateById(T bean, ID id, boolean updateNotNull, boolean optimisticLock) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateByIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, id, (boolean)updateNotNull, (boolean)optimisticLock, null));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateByBeanId(T bean) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateByBeanIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)true, (boolean)false, null));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateById(T bean, ID id, boolean updateNotNull, boolean optimisticLock, String[] filterFields) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateByIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, id, (boolean)updateNotNull, (boolean)optimisticLock, (String[])filterFields));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, String where, Object ... args) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)true, (boolean)false, null, (String)where, (Object[])args));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateByBeanId(T bean, boolean updateNotNull, boolean optimisticLock) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateByBeanIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, null));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateByBeanId(T bean, boolean updateNotNull, boolean optimisticLock, String[] filterFields) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateByBeanIdSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, (String[])filterFields));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, String where, Object ... args) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, null, (String)where, (Object[])args));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, Wrapper wrapper) {
        Update update = new Update();
        update.setUpdateBean(bean);
        update.setUpdateNotNull(true);
        update.setOptimisticLock(false);
        update.where(wrapper);
        return this.jdbcTemplate.update(SqlBeanProvider.updateSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Update)update, (boolean)false));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, Wrapper wrapper) {
        Update update = new Update();
        update.setUpdateBean(bean);
        update.setUpdateNotNull(updateNotNull);
        update.setOptimisticLock(optimisticLock);
        update.where(wrapper);
        return this.jdbcTemplate.update(SqlBeanProvider.updateSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Update)update, (boolean)false));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, String[] filterFields, String where, Object ... args) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateBySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, (String[])filterFields, (String)where, (Object[])args));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, String[] filterFields, Wrapper wrapper) {
        Update update = new Update();
        update.setUpdateBean(bean);
        update.setUpdateNotNull(updateNotNull);
        update.setOptimisticLock(optimisticLock);
        update.setFilterFields(filterFields);
        update.where(wrapper);
        return this.jdbcTemplate.update(SqlBeanProvider.updateSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Update)update, (boolean)false));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateByBean(T bean, String where) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateByBeanSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)true, (boolean)false, null, (String)where));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateByBean(T bean, boolean updateNotNull, boolean optimisticLock, String where) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateByBeanSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, null, (String)where));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateByBean(T bean, boolean updateNotNull, boolean optimisticLock, String[] filterFields, String where) {
        return this.jdbcTemplate.update(SqlBeanProvider.updateByBeanSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean, (boolean)updateNotNull, (boolean)optimisticLock, (String[])filterFields, (String)where));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int insert(T ... bean) {
        if (bean == null || bean.length == 0) {
            throw new SqlBeanException("insert\u65b9\u6cd5bean\u53c2\u6570\u5fc5\u987b\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.jdbcTemplate.update(SqlBeanProvider.insertBeanSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, bean));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int insert(List<T> beanList) {
        if (beanList == null || beanList.size() == 0) {
            throw new SqlBeanException("insert\u65b9\u6cd5beanList\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.jdbcTemplate.update(SqlBeanProvider.insertBeanSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, beanList));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int insert(Insert insert) {
        return this.jdbcTemplate.update(SqlBeanProvider.insertBeanSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (Object)insert));
    }

    @DbSwitch(value=DbRole.MASTER)
    public String backup() {
        String targetTableName = SqlBeanUtil.getTable(this.clazz).getName() + "_" + DateUtil.dateToString((Date)new Date(), (String)"yyyyMMddHHmmssSSS");
        this.jdbcTemplate.update(SqlBeanProvider.backupSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (String)targetTableName, null, null));
        return targetTableName;
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(String targetTableName) {
        this.jdbcTemplate.update(SqlBeanProvider.backupSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (String)targetTableName, null, null));
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(String targetSchema, String targetTableName) {
        this.jdbcTemplate.update(SqlBeanProvider.backupSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (String)targetSchema, (String)targetTableName, null, null));
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(String targetTableName, Column[] columns, Wrapper wrapper) {
        this.jdbcTemplate.update(SqlBeanProvider.backupSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (String)targetTableName, (Column[])columns, (Wrapper)wrapper));
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(String targetSchema, String targetTableName, Column[] columns, Wrapper wrapper) {
        this.jdbcTemplate.update(SqlBeanProvider.backupSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (String)targetSchema, (String)targetTableName, (Column[])columns, (Wrapper)wrapper));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int copy(String targetTableName, Wrapper wrapper) {
        return this.jdbcTemplate.update(SqlBeanProvider.copySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (String)targetTableName, null, (Wrapper)wrapper));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int copy(String targetSchema, String targetTableName, Wrapper wrapper) {
        return this.jdbcTemplate.update(SqlBeanProvider.copySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (String)targetSchema, (String)targetTableName, null, (Wrapper)wrapper));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int copy(String targetTableName, Column[] columns, Wrapper wrapper) {
        return this.jdbcTemplate.update(SqlBeanProvider.copySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, null, (String)targetTableName, (Column[])columns, (Wrapper)wrapper));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int copy(String targetSchema, String targetTableName, Column[] columns, Wrapper wrapper) {
        return this.jdbcTemplate.update(SqlBeanProvider.copySql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (String)targetSchema, (String)targetTableName, (Column[])columns, (Wrapper)wrapper));
    }

    @DbSwitch(value=DbRole.MASTER)
    public void dropTable() {
        List nameList;
        SqlBeanDB sqlBeanDB = this.getSqlBeanDB();
        if (sqlBeanDB.getDbType() != DbType.MySQL && sqlBeanDB.getDbType() != DbType.MariaDB && sqlBeanDB.getDbType() != DbType.Postgresql && sqlBeanDB.getDbType() != DbType.SQLServer && sqlBeanDB.getDbType() != DbType.H2 && ((nameList = this.jdbcTemplate.queryForList(SqlBeanProvider.selectTableListSql((SqlBeanDB)sqlBeanDB, null, (String)SqlBeanUtil.getTable(this.clazz).getName()), TableInfo.class)) == null || nameList.isEmpty())) {
            return;
        }
        this.jdbcTemplate.update(SqlBeanProvider.dropTableSql((SqlBeanDB)sqlBeanDB, this.clazz));
    }

    @DbSwitch(value=DbRole.MASTER)
    public void createTable() {
        this.jdbcTemplate.update(SqlBeanProvider.createTableSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz));
    }

    @DbSwitch(value=DbRole.MASTER)
    public void dropAndCreateTable() {
        this.dropTable();
        this.createTable();
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<TableInfo> getTableList(String tableName) {
        return this.jdbcTemplate.query(SqlBeanProvider.selectTableListSql((SqlBeanDB)this.getSqlBeanDB(), null, (String)tableName), new SpringJbdcSqlBeanMapper(TableInfo.class, TableInfo.class));
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<ColumnInfo> getColumnInfoList(String tableName) {
        List columnInfoList = this.jdbcTemplate.query(SqlBeanProvider.selectColumnListSql((SqlBeanDB)this.getSqlBeanDB(), (String)tableName), new SpringJbdcSqlBeanMapper(ColumnInfo.class, ColumnInfo.class));
        super.handleColumnInfo(columnInfoList);
        return columnInfoList;
    }

    private static <T> T singleResult(Collection<T> results) {
        int size;
        int n = size = results != null ? results.size() : 0;
        if (size == 0) {
            return null;
        }
        if (results.size() > 1) {
            throw new SqlBeanException("\u6267\u884c\u8fd4\u56de\u7684\u7ed3\u679c\u4e0d\u6b62\u4e00\u6761, size: " + results.size());
        }
        return results.iterator().next();
    }
}

