/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.spring.service;

import cn.vonce.sql.bean.ColumnInfo;
import cn.vonce.sql.config.SqlBeanConfig;
import cn.vonce.sql.config.SqlBeanDB;
import cn.vonce.sql.enumerate.DbType;
import cn.vonce.sql.enumerate.JdbcType;
import cn.vonce.sql.uitls.StringUtil;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;

public abstract class BaseSqlBeanServiceImpl {
    private SqlBeanDB sqlBeanDB;

    public abstract SqlBeanConfig getSqlBeanConfig();

    public abstract SqlBeanDB initDBInfo();

    public SqlBeanDB getSqlBeanDB() {
        if (this.sqlBeanDB == null) {
            this.sqlBeanDB = this.initDBInfo();
            this.sqlBeanDB.setSqlBeanConfig(this.getSqlBeanConfig());
            boolean isUserConfig = true;
            if (this.sqlBeanDB.getSqlBeanConfig() == null) {
                isUserConfig = false;
                this.sqlBeanDB.setSqlBeanConfig(new SqlBeanConfig());
            }
            if (!isUserConfig) {
                switch (Objects.requireNonNull(this.sqlBeanDB.getDbType())) {
                    case Oracle: 
                    case DB2: 
                    case Derby: 
                    case Hsql: 
                    case H2: {
                        this.sqlBeanDB.getSqlBeanConfig().setToUpperCase(Boolean.valueOf(true));
                    }
                }
            }
        }
        return this.sqlBeanDB;
    }

    public void handleColumnInfo(List<ColumnInfo> columnInfoList) {
        block9: {
            DbType dbType;
            block8: {
                dbType = this.getSqlBeanDB().getDbType();
                if (dbType != DbType.Derby) break block8;
                for (ColumnInfo info : columnInfoList) {
                    String[] values = info.getType().split(" ");
                    info.setType(StringUtil.getWord((String)values[0]));
                    if (values.length > 1) {
                        info.setNotnull(Boolean.valueOf(true));
                    } else {
                        info.setNotnull(Boolean.valueOf(false));
                    }
                    String[] range = StringUtil.getBracketContent((String)values[0]).split(",");
                    info.setLength("".equals(range[0]) ? 0 : Integer.parseInt(range[0]));
                    info.setScale(range.length == 1 ? 0 : Integer.parseInt(range[1]));
                }
                break block9;
            }
            if (dbType != DbType.H2 && dbType != DbType.Postgresql) break block9;
            Boolean toUpperCase = this.getSqlBeanDB().getSqlBeanConfig().getToUpperCase();
            for (ColumnInfo info : columnInfoList) {
                if ("CHARACTER VARYING".equalsIgnoreCase(info.getType())) {
                    info.setType(JdbcType.VARCHAR.getName(toUpperCase));
                    continue;
                }
                if ("CHARACTER LARGE OBJECT".equalsIgnoreCase(info.getType())) {
                    info.setType(JdbcType.LONGTEXT.getName(toUpperCase));
                    continue;
                }
                if ("BINARY VARYING".equalsIgnoreCase(info.getType())) {
                    info.setType(JdbcType.BLOB.getName(toUpperCase));
                    continue;
                }
                if ("BINARY LARGE OBJECT".equalsIgnoreCase(info.getType())) {
                    info.setType(JdbcType.LONGBLOB.getName(toUpperCase));
                    continue;
                }
                if (!"TIMESTAMP WITHOUT TIME ZONE".equalsIgnoreCase(info.getType())) continue;
                info.setType(JdbcType.TIMESTAMP.getName(toUpperCase));
            }
        }
    }

    public void sqlBeanDBFill(SqlBeanDB sqlBeanDB, DatabaseMetaData metaData) throws SQLException {
        sqlBeanDB.setProductName(metaData.getDatabaseProductName());
        sqlBeanDB.setDatabaseMajorVersion(metaData.getDatabaseMajorVersion());
        sqlBeanDB.setDatabaseMinorVersion(metaData.getDatabaseMinorVersion());
        sqlBeanDB.setDatabaseProductVersion(metaData.getDatabaseProductVersion());
        sqlBeanDB.setJdbcMajorVersion(metaData.getJDBCMajorVersion());
        sqlBeanDB.setJdbcMinorVersion(metaData.getJDBCMinorVersion());
        sqlBeanDB.setDriverMajorVersion(metaData.getDatabaseMajorVersion());
        sqlBeanDB.setDriverMinorVersion(metaData.getDriverMinorVersion());
        sqlBeanDB.setDriverVersion(metaData.getDriverVersion());
        sqlBeanDB.setDriverName(metaData.getDriverName());
        sqlBeanDB.setDbType(DbType.getDbType((String)sqlBeanDB.getProductName()));
    }
}

