/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.spring.mapper;

import cn.vonce.sql.bean.ColumnInfo;
import cn.vonce.sql.bean.TableInfo;
import cn.vonce.sql.mapper.SqlBeanMapper;
import cn.vonce.sql.uitls.ReflectUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.resultset.DefaultResultSetHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(method="handleResultSets", type=ResultSetHandler.class, args={Statement.class})})
public class MybatisSqlBeanMapperInterceptor
extends SqlBeanMapper
implements Interceptor {
    private Logger logger = LoggerFactory.getLogger(MybatisSqlBeanMapperInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        Object target = invocation.getTarget();
        if (target instanceof DefaultResultSetHandler) {
            DefaultResultSetHandler resultSetHandler = (DefaultResultSetHandler)target;
            ParameterHandler parameterHandler = (ParameterHandler)ReflectUtil.getFieldValue((Object)resultSetHandler, (String)"parameterHandler");
            MappedStatement mappedStatement = (MappedStatement)ReflectUtil.getFieldValue((Object)resultSetHandler, (String)"mappedStatement");
            if (mappedStatement.getId().startsWith("cn.vonce.sql.spring.dao.MybatisSqlBeanDao")) {
                Object parameterObj = parameterHandler.getParameterObject();
                List resultMaps = mappedStatement.getResultMaps();
                return this.handleResultSet(((Statement)invocation.getArgs()[0]).getResultSet(), (HashMap)parameterObj, ((ResultMap)resultMaps.get(0)).getType());
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private Object handleResultSet(ResultSet resultSet, Map<String, Object> mapParam, Class<?> resultType) {
        if (null != resultSet) {
            if (resultType.getName().equals(ColumnInfo.class.getName()) || resultType.getName().equals(TableInfo.class.getName())) {
                return this.beanHandleResultSet((Class)resultType, resultSet, super.getColumnNameList(resultSet));
            }
            if (SqlBeanUtil.isBaseType((String)resultType.getName())) {
                return this.baseHandleResultSet(resultSet, resultType);
            }
            if (SqlBeanUtil.isMap((String)resultType.getName())) {
                return this.mapHandleResultSet(resultSet);
            }
            Class returnType = mapParam.containsKey("returnType") ? (Class)mapParam.get("returnType") : (Class)mapParam.get("clazz");
            if (SqlBeanUtil.isBaseType((String)returnType.getName())) {
                return this.baseHandleResultSet(resultSet, returnType);
            }
            if (SqlBeanUtil.isMap((String)returnType.getName())) {
                return this.mapHandleResultSet(resultSet);
            }
            return this.beanHandleResultSet(returnType, resultSet, super.getColumnNameList(resultSet));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> beanHandleResultSet(Class<?> clazz, ResultSet resultSet, List<String> columnNameList) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            while (resultSet.next()) {
                list.add(super.beanHandleResultSet(clazz, resultSet, columnNameList));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.closeResultSet(resultSet);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object mapHandleResultSet(ResultSet resultSet) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        if (null != resultSet) {
            try {
                while (resultSet.next()) {
                    resultList.add(super.mapHandleResultSet(resultSet));
                }
            }
            catch (SQLException e) {
                this.logger.error("map\u5bf9\u8c61\u6620\u5c04\u5f02\u5e38SQLException\uff0c{}", (Object)e.getMessage());
            }
            finally {
                this.closeResultSet(resultSet);
            }
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> baseHandleResultSet(ResultSet resultSet, Class<?> returnType) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        if (null != resultSet) {
            try {
                while (resultSet.next()) {
                    Object value = super.baseHandleResultSet(resultSet);
                    if (value != null && !value.getClass().getName().equals(returnType.getName())) {
                        value = MybatisSqlBeanMapperInterceptor.getValueConvert((String)returnType.getName(), (Object)value);
                    }
                    resultList.add(value);
                }
            }
            catch (SQLException e) {
                this.logger.error("\u57fa\u7840\u5bf9\u8c61\u6620\u5c04\u5f02\u5e38SQLException\uff0c{}", (Object)e.getMessage());
            }
            finally {
                this.closeResultSet(resultSet);
            }
        }
        if (resultList.isEmpty()) {
            resultList.add(MybatisSqlBeanMapperInterceptor.getDefaultValue((String)returnType.getName()));
        }
        return resultList;
    }

    private void closeResultSet(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            this.logger.error("\u5173\u95ed result set\u5f02\u5e38,{}", (Object)e.getMessage());
        }
    }
}

