/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.spring.config;

import cn.vonce.sql.spring.config.ConditionalOnUseMybatis;
import cn.vonce.sql.spring.mapper.MybatisSqlBeanMapperInterceptor;
import java.util.List;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;

public class MybatisAutoConfig {
    private Logger logger = LoggerFactory.getLogger(MybatisAutoConfig.class);
    @Autowired(required=false)
    private SqlSessionFactoryBean sqlSessionFactoryBean;
    @Autowired
    private BeanFactory beanFactory;

    @Bean
    @Conditional(value={ConditionalOnUseMybatis.class})
    public Interceptor interceptor() throws Exception {
        List interceptorList;
        MybatisSqlBeanMapperInterceptor mybatisMapperInterceptor = new MybatisSqlBeanMapperInterceptor();
        SqlSessionFactory sqlSessionFactory = null;
        if (this.sqlSessionFactoryBean != null) {
            sqlSessionFactory = this.sqlSessionFactoryBean.getObject();
        } else {
            try {
                sqlSessionFactory = (SqlSessionFactory)this.beanFactory.getBean(SqlSessionFactory.class);
            }
            catch (Exception e) {
                this.logger.info("MybatisAutoConfig\uff1a{}", (Object)e.getMessage());
            }
        }
        if (sqlSessionFactory != null && (interceptorList = sqlSessionFactory.getConfiguration().getInterceptors()) != null) {
            boolean exist = false;
            for (Interceptor interceptor : interceptorList) {
                if (!(interceptor instanceof MybatisSqlBeanMapperInterceptor)) continue;
                exist = true;
                break;
            }
            if (!exist) {
                sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)mybatisMapperInterceptor);
            }
        }
        return mybatisMapperInterceptor;
    }
}

