/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.spring.config;

import cn.vonce.sql.annotation.SqlTable;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.bean.TableInfo;
import cn.vonce.sql.config.SqlBeanConfig;
import cn.vonce.sql.service.TableService;
import cn.vonce.sql.uitls.SqlBeanUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Service;

@Service
public class AutoCreateTableListener
implements ApplicationListener<ContextRefreshedEvent> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired(required=false)
    private SqlBeanConfig sqlBeanConfig;

    public void onApplicationEvent(ContextRefreshedEvent evt) {
        if (!(evt.getApplicationContext().getParent() != null && evt.getApplicationContext().getParent().getParent() != null || this.sqlBeanConfig != null && !this.sqlBeanConfig.getAutoCreate())) {
            ArrayList<String> beanNameList = new ArrayList<String>();
            beanNameList.addAll(Arrays.asList(evt.getApplicationContext().getBeanNamesForType(TableService.class)));
            if (!beanNameList.isEmpty()) {
                List tableList = ((TableService)evt.getApplicationContext().getBean((String)beanNameList.get(0), TableService.class)).getTableList(null);
                for (String name : beanNameList) {
                    SqlTable sqlTable;
                    TableService tableService = (TableService)evt.getApplicationContext().getBean(name, TableService.class);
                    Class clazz = tableService.getBeanClass();
                    if (clazz == null || (sqlTable = SqlBeanUtil.getSqlTable((Class)clazz)) == null || sqlTable.isView() || !sqlTable.autoCreate()) continue;
                    Table table = SqlBeanUtil.getTable((Class)clazz);
                    if (tableList != null && !tableList.isEmpty()) {
                        boolean isExist = false;
                        for (TableInfo tableInfo : tableList) {
                            if (!tableInfo.getName().equalsIgnoreCase(table.getName())) continue;
                            isExist = true;
                            break;
                        }
                        if (isExist) continue;
                    }
                    tableService.createTable();
                    this.logger.info("-----'{}'\u8868\u4e0d\u5b58\u5728\uff0c\u5df2\u4e3a\u4f60\u81ea\u52a8\u521b\u5efa-----", (Object)table.getName());
                }
            }
        }
    }
}

