/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.spring.config;

import cn.vonce.sql.spring.annotation.EnableAutoConfigMultiDataSource;
import cn.vonce.sql.spring.datasource.DynamicDataSource;
import cn.vonce.sql.uitls.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.type.AnnotationMetadata;

public class AutoConfigMultiDataSource
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private static final List<String> fieldList = new ArrayList<String>();
    private static final String MULTI_DATA_SOURCE_TYPE = "spring.datasource.type";
    private static final String MULTI_DATA_SOURCE_PREFIX = "spring.datasource.sqlbean";
    private static final String DRUID_DATA_SOURCE_CLASS = "com.alibaba.druid.pool.DruidDataSource";
    private static final Map<Class<?>, Map<String, Method>> classMethodMap = new WeakHashMap(8);
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry beanDefinitionRegistry) {
        if (annotationMetadata.isAnnotated(EnableAutoConfigMultiDataSource.class.getName()) && this.environment instanceof StandardEnvironment) {
            Map annotationAttributeMap = annotationMetadata.getAnnotationAttributes(EnableAutoConfigMultiDataSource.class.getName());
            Class multiDataSourceClass = (Class)annotationAttributeMap.get("multiDataSource");
            String defaultDataSource = (String)annotationAttributeMap.get("defaultDataSource");
            List<String> dataSourceNameList = this.getDataSourceNameList(multiDataSourceClass);
            if (dataSourceNameList == null || dataSourceNameList.isEmpty()) {
                return;
            }
            if (StringUtil.isEmpty((Object)defaultDataSource)) {
                defaultDataSource = dataSourceNameList.get(0);
            }
            HashMap<String, Object> dataSourceMap = new HashMap<String, Object>(8);
            BeanDefinitionBuilder definitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(DynamicDataSource.class);
            StandardEnvironment env = (StandardEnvironment)this.environment;
            Class<?> typeClass = this.getTypeClass(env.getProperty(MULTI_DATA_SOURCE_TYPE));
            for (String string : dataSourceNameList) {
                Map<String, Method> methodMap = this.getMethodMap(typeClass);
                Object dataSource = null;
                try {
                    dataSource = typeClass.newInstance();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                for (String fieldName : fieldList) {
                    String propertyValue = env.getProperty("spring.datasource.sqlbean." + string + "." + fieldName);
                    if (!StringUtil.isNotEmpty((Object)propertyValue)) continue;
                    try {
                        Method method = methodMap.get("set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1));
                        method.invoke(dataSource, this.getValueConvert(method.getParameterTypes()[0].getName(), propertyValue));
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
                if (string.equals(defaultDataSource)) {
                    definitionBuilder.addPropertyValue("defaultTargetDataSource", dataSource);
                }
                dataSourceMap.put(string, dataSource);
            }
            definitionBuilder.addPropertyValue("targetDataSources", dataSourceMap);
            beanDefinitionRegistry.registerBeanDefinition("dynamicDataSource", (BeanDefinition)definitionBuilder.getBeanDefinition());
            for (Map map : classMethodMap.values()) {
                map.clear();
            }
            classMethodMap.clear();
        }
    }

    private List<String> getDataSourceNameList(Class<?> multiDataSourceClass) {
        Field[] fields = multiDataSourceClass.getFields();
        if (fields == null || fields.length == 0) {
            return null;
        }
        ArrayList<String> dataSourceNameList = new ArrayList<String>();
        for (int i = 0; i < fields.length; ++i) {
            if (!Modifier.isStatic(fields[i].getModifiers()) || !Modifier.isFinal(fields[i].getModifiers())) continue;
            try {
                Object value = fields[i].get(null);
                dataSourceNameList.add(value.toString());
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return dataSourceNameList;
    }

    private Class<?> getTypeClass(String type) {
        Class<?> typeClass = null;
        try {
            typeClass = StringUtil.isEmpty((Object)type) ? Class.forName(DRUID_DATA_SOURCE_CLASS) : Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return typeClass;
    }

    private Map<String, Method> getMethodMap(Class<?> typeClass) {
        Map<String, Method> methodMap = classMethodMap.get(typeClass);
        if (methodMap == null) {
            Method[] methods;
            methodMap = new HashMap<String, Method>(16);
            for (Method method : methods = typeClass.getMethods()) {
                if (method.getName().indexOf("set") != 0) continue;
                methodMap.put(method.getName(), method);
            }
            classMethodMap.put(typeClass, methodMap);
        }
        return methodMap;
    }

    private Object getValueConvert(String fieldType, String originalValue) {
        Object value;
        switch (fieldType) {
            case "byte": 
            case "java.lang.Byte": {
                value = Byte.parseByte(originalValue);
                break;
            }
            case "short": 
            case "java.lang.Short": {
                value = Short.parseShort(originalValue);
                break;
            }
            case "int": 
            case "java.lang.Integer": {
                value = Integer.parseInt(originalValue);
                break;
            }
            case "float": 
            case "java.lang.Float": {
                value = Float.valueOf(Float.parseFloat(originalValue));
                break;
            }
            case "double": 
            case "java.lang.Double": {
                value = Double.parseDouble(originalValue);
                break;
            }
            case "long": 
            case "java.lang.Long": {
                value = Long.parseLong(originalValue);
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                value = Boolean.parseBoolean(originalValue);
                break;
            }
            case "char": 
            case "java.lang.Character": {
                value = Character.valueOf(originalValue.charAt(0));
                break;
            }
            default: {
                value = originalValue;
            }
        }
        return value;
    }

    static {
        fieldList.add("driverClassName");
        fieldList.add("url");
        fieldList.add("username");
        fieldList.add("password");
        fieldList.add("initialSize");
        fieldList.add("minIdle");
        fieldList.add("maxIdle");
        fieldList.add("maxActive");
        fieldList.add("maxWait");
        fieldList.add("timeBetweenEvictionRunsMillis");
        fieldList.add("minEvictableIdleTimeMillis");
        fieldList.add("validationQuery");
        fieldList.add("testWhileIdle");
        fieldList.add("testOnBorrow");
        fieldList.add("testOnReturn");
        fieldList.add("validationQueryTimeout");
        fieldList.add("keepAlive");
        fieldList.add("removeAbandoned");
        fieldList.add("removeAbandonedTimeout");
        fieldList.add("logAbandoned");
        fieldList.add("connectionProperties");
        fieldList.add("poolPreparedStatements");
        fieldList.add("maxPoolPreparedStatementPerConnectionSize");
        fieldList.add("filters");
    }
}

