/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.enumerate;

import cn.vonce.sql.bean.Alter;
import cn.vonce.sql.bean.Common;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.config.SqlBeanDB;
import cn.vonce.sql.enumerate.AlterType;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;

public enum JavaMapH2Type {
    INT(new Class[]{Integer.TYPE, Integer.class}),
    BIGINT(new Class[]{Long.TYPE, Long.class}),
    TINYINT(new Class[]{Byte.TYPE, Byte.class}),
    SMALLINT(new Class[]{Short.TYPE, Short.class}),
    BOOLEAN(new Class[]{Boolean.TYPE, Boolean.class}),
    REAL(new Class[]{Float.TYPE, Float.class}),
    DOUBLE(new Class[]{Double.TYPE, Double.class}),
    DECIMAL(new Class[]{BigDecimal.class}),
    CHAR(new Class[]{Character.TYPE, Character.class}),
    VARCHAR(new Class[]{String.class}),
    DATE(new Class[]{Date.class, LocalDate.class}),
    TIME(new Class[]{Time.class, LocalTime.class}),
    TIMESTAMP(new Class[]{Timestamp.class, java.util.Date.class, LocalDateTime.class}),
    CLOB(new Class[]{Clob.class}),
    BLOB(new Class[]{Blob.class, Object.class});

    private Class<?>[] classes;

    private JavaMapH2Type(Class<?>[] classes) {
        this.classes = classes;
    }

    public static JavaMapH2Type getType(Class<?> clazz) {
        for (JavaMapH2Type javaType : JavaMapH2Type.values()) {
            for (Class<?> thisClazz : javaType.classes) {
                if (thisClazz != clazz) continue;
                return javaType;
            }
        }
        return null;
    }

    public static String getTypeName(Class<?> clazz) {
        return JavaMapH2Type.getType(clazz).name();
    }

    public static String getTableListSql(SqlBeanDB sqlBeanDB, String schema, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TABLE_SCHEMA AS schema,TABLE_NAME AS name,REMARKS AS remarks ");
        sql.append("FROM information_schema.tables ");
        sql.append("WHERE (table_type = 'TABLE' OR TABLE_TYPE = 'BASE TABLE') ");
        sql.append(" AND TABLE_SCHEMA = ");
        if (StringUtil.isNotEmpty(schema)) {
            sql.append("'" + schema + "'");
        } else {
            sql.append("'PUBLIC'");
        }
        if (StringUtil.isNotEmpty(tableName)) {
            sql.append(" AND TABLE_NAME = '" + tableName + "'");
        }
        return sql.toString();
    }

    public static String getColumnListSql(SqlBeanDB sqlBeanDB, String schema, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT cl.ORDINAL_POSITION AS cid, ");
        sql.append("cl.COLUMN_NAME AS name, ");
        if (sqlBeanDB.getDatabaseMajorVersion() == 1) {
            sql.append("cl.TYPE_NAME AS type, ");
        } else {
            sql.append("cl.DATA_TYPE AS type, ");
        }
        sql.append("CASE WHEN cl.IS_NULLABLE  = 'NO' THEN 1 ELSE 0 END AS notnull, ");
        sql.append("cl.COLUMN_DEFAULT AS dflt_value, ");
        sql.append("cl.CHARACTER_MAXIMUM_LENGTH AS length, ");
        sql.append("cl.NUMERIC_SCALE AS scale, ");
        sql.append("CASE WHEN tc.CONSTRAINT_TYPE = 'PRIMARY KEY' THEN 1 ELSE 0 END AS pk, ");
        sql.append("CASE WHEN tc.CONSTRAINT_TYPE = 'FOREIGN KEY' THEN 1 ELSE 0 END AS fk, ");
        sql.append("cl.REMARKS AS remarks ");
        sql.append("FROM INFORMATION_SCHEMA.COLUMNS cl ");
        sql.append("LEFT JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE kcu ");
        sql.append("ON kcu.TABLE_NAME = cl.TABLE_NAME AND kcu.COLUMN_NAME = cl.COLUMN_NAME ");
        sql.append("LEFT JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS tc ");
        sql.append("ON tc.CONSTRAINT_NAME = kcu.CONSTRAINT_NAME ");
        sql.append("WHERE cl.TABLE_SCHEMA = ");
        if (StringUtil.isNotEmpty(schema)) {
            sql.append("'" + schema + "'");
        } else {
            sql.append("'PUBLIC'");
        }
        sql.append(" AND cl.TABLE_NAME = '");
        sql.append(tableName);
        sql.append("'");
        return sql.toString();
    }

    public static List<String> alterTable(List<Alter> alterList) {
        ArrayList<String> sqlList = new ArrayList<String>();
        String transferred = SqlBeanUtil.getTransferred(alterList.get(0));
        StringBuffer sql = new StringBuffer();
        StringBuffer remarksSql = new StringBuffer();
        for (int i = 0; i < alterList.size(); ++i) {
            Alter alter = alterList.get(i);
            if (alter.getType() == AlterType.ADD) {
                sql.append("ALTER TABLE ");
                sql.append(JavaMapH2Type.getFullName(alter, alter.getTable()));
                sql.append("ADD ");
                sql.append(SqlBeanUtil.addColumn(alter, alter.getColumnInfo(), alter.getAfterColumnName()));
                remarksSql.append(JavaMapH2Type.addRemarks(alter, transferred));
            } else if (alter.getType() == AlterType.CHANGE) {
                sql.append(JavaMapH2Type.changeColumn(alter));
                sql.append(";");
                StringBuffer modifySql = JavaMapH2Type.modifyColumn(alter);
                if (modifySql.length() > 0) {
                    sql.append("ALTER TABLE ");
                    sql.append(modifySql);
                }
                remarksSql.append(JavaMapH2Type.addRemarks(alter, transferred));
            } else if (alter.getType() == AlterType.MODIFY) {
                sql.append("ALTER TABLE ");
                sql.append(JavaMapH2Type.modifyColumn(alter));
                remarksSql.append(JavaMapH2Type.addRemarks(alter, transferred));
            } else if (alter.getType() == AlterType.DROP) {
                sql.append("ALTER TABLE ");
                sql.append(JavaMapH2Type.getFullName(alter, alter.getTable()));
                sql.append("DROP ");
                sql.append("COLUMN ");
                sql.append(SqlBeanUtil.isToUpperCase(alter) ? alter.getColumnInfo().getName().toUpperCase() : alter.getColumnInfo().getName());
            }
            sql.append(" ");
            sql.append(";");
        }
        sqlList.add(sql.toString());
        sqlList.add(remarksSql.toString());
        return sqlList;
    }

    private static String getFullName(Common common, Table table) {
        String transferred = SqlBeanUtil.getTransferred(common);
        boolean toUpperCase = SqlBeanUtil.isToUpperCase(common);
        StringBuffer sql = new StringBuffer();
        if (StringUtil.isNotBlank(table.getSchema())) {
            sql.append(transferred);
            sql.append(toUpperCase ? table.getSchema().toUpperCase() : table.getSchema());
            sql.append(transferred);
            sql.append(".");
        }
        sql.append(transferred);
        sql.append(toUpperCase ? table.getName().toUpperCase() : table.getName());
        sql.append(transferred);
        sql.append(" ");
        return sql.toString();
    }

    private static StringBuffer modifyColumn(Alter alter) {
        StringBuffer modifySql = new StringBuffer();
        modifySql.append(JavaMapH2Type.getFullName(alter, alter.getTable()));
        modifySql.append("ALTER ");
        modifySql.append("COLUMN ");
        modifySql.append(SqlBeanUtil.addColumn(alter, alter.getColumnInfo(), alter.getAfterColumnName()));
        return modifySql;
    }

    private static String changeColumn(Alter alter) {
        StringBuffer changeSql = new StringBuffer();
        changeSql.append("ALTER TABLE ");
        changeSql.append(JavaMapH2Type.getFullName(alter, alter.getTable()));
        changeSql.append("RENAME ");
        changeSql.append("COLUMN ");
        changeSql.append(SqlBeanUtil.isToUpperCase(alter) ? alter.getOldColumnName().toUpperCase() : alter.getOldColumnName());
        changeSql.append(" TO ");
        changeSql.append(SqlBeanUtil.isToUpperCase(alter) ? alter.getColumnInfo().getName().toUpperCase() : alter.getColumnInfo().getName());
        return changeSql.toString();
    }

    private static String addRemarks(Alter item, String transferred) {
        StringBuffer remarksSql = new StringBuffer();
        if (StringUtil.isNotBlank(item.getColumnInfo().getRemarks())) {
            remarksSql.append("COMMENT");
            remarksSql.append(" ON ");
            remarksSql.append("COLUMN ");
            remarksSql.append(JavaMapH2Type.getFullName(item, item.getTable()));
            remarksSql.append(".");
            remarksSql.append(transferred);
            remarksSql.append(item.getColumnInfo().getName());
            remarksSql.append(transferred);
            remarksSql.append(" IS ");
            remarksSql.append("'");
            remarksSql.append(item.getColumnInfo().getRemarks());
            remarksSql.append("'");
        }
        return remarksSql.toString();
    }
}

