/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.bean;

import cn.vonce.sql.bean.Column;
import cn.vonce.sql.bean.CommonCondition;
import cn.vonce.sql.bean.Condition;
import cn.vonce.sql.bean.Group;
import cn.vonce.sql.bean.Join;
import cn.vonce.sql.bean.Order;
import cn.vonce.sql.bean.Page;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.define.ColumnFunction;
import cn.vonce.sql.define.SqlFun;
import cn.vonce.sql.enumerate.JoinType;
import cn.vonce.sql.enumerate.SqlSort;
import cn.vonce.sql.helper.SqlHelper;
import cn.vonce.sql.helper.Wrapper;
import cn.vonce.sql.uitls.LambdaUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Select
extends CommonCondition<Select>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean count;
    private boolean distinct = false;
    private List<Column> columnList = new ArrayList<Column>();
    private List<Join> joinList = new ArrayList<Join>();
    private List<Group> groupByList = new ArrayList<Group>();
    private List<Order> orderByList = new ArrayList<Order>();
    private Page page = null;
    private String[] filterFields = null;
    private String having = null;
    private Object[] havingArgs = null;
    private Wrapper havingWrapper = new Wrapper();
    private Condition<Select> havingCondition = new Condition<Select>(this);

    public Select() {
        super.setReturnObj(this);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public Select distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public boolean isCount() {
        return this.count;
    }

    public void count(boolean count) {
        this.count = count;
    }

    public List<Column> getColumnList() {
        return this.columnList;
    }

    public void setColumnList(List<Column> columnList) {
        this.columnList.addAll(columnList);
    }

    public Select column(String[] columnNames) {
        if (columnNames != null && columnNames.length > 0) {
            for (String columnName : columnNames) {
                this.columnList.add(new Column(columnName));
            }
        }
        return this;
    }

    public Select column(Column ... columns) {
        if (columns != null && columns.length > 0) {
            this.columnList.addAll(Arrays.asList(columns));
        }
        return this;
    }

    public Select column(Column column) {
        this.columnList.add(column);
        return this;
    }

    public <T, R> Select column(ColumnFunction<T, R> columnFunction) {
        this.columnList.add(LambdaUtil.getColumn(columnFunction));
        return this;
    }

    public Select column(String columnName) {
        return this.column("", columnName, "");
    }

    public Select column(String columnName, String columnAlias) {
        return this.column("", columnName, columnAlias);
    }

    public Select column(Select select, String columnAlias) {
        return this.column(SqlHelper.buildSelectSql(select), columnAlias);
    }

    public Select column(Column column, String columnAlias) {
        Column newColumn;
        if (column instanceof SqlFun) {
            newColumn = SqlBeanUtil.copy(column);
            newColumn.setAlias(columnAlias);
        } else {
            newColumn = new Column(column.getTableAlias(), column.getName(), columnAlias);
        }
        this.columnList.add(newColumn);
        return this;
    }

    public <T, R> Select column(ColumnFunction<T, R> columnFunction, String columnAlias) {
        Column column = LambdaUtil.getColumn(columnFunction);
        column.setAlias(columnAlias);
        this.columnList.add(column);
        return this;
    }

    public Select column(String tableAlias, String columnName, String columnAlias) {
        this.columnList.add(new Column(tableAlias, columnName, columnAlias));
        return this;
    }

    public Join addJoin(Join join) {
        join.setReturnObj(this);
        this.joinList.add(join);
        return join;
    }

    public List<Join> getJoin() {
        return this.joinList;
    }

    @Deprecated
    public Select join(String table, String tableKeyword, String mainKeyword) {
        return this.join(JoinType.INNER_JOIN, "", table, table, tableKeyword, mainKeyword);
    }

    @Deprecated
    public Select join(JoinType joinType, String table, String tableKeyword, String mainKeyword) {
        return this.join(joinType, "", table, table, tableKeyword, mainKeyword);
    }

    @Deprecated
    public Select join(String schema, String table, String tableAlias, String tableKeyword, String mainKeyword) {
        return this.join(JoinType.INNER_JOIN, schema, table, tableAlias, tableKeyword, mainKeyword);
    }

    @Deprecated
    public Select join(JoinType joinType, String schema, String table, String tableAlias, String tableKeyword, String mainKeyword) {
        this.joinList.add(new Join(joinType, schema, table, tableAlias, tableKeyword, mainKeyword, ""));
        return this;
    }

    @Deprecated
    public Select join(String table, String on) {
        return this.join(JoinType.INNER_JOIN, "", table, table, on);
    }

    @Deprecated
    public Select join(JoinType joinType, String table, String on) {
        return this.join(joinType, "", table, table, on);
    }

    @Deprecated
    public Select join(JoinType joinType, String schema, String table, String tableAlias, String on) {
        this.joinList.add(new Join(joinType, schema, table, tableAlias, "", "", on));
        return this;
    }

    public Join innerJoin(Class<?> clazz) {
        Table table = SqlBeanUtil.getTable(clazz);
        return this.innerJoin(table.getSchema(), table.getName(), table.getAlias());
    }

    public Join innerJoin(String table, String tableAlias) {
        return this.innerJoin(null, table, tableAlias);
    }

    public Join innerJoin(String schema, String table, String tableAlias) {
        Join join = new Join(JoinType.INNER_JOIN, schema, table, tableAlias);
        join.setReturnObj(this);
        this.joinList.add(join);
        return join;
    }

    public Join leftJoin(Class<?> clazz) {
        Table table = SqlBeanUtil.getTable(clazz);
        return this.leftJoin(table.getSchema(), table.getName(), table.getAlias());
    }

    public Join leftJoin(String table, String tableAlias) {
        return this.leftJoin(null, table, tableAlias);
    }

    public Join leftJoin(String schema, String table, String tableAlias) {
        Join join = new Join(JoinType.LEFT_JOIN, schema, table, tableAlias);
        join.setReturnObj(this);
        this.joinList.add(join);
        return join;
    }

    public Join rightJoin(Class<?> clazz) {
        Table table = SqlBeanUtil.getTable(clazz);
        return this.rightJoin(table.getSchema(), table.getName(), table.getAlias());
    }

    public Join rightJoin(String table, String tableAlias) {
        return this.rightJoin(null, table, tableAlias);
    }

    public Join rightJoin(String schema, String table, String tableAlias) {
        Join join = new Join(JoinType.RIGHT_JOIN, schema, table, tableAlias);
        join.setReturnObj(this);
        this.joinList.add(join);
        return join;
    }

    public Join fullJoin(Class<?> clazz) {
        Table table = SqlBeanUtil.getTable(clazz);
        return this.fullJoin(table.getSchema(), table.getName(), table.getAlias());
    }

    public Join fullJoin(String table, String tableAlias) {
        return this.fullJoin(null, table, tableAlias);
    }

    public Join fullJoin(String schema, String table, String tableAlias) {
        Join join = new Join(JoinType.FULL_JOIN, schema, table, tableAlias);
        join.setReturnObj(this);
        this.joinList.add(join);
        return join;
    }

    public List<Group> getGroupBy() {
        return this.groupByList;
    }

    public Select groupBy(String columNname) {
        return this.groupBy("", columNname);
    }

    public Select groupBy(Column column) {
        return this.groupBy(column.getTableAlias(), column.getName());
    }

    public <T, R> Select groupBy(ColumnFunction<T, R> columnFunction) {
        Column column = LambdaUtil.getColumn(columnFunction);
        return this.groupBy(column.getTableAlias(), column.getName());
    }

    public Select groupBy(String tableAlias, String columNname) {
        this.groupByList.add(new Group(tableAlias, columNname));
        return this;
    }

    public List<Order> getOrderBy() {
        return this.orderByList;
    }

    public Select orderByAsc(String columNname) {
        return this.orderBy("", columNname, SqlSort.ASC);
    }

    public Select orderByDesc(String columNname) {
        return this.orderBy("", columNname, SqlSort.DESC);
    }

    public Select orderByAsc(Column column) {
        return this.orderBy(column.getTableAlias(), column.getName(), SqlSort.ASC);
    }

    public <T, R> Select orderByAsc(ColumnFunction<T, R> columnFunction) {
        Column column = LambdaUtil.getColumn(columnFunction);
        return this.orderBy(column.getTableAlias(), column.getName(), SqlSort.ASC);
    }

    public Select orderByDesc(Column column) {
        return this.orderBy(column.getTableAlias(), column.getName(), SqlSort.DESC);
    }

    public <T, R> Select orderByDesc(ColumnFunction<T, R> columnFunction) {
        Column column = LambdaUtil.getColumn(columnFunction);
        return this.orderBy(column.getTableAlias(), column.getName(), SqlSort.DESC);
    }

    public Select orderBy(String columName, SqlSort sqlSort) {
        this.orderByList.add(new Order("", columName, sqlSort));
        return this;
    }

    public Select orderBy(String tableAlias, String columName, SqlSort sqlSort) {
        this.orderByList.add(new Order(tableAlias, columName, sqlSort));
        return this;
    }

    public Select orderBy(Order[] orders) {
        if (orders != null && orders.length > 0) {
            this.orderByList.addAll(Arrays.asList(orders));
        }
        return this;
    }

    public Select page(Integer pagenum, Integer pagesize) {
        this.page = new Page(pagenum, pagesize);
        return this;
    }

    public Select page(Integer pagenum, Integer pagesize, boolean startByZero) {
        this.page = new Page(pagenum, pagesize, startByZero);
        return this;
    }

    public Select page(String idName, Integer pagenum, Integer pagesize) {
        this.page = new Page(idName, pagenum, pagesize);
        return this;
    }

    public Select page(String idName, Integer pagenum, Integer pagesize, boolean startByZero) {
        this.page = new Page(idName, pagenum, pagesize, startByZero);
        return this;
    }

    public Page getPage() {
        return this.page;
    }

    public String[] getFilterFields() {
        return this.filterFields;
    }

    public Select filterFields(String ... filterField) {
        this.filterFields = filterField;
        return this;
    }

    public Condition<Select> having() {
        return this.havingCondition;
    }

    public Wrapper getHavingWrapper() {
        return this.havingWrapper;
    }

    public Select having(Wrapper wrapper) {
        this.havingWrapper = wrapper;
        return this;
    }

    public String getHaving() {
        return this.having;
    }

    public Select having(String having, Object ... args) {
        this.having = having;
        this.havingArgs = args;
        return this;
    }

    public Object[] getHavingArgs() {
        return this.havingArgs;
    }

    public Select table(String name) {
        super.setTable(name, name);
        return this;
    }

    public Select table(String name, String aliasName) {
        super.setTable(name, aliasName);
        return this;
    }

    public Select table(String schema, String name, String aliasName) {
        super.setTable(schema, name, aliasName);
        return this;
    }

    public Select table(Class<?> clazz) {
        super.setTable(clazz);
        return this;
    }

    public Select copy() throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(this);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        return (Select)ois.readObject();
    }
}

