/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.mapper;

import cn.vonce.sql.annotation.SqlJoin;
import cn.vonce.sql.define.SqlEnum;
import cn.vonce.sql.uitls.ReflectUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;

public abstract class BaseMapper {
    public abstract List<String> getColumnNameList(AutoCloseable var1);

    public abstract Object baseHandleResultSet(AutoCloseable var1);

    public abstract Object mapHandleResultSet(AutoCloseable var1);

    public Object beanHandleResultSet(Class<?> clazz, AutoCloseable baseResult, List<String> columnNameList) {
        Object bean = ReflectUtil.instance().newObject(clazz);
        String tableAlias = SqlBeanUtil.getTable(clazz).getAlias();
        List<Field> fieldList = SqlBeanUtil.getBeanAllField(clazz);
        for (Field field : fieldList) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            SqlJoin sqlJoin = field.getAnnotation(SqlJoin.class);
            String fieldName = field.getName();
            if (sqlJoin != null) {
                if (sqlJoin.isBean()) {
                    Class<?> subClazz = field.getType();
                    Object subBean = ReflectUtil.instance().newObject(subClazz);
                    String subTableAlias = SqlBeanUtil.getTable(subClazz).getAlias();
                    if (StringUtil.isNotEmpty(sqlJoin.table())) {
                        subTableAlias = sqlJoin.table();
                    }
                    if (StringUtil.isNotEmpty(sqlJoin.tableAlias())) {
                        subTableAlias = sqlJoin.tableAlias();
                    }
                    List<Field> subFields = SqlBeanUtil.getBeanAllField(subClazz);
                    for (Field subField : subFields) {
                        if (Modifier.isStatic(subField.getModifiers())) continue;
                        String subFieldName = subField.getName();
                        subFieldName = subTableAlias + "_" + subFieldName;
                        this.setFieldValue(subBean, subField, subFieldName, baseResult);
                    }
                    ReflectUtil.instance().set(bean.getClass(), bean, fieldName, subBean);
                    continue;
                }
                if (!columnNameList.contains(fieldName)) {
                    String subTableAlias = sqlJoin.table();
                    if (StringUtil.isNotEmpty(sqlJoin.tableAlias())) {
                        subTableAlias = sqlJoin.tableAlias();
                    }
                    fieldName = subTableAlias + "_" + fieldName;
                }
                if (!columnNameList.contains(fieldName)) continue;
                this.setFieldValue(bean, field, fieldName, baseResult);
                continue;
            }
            String newFieldName = tableAlias + "_" + fieldName;
            if (!(columnNameList.contains(newFieldName) || columnNameList.contains(newFieldName = StringUtil.humpToUnderline(fieldName)) || columnNameList.contains(newFieldName = newFieldName.toUpperCase()) || columnNameList.contains(newFieldName = fieldName))) {
                newFieldName = fieldName.toUpperCase();
            }
            if (!columnNameList.contains(newFieldName)) continue;
            this.setFieldValue(bean, field, newFieldName, baseResult);
        }
        return bean;
    }

    public void setFieldValue(Object obj, Field field, String fieldName, AutoCloseable baseResult) {
        Object value = this.getValue(field.getType().getName(), fieldName, baseResult);
        if (value == null || value.equals("null")) {
            value = SqlBeanUtil.getDefaultValue(field.getType());
        }
        if (SqlEnum.class.isAssignableFrom(field.getType())) {
            ReflectUtil.instance().set(obj.getClass(), obj, field.getName(), SqlBeanUtil.matchEnum(field, value));
        } else {
            ReflectUtil.instance().set(obj.getClass(), obj, field.getName(), value);
        }
    }

    public abstract Object getValue(String var1, String var2, AutoCloseable var3);

    public abstract Object getValue(String var1, int var2, AutoCloseable var3);

    public Object getDefaultValueByColumnType(String typeName) {
        Constable value;
        switch (typeName) {
            case "BIGINT": 
            case "INTEGER": 
            case "TINYINT": 
            case "SMALLINT": {
                value = 0;
                break;
            }
            case "FLOAT": {
                value = Float.valueOf(0.0f);
                break;
            }
            case "DOUBLE": 
            case "NUMERIC": {
                value = 0.0;
                break;
            }
            case "BIT": {
                value = Boolean.valueOf(false);
                break;
            }
            case "CHAR": 
            case "VARCHAR": 
            case "LONGVARCHAR": {
                value = null;
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }
}

