/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.enumerate;

import cn.vonce.sql.config.SqlBeanDB;
import cn.vonce.sql.uitls.StringUtil;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public enum JavaMapSqlServerType {
    INTEGER(new Class[]{Integer.TYPE, Integer.class}),
    BIGINT(new Class[]{Long.TYPE, Long.class}),
    SMALLINT(new Class[]{Short.TYPE, Short.class}),
    REAL(new Class[]{Float.TYPE, Float.class}),
    FLOAT(new Class[]{Double.TYPE, Double.class}),
    NUMERIC(new Class[]{BigDecimal.class}),
    NCHAR(new Class[]{Character.TYPE, Character.class}),
    NVARCHAR(new Class[]{String.class}),
    TINYINT(new Class[]{Byte.TYPE, Byte.class}),
    BIT(new Class[]{Boolean.TYPE, Boolean.class}),
    DATE(new Class[]{java.sql.Date.class}),
    TIME(new Class[]{Time.class}),
    DATETIME2(new Class[]{Timestamp.class}),
    DATETIME(new Class[]{Date.class}),
    NTEXT(new Class[]{Clob.class}),
    IMAGE(new Class[]{Blob.class, Object.class});

    private Class<?>[] classes;

    private JavaMapSqlServerType(Class<?>[] classes) {
        this.classes = classes;
    }

    public static JavaMapSqlServerType getType(Class<?> clazz) {
        for (JavaMapSqlServerType javaType : JavaMapSqlServerType.values()) {
            for (Class<?> thisClazz : javaType.classes) {
                if (thisClazz != clazz) continue;
                return javaType;
            }
        }
        return null;
    }

    public static String getTypeName(Class<?> clazz) {
        return JavaMapSqlServerType.getType(clazz).name();
    }

    public static String getTableListSql(SqlBeanDB sqlBeanDB, String schema, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT o.name, p.value AS remarks ");
        sql.append("FROM sysobjects o ");
        sql.append("LEFT JOIN sys.extended_properties p ");
        sql.append("ON p.major_id = o.id AND p.minor_id = 0 ");
        sql.append("WHERE o.xtype='U'");
        if (StringUtil.isNotEmpty(tableName)) {
            sql.append(" AND o.name = '" + tableName + "'");
        }
        return sql.toString();
    }

    public static String getColumnListSql(SqlBeanDB sqlBeanDB, String schema, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT a.cid, a.name, a.type, (CASE a.notnull WHEN 0 THEN 1 ELSE 0 END) AS notnull, ");
        sql.append("(CASE LEFT(constraint_name, 2) WHEN 'PK' THEN 1 ELSE 0 END) AS pk, ");
        sql.append("(CASE LEFT(constraint_name, 2) WHEN 'FK' THEN 1 ELSE 0 END) AS fk, ");
        sql.append("a.length, a.scale, c.value AS remarks ");
        sql.append("FROM (");
        sql.append("SELECT syscolumns.id, syscolumns.colid AS cid, syscolumns.name AS name, syscolumns.length AS length, syscolumns.scale, systypes.name AS type, syscolumns.isnullable AS notnull, '");
        sql.append(tableName);
        sql.append("' AS table_name ");
        sql.append("FROM syscolumns, systypes ");
        sql.append("WHERE syscolumns.xusertype = systypes.xusertype AND syscolumns.id = object_id('");
        sql.append(tableName);
        sql.append("')) a ");
        sql.append("LEFT JOIN information_schema.key_column_usage b ON a.name = b.column_name AND a.table_name = b.table_name ");
        sql.append("LEFT JOIN sys.extended_properties c ON c.major_id = a.id AND c.minor_id = a.cid ");
        sql.append("ORDER BY a.cid");
        return sql.toString();
    }
}

