/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.provider;

import cn.vonce.sql.bean.Backup;
import cn.vonce.sql.bean.Column;
import cn.vonce.sql.bean.Common;
import cn.vonce.sql.bean.Copy;
import cn.vonce.sql.bean.Create;
import cn.vonce.sql.bean.Delete;
import cn.vonce.sql.bean.Drop;
import cn.vonce.sql.bean.Insert;
import cn.vonce.sql.bean.Order;
import cn.vonce.sql.bean.Paging;
import cn.vonce.sql.bean.Select;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.bean.Update;
import cn.vonce.sql.config.SqlBeanDB;
import cn.vonce.sql.enumerate.DbType;
import cn.vonce.sql.enumerate.SqlOperator;
import cn.vonce.sql.exception.SqlBeanException;
import cn.vonce.sql.helper.SqlHelper;
import cn.vonce.sql.helper.Wrapper;
import cn.vonce.sql.provider.DynSchemaContextHolder;
import cn.vonce.sql.uitls.ReflectUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.io.IOException;
import java.lang.reflect.Field;

public class SqlBeanProvider {
    public static String selectByIdSql(SqlBeanDB sqlBeanDB, Class<?> clazz, Object id) {
        return SqlBeanProvider.selectByIdsSql(sqlBeanDB, clazz, id);
    }

    public static String selectByIdsSql(SqlBeanDB sqlBeanDB, Class<?> clazz, Object ... ids) {
        Field idField;
        Select select;
        try {
            select = SqlBeanProvider.newSelect(sqlBeanDB, clazz, false);
            idField = SqlBeanUtil.getIdField(clazz);
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        if (ids.length > 1) {
            select.where(SqlBeanUtil.getTable(clazz).getAlias(), SqlBeanUtil.getTableFieldName(idField), (Object)ids, SqlOperator.IN);
        } else {
            select.where(SqlBeanUtil.getTable(clazz).getAlias(), SqlBeanUtil.getTableFieldName(idField), ids[0], SqlOperator.EQUAL_TO);
        }
        return SqlHelper.buildSelectSql(select);
    }

    public static String selectByConditionSql(SqlBeanDB sqlBeanDB, Class<?> clazz, Paging paging, String where, Object ... args) {
        Select select = SqlBeanProvider.newSelect(sqlBeanDB, clazz, false);
        select.setWhere(where, args);
        SqlBeanProvider.setPaging(select, paging, clazz);
        return SqlHelper.buildSelectSql(select);
    }

    public static String selectCountByConditionSql(SqlBeanDB sqlBeanDB, Class<?> clazz, String where, Object[] args) {
        Select select = SqlBeanProvider.newSelect(sqlBeanDB, clazz, true);
        select.setWhere(where, args);
        return SqlHelper.buildSelectSql(select);
    }

    public static String selectAllSql(SqlBeanDB sqlBeanDB, Class<?> clazz, Paging paging) {
        Select select = SqlBeanProvider.newSelect(sqlBeanDB, clazz, false);
        SqlBeanProvider.setPaging(select, paging, clazz);
        return SqlHelper.buildSelectSql(select);
    }

    public static String selectSql(SqlBeanDB sqlBeanDB, Class<?> clazz, Select select) {
        if (select.getSqlBeanDB() == null) {
            select.setSqlBeanDB(sqlBeanDB);
        }
        if (select.getColumnList().isEmpty()) {
            try {
                select.setColumnList(SqlBeanUtil.getSelectColumns(clazz, select.getFilterFields()));
                if (select.getPage() != null && select.getSqlBeanDB().getDbType() == DbType.SQLServer) {
                    select.getPage().setIdName(SqlBeanUtil.getTableFieldName(SqlBeanUtil.getIdField(clazz)));
                }
            }
            catch (SqlBeanException e) {
                e.printStackTrace();
                return null;
            }
        }
        return SqlBeanProvider.setSelectAndBuild(clazz, select);
    }

    public static String countSql(SqlBeanDB sqlBeanDB, Class<?> clazz, Select select) {
        if (select.getSqlBeanDB() == null) {
            select.setSqlBeanDB(sqlBeanDB);
        }
        if (select.getColumnList() == null || select.getColumnList().isEmpty()) {
            select.column("COUNT( * )");
        } else if (select.getColumnList().size() > 1 || select.getColumnList().get(0).getName().toLowerCase().indexOf("count") == -1) {
            try {
                select = select.copy();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            select.getColumnList().clear();
            select.column("COUNT( * )");
        }
        return SqlBeanProvider.setSelectAndBuild(clazz, select);
    }

    public static String deleteByIdSql(SqlBeanDB sqlBeanDB, Class<?> clazz, Object id) {
        Field idField;
        if (StringUtil.isEmpty(id)) {
            try {
                throw new SqlBeanException("deleteByIdSql id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            catch (SqlBeanException e) {
                e.printStackTrace();
                return null;
            }
        }
        Delete delete = new Delete();
        delete.setSqlBeanDB(sqlBeanDB);
        delete.setTable(clazz);
        SqlBeanProvider.setSchema(delete, clazz);
        try {
            idField = SqlBeanUtil.getIdField(clazz);
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        delete.where("", SqlBeanUtil.getTableFieldName(idField), id, SqlOperator.IN);
        return SqlHelper.buildDeleteSql(delete);
    }

    public static String deleteByConditionSql(SqlBeanDB sqlBeanDB, Class<?> clazz, String where, Object[] args) {
        Delete delete = new Delete();
        delete.setSqlBeanDB(sqlBeanDB);
        delete.setTable(clazz);
        delete.setWhere(where, args);
        SqlBeanProvider.setSchema(delete, clazz);
        return SqlHelper.buildDeleteSql(delete);
    }

    public static String deleteSql(SqlBeanDB sqlBeanDB, Class<?> clazz, Delete delete, boolean ignore) {
        if (delete.getSqlBeanDB() == null) {
            delete.setSqlBeanDB(sqlBeanDB);
        }
        if (delete.getTable().isNotSet()) {
            delete.setTable(clazz);
        }
        SqlBeanProvider.setSchema(delete, clazz);
        if (ignore || !delete.getWhereMap().isEmpty() || StringUtil.isNotEmpty(delete.getWhere()) || !delete.getWhereWrapper().getDataList().isEmpty()) {
            return SqlHelper.buildDeleteSql(delete);
        }
        try {
            throw new SqlBeanException("\u8be5delete sql\u672a\u8bbe\u7f6ewhere\u6761\u4ef6\uff0c\u5982\u679c\u786e\u5b9e\u4e0d\u9700\u8981where\u6761\u4ef6\uff0c\u8bf7\u4f7f\u7528delete(Select select, boolean ignore)");
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String logicallyDeleteByIdSql(SqlBeanDB sqlBeanDB, Class<?> clazz, Object id) {
        Update<Object> update = new Update<Object>();
        try {
            Object bean = SqlBeanProvider.newLogicallyDeleteBean(clazz);
            update.setSqlBeanDB(sqlBeanDB);
            update.setTable(clazz);
            update.setUpdateBean(bean);
            Field idField = SqlBeanUtil.getIdField(bean.getClass());
            update.where(SqlBeanUtil.getTableFieldName(idField), id, SqlOperator.IN);
            SqlBeanProvider.setSchema(update, clazz);
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        return SqlHelper.buildUpdateSql(update);
    }

    public static String logicallyDeleteByConditionSql(SqlBeanDB sqlBeanDB, Class<?> clazz, String where, Object[] args) {
        Update<Object> update = new Update<Object>();
        try {
            update.setSqlBeanDB(sqlBeanDB);
            update.setTable(clazz);
            update.setUpdateBean(SqlBeanProvider.newLogicallyDeleteBean(clazz));
            update.setWhere(where, args);
            SqlBeanProvider.setSchema(update, clazz);
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        return SqlHelper.buildUpdateSql(update);
    }

    public static String logicallyDeleteByConditionSql(SqlBeanDB sqlBeanDB, Class<?> clazz, Wrapper wrapper) {
        Update<Object> update = new Update<Object>();
        try {
            update.setSqlBeanDB(sqlBeanDB);
            update.setTable(clazz);
            update.setUpdateBean(SqlBeanProvider.newLogicallyDeleteBean(clazz));
            update.setWhere(wrapper);
            SqlBeanProvider.setSchema(update, clazz);
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        return SqlHelper.buildUpdateSql(update);
    }

    public static String updateSql(SqlBeanDB sqlBeanDB, Class<?> clazz, Update update, boolean ignore) {
        if (update.getSqlBeanDB() == null) {
            update.setSqlBeanDB(sqlBeanDB);
        }
        if (update.getTable().isNotSet()) {
            update.setTable(clazz);
        }
        SqlBeanProvider.setSchema(update, clazz);
        if (ignore || !update.getWhereMap().isEmpty() || StringUtil.isNotEmpty(update.getWhere()) || !update.getWhereWrapper().getDataList().isEmpty()) {
            return SqlHelper.buildUpdateSql(update);
        }
        try {
            throw new SqlBeanException("\u8be5update sql\u672a\u8bbe\u7f6ewhere\u6761\u4ef6\uff0c\u5982\u679c\u786e\u5b9e\u4e0d\u9700\u8981where\u6761\u4ef6\uff0c\u8bf7\u4f7f\u7528update(Select select, boolean ignore)");
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String updateByIdSql(SqlBeanDB sqlBeanDB, Class<?> clazz, Object bean, Object id, boolean updateNotNull, boolean optimisticLock, String[] filterFields) {
        Field idField;
        if (StringUtil.isEmpty(id)) {
            try {
                throw new SqlBeanException("updateByIdSql id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            catch (SqlBeanException e) {
                e.printStackTrace();
                return null;
            }
        }
        Update update = SqlBeanProvider.newUpdate(sqlBeanDB, clazz, bean, updateNotNull, optimisticLock);
        update.setFilterFields(filterFields);
        try {
            idField = SqlBeanUtil.getIdField(bean.getClass());
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        update.where(SqlBeanUtil.getTableFieldName(idField), id);
        return SqlHelper.buildUpdateSql(update);
    }

    public static String updateByBeanIdSql(SqlBeanDB sqlBeanDB, Class<?> clazz, Object bean, boolean updateNotNull, boolean optimisticLock, String[] filterFields) {
        Update update = SqlBeanProvider.newUpdate(sqlBeanDB, clazz, bean, updateNotNull, optimisticLock);
        update.setFilterFields(filterFields);
        try {
            Field idField = SqlBeanUtil.getIdField(bean.getClass());
            Object id = ReflectUtil.instance().get(bean.getClass(), bean, idField.getName());
            if (StringUtil.isEmpty(id)) {
                try {
                    throw new SqlBeanException("updateByBeanIdSql id\u4e0d\u80fd\u4e3a\u7a7a");
                }
                catch (SqlBeanException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            update.where(SqlBeanUtil.getTableFieldName(idField), id);
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        return SqlHelper.buildUpdateSql(update);
    }

    public static String updateByConditionSql(SqlBeanDB sqlBeanDB, Class<?> clazz, Object bean, boolean updateNotNull, boolean optimisticLock, String[] filterFields, String where, Object[] args) {
        Update update = SqlBeanProvider.newUpdate(sqlBeanDB, clazz, bean, updateNotNull, optimisticLock);
        update.setFilterFields(filterFields);
        update.setWhere(where, args);
        return SqlHelper.buildUpdateSql(update);
    }

    public static String updateByBeanConditionSql(SqlBeanDB sqlBeanDB, Class<?> clazz, Object bean, boolean updateNotNull, boolean optimisticLock, String[] filterFields, String where) {
        Update update = SqlBeanProvider.newUpdate(sqlBeanDB, clazz, bean, updateNotNull, optimisticLock);
        update.setFilterFields(filterFields);
        update.setWhere(where, null);
        return SqlHelper.buildUpdateSql(update);
    }

    public static String insertBeanSql(SqlBeanDB sqlBeanDB, Class<?> clazz, Object bean) {
        Insert<Object> insert = new Insert<Object>();
        insert.setSqlBeanDB(sqlBeanDB);
        insert.setTable(clazz);
        insert.setInsertBean(SqlBeanUtil.getObjectArray(bean));
        SqlBeanProvider.setSchema(insert, clazz);
        return SqlHelper.buildInsertSql(insert);
    }

    public static String insertSql(SqlBeanDB sqlBeanDB, Class<?> clazz, Insert insert) {
        if (insert.getSqlBeanDB() == null) {
            insert.setSqlBeanDB(sqlBeanDB);
        }
        if (insert.getTable().isNotSet()) {
            insert.setTable(clazz);
        }
        SqlBeanProvider.setSchema(insert, clazz);
        return SqlHelper.buildInsertSql(insert);
    }

    public static String dropTableSql(SqlBeanDB sqlBeanDB, Class<?> clazz) {
        Drop drop = new Drop();
        drop.setSqlBeanDB(sqlBeanDB);
        drop.setTable(clazz);
        SqlBeanProvider.setSchema(drop, clazz);
        return SqlHelper.buildDrop(drop);
    }

    public static String createTableSql(SqlBeanDB sqlBeanDB, Class<?> clazz) {
        Create create = new Create();
        create.setSqlBeanDB(sqlBeanDB);
        create.setTable(clazz);
        create.setBeanClass(clazz);
        SqlBeanProvider.setSchema(create, clazz);
        return SqlHelper.buildCreateSql(create);
    }

    public static String selectTableListSql(SqlBeanDB sqlBeanDB, String name) {
        if (sqlBeanDB.getSqlBeanConfig().getToUpperCase() != null && sqlBeanDB.getSqlBeanConfig().getToUpperCase().booleanValue() && StringUtil.isNotEmpty(name)) {
            name = name.toUpperCase();
        }
        switch (sqlBeanDB.getDbType()) {
            case MySQL: 
            case MariaDB: {
                return "select table_name as `name` from information_schema.tables where table_schema = database() and table_type = 'BASE TABLE'" + (StringUtil.isNotEmpty(name) ? " and table_name = '" + name + "'" : "");
            }
            case SQLServer: {
                return "select name from sysobjects where xtype='U'" + (StringUtil.isNotEmpty(name) ? " and name = '" + name + "'" : "");
            }
            case Oracle: {
                return "select table_name as \"name\" from user_tables" + (StringUtil.isNotEmpty(name) ? " where table_name = '" + name + "'" : "");
            }
            case PostgreSQL: {
                return "select tablename as \"name\" from pg_tables where schemaname = 'public'" + (StringUtil.isNotEmpty(name) ? " and tablename = '" + name + "'" : "");
            }
            case DB2: {
                return "select name from sysibm.systables where type = 'T' and creator = current user" + (StringUtil.isNotEmpty(name) ? " and name = '" + name + "'" : "") + (StringUtil.isNotEmpty(name) ? " and table_name = '" + name + "'" : "");
            }
            case H2: {
                return "select table_name as \"name\" from information_schema.tables where table_type = 'TABLE'" + (StringUtil.isNotEmpty(name) ? " and table_name = '" + name + "'" : "");
            }
            case Hsql: {
                return "select table_name as \"name\" from information_schema.tables where table_type = 'BASE TABLE'" + (StringUtil.isNotEmpty(name) ? " and table_name = '" + name + "'" : "");
            }
            case Derby: {
                return "select tablename as \"name\" from SYS.systables where tabletype = 'T'" + (StringUtil.isNotEmpty(name) ? " and tablename = '" + name + "'" : "");
            }
            case SQLite: {
                return "select name from sqlite_master where type='table'" + (StringUtil.isNotEmpty(name) ? " and name = '" + name + "'" : "");
            }
        }
        throw new SqlBeanException("\u8bf7\u914d\u7f6e\u6b63\u786e\u7684\u6570\u636e\u5e93");
    }

    public static String backupSql(SqlBeanDB sqlBeanDB, Class<?> clazz, String targetSchema, String targetTableName, Column[] columns, Wrapper wrapper) {
        Backup backup = new Backup();
        backup.setSqlBeanDB(sqlBeanDB);
        backup.setTable(clazz);
        backup.setColumns(columns);
        backup.setTargetSchema(targetSchema);
        backup.setTargetTableName(targetTableName);
        backup.setWhere(wrapper);
        SqlBeanProvider.setSchema(backup, clazz);
        return SqlHelper.buildBackup(backup);
    }

    public static String copySql(SqlBeanDB sqlBeanDB, Class<?> clazz, String targetSchema, String targetTableName, Column[] columns, Wrapper wrapper) {
        Copy copy = new Copy();
        copy.setSqlBeanDB(sqlBeanDB);
        copy.setTable(clazz);
        copy.setColumns(columns);
        copy.setTargetSchema(targetSchema);
        copy.setTargetTableName(targetTableName);
        copy.setWhere(wrapper);
        return SqlHelper.buildCopy(copy);
    }

    private static Select newSelect(SqlBeanDB sqlBeanDB, Class<?> clazz, boolean isCount) {
        Select select = new Select();
        select.setSqlBeanDB(sqlBeanDB);
        select.setTable(clazz);
        try {
            if (isCount) {
                select.column("COUNT( * )");
            } else {
                select.setColumnList(SqlBeanUtil.getSelectColumns(clazz, select.getFilterFields()));
            }
            SqlBeanUtil.setJoin(select, clazz);
            SqlBeanProvider.setSchema(select, clazz);
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        return select;
    }

    private static String setSelectAndBuild(Class<?> clazz, Select select) {
        if (StringUtil.isEmpty(select.getTable().getName())) {
            Table table = SqlBeanUtil.getTable(clazz);
            select.getTable().setName(table.getName());
            if (StringUtil.isEmpty(select.getTable().getAlias())) {
                select.getTable().setAlias(table.getAlias());
            }
        }
        SqlBeanProvider.setSchema(select, clazz);
        try {
            SqlBeanUtil.setJoin(select, clazz);
        }
        catch (SqlBeanException e) {
            e.printStackTrace();
            return null;
        }
        if (!select.getOrderBy().isEmpty()) {
            for (Order order : select.getOrderBy()) {
                if (!StringUtil.isEmpty(order.getTableAlias())) continue;
                order.setTableAlias(select.getTable().getAlias());
            }
        }
        return SqlHelper.buildSelectSql(select);
    }

    private static Object newLogicallyDeleteBean(Class<?> clazz) throws SqlBeanException {
        Object bean = null;
        try {
            bean = clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        Field field = SqlBeanUtil.getLogicallyField(clazz);
        ReflectUtil.instance().set(bean.getClass(), bean, field.getName(), true);
        return bean;
    }

    private static Update newUpdate(SqlBeanDB sqlBeanDB, Class<?> clazz, Object bean, boolean updateNotNull, boolean optimisticLock) {
        Update<Object> update = new Update<Object>();
        update.setSqlBeanDB(sqlBeanDB);
        update.setTable(clazz);
        update.setUpdateBean(bean);
        update.setUpdateNotNull(updateNotNull);
        update.setOptimisticLock(optimisticLock);
        SqlBeanProvider.setSchema(update, clazz);
        return update;
    }

    private static void setPaging(Select select, Paging paging, Class<?> clazz) {
        if (paging != null) {
            if (select.getSqlBeanDB().getDbType() == DbType.SQLServer) {
                try {
                    select.setPage(SqlBeanUtil.getTableFieldName(SqlBeanUtil.getIdField(clazz)), paging.getPagenum(), paging.getPagesize());
                }
                catch (SqlBeanException e) {
                    e.printStackTrace();
                }
            } else {
                select.setPage(null, paging.getPagenum(), paging.getPagesize());
            }
            select.orderBy(paging.getOrders());
        }
    }

    private static void setSchema(Common common, Class<?> clazz) {
        if (StringUtil.isEmpty(common.getTable().getSchema())) {
            String schema = DynSchemaContextHolder.getSchema();
            if (StringUtil.isNotEmpty(schema)) {
                common.getTable().setSchema(schema);
            } else {
                common.getTable().setSchema(SqlBeanUtil.getTable(clazz).getSchema());
            }
        }
    }
}

