/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.enumerate;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public enum JavaType {
    INTEGER(new Class[]{Integer.TYPE, Integer.class}),
    BIGINT(new Class[]{Long.TYPE, Long.class}),
    SMALLINT(new Class[]{Short.TYPE, Short.class}),
    FLOAT(new Class[]{Float.TYPE, Float.class}),
    DOUBLE(new Class[]{Double.TYPE, Double.class}),
    NUMERIC(new Class[]{BigDecimal.class}),
    CHAR(new Class[]{Character.TYPE, Character.class}),
    VARCHAR(new Class[]{String.class}),
    TINYINT(new Class[]{Byte.TYPE, Byte.class}),
    BIT(new Class[]{Boolean.TYPE, Boolean.class}),
    DATE(new Class[]{java.sql.Date.class}),
    TIME(new Class[]{Time.class}),
    TIMESTAMP(new Class[]{Timestamp.class}),
    DATETIME(new Class[]{Date.class}),
    CLOB(new Class[]{Clob.class}),
    BLOB(new Class[]{Blob.class});

    private Class<?>[] classes;

    private JavaType(Class<?>[] classes) {
        this.classes = classes;
    }

    public static JavaType getType(Class<?> clazz) {
        for (JavaType javaType : JavaType.values()) {
            for (Class<?> thisClazz : javaType.classes) {
                if (thisClazz != clazz) continue;
                return javaType;
            }
        }
        return null;
    }

    public static String getTypeName(Class<?> clazz) {
        return JavaType.getType(clazz).name();
    }
}

