/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.bean;

import cn.vonce.sql.bean.Column;
import cn.vonce.sql.bean.Group;
import cn.vonce.sql.bean.Join;
import cn.vonce.sql.bean.Order;
import cn.vonce.sql.bean.Page;
import cn.vonce.sql.bean.SelectCondition;
import cn.vonce.sql.enumerate.JoinType;
import cn.vonce.sql.enumerate.SqlSort;
import cn.vonce.sql.helper.SqlHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Select
extends SelectCondition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean useDistinct = false;
    private List<Column> columnList = new ArrayList<Column>();
    private List<Join> joinList = new ArrayList<Join>();
    private List<Group> groupByList = new ArrayList<Group>();
    private List<Order> orderByList = new ArrayList<Order>();
    private Page page = null;
    private String[] filterFields = null;

    public boolean isUseDistinct() {
        return this.useDistinct;
    }

    public void setUseDistinct(boolean useDistinct) {
        this.useDistinct = useDistinct;
    }

    public List<Column> getColumnList() {
        return this.columnList;
    }

    public void setColumnList(List<Column> columnList) {
        this.columnList.addAll(columnList);
    }

    public void setColumn(String ... columnNames) {
        for (String columnName : columnNames) {
            this.columnList.add(new Column(columnName));
        }
    }

    public void setColumn(Column ... columns) {
        if (columns == null || columns.length == 0) {
            return;
        }
        this.columnList.addAll(Arrays.asList(columns));
    }

    public Select column(Column column) {
        this.columnList.add(column);
        return this;
    }

    public Select column(String columnName) {
        return this.column("", columnName, "");
    }

    public Select column(String columnName, String columnAlias) {
        return this.column("", columnName, columnAlias);
    }

    public Select column(Select select, String columnAlias) {
        return this.column(SqlHelper.buildSelectSql(select), columnAlias);
    }

    public Select column(Column column, String columnAlias) {
        return this.column(column.getTableAlias(), column.getName(), columnAlias);
    }

    public Select column(String tableAlias, String columnName, String columnAlias) {
        this.columnList.add(new Column(tableAlias, columnName, columnAlias));
        return this;
    }

    public List<Join> getJoin() {
        return this.joinList;
    }

    public Select join(String table, String tableKeyword, String mainKeyword) {
        return this.join(JoinType.INNER_JOIN, "", table, table, tableKeyword, mainKeyword);
    }

    public Select join(JoinType joinType, String table, String tableKeyword, String mainKeyword) {
        return this.join(joinType, "", table, table, tableKeyword, mainKeyword);
    }

    public Select join(String schema, String table, String tableAlias, String tableKeyword, String mainKeyword) {
        return this.join(JoinType.INNER_JOIN, schema, table, tableAlias, tableKeyword, mainKeyword);
    }

    public Select join(JoinType joinType, String schema, String table, String tableAlias, String tableKeyword, String mainKeyword) {
        this.joinList.add(new Join(joinType, schema, table, tableAlias, tableKeyword, mainKeyword, ""));
        return this;
    }

    public Select join(String table, String on) {
        return this.join(JoinType.INNER_JOIN, "", table, table, on);
    }

    public Select join(JoinType joinType, String table, String on) {
        return this.join(joinType, "", table, table, on);
    }

    public Select join(JoinType joinType, String schema, String table, String tableAlias, String on) {
        this.joinList.add(new Join(joinType, schema, table, tableAlias, "", "", on));
        return this;
    }

    public List<Group> getGroupBy() {
        return this.groupByList;
    }

    public Select groupBy(String columNname) {
        return this.groupBy("", columNname);
    }

    public Select groupBy(Column column) {
        return this.groupBy(column.getTableAlias(), column.getName());
    }

    public Select groupBy(String tableAlias, String columNname) {
        this.groupByList.add(new Group(tableAlias, columNname));
        return this;
    }

    public List<Order> getOrderBy() {
        return this.orderByList;
    }

    public Select orderBy(String columNname, SqlSort sqlSort) {
        return this.orderBy("", columNname, sqlSort);
    }

    public Select orderBy(Column column, SqlSort sqlSort) {
        return this.orderBy(column.getTableAlias(), column.getName(), sqlSort);
    }

    public Select orderBy(String tableAlias, String columNname, SqlSort sqlSort) {
        this.orderByList.add(new Order(tableAlias, columNname, sqlSort));
        return this;
    }

    public Select orderBy(Order[] orders) {
        if (orders != null && orders.length > 0) {
            this.orderByList.addAll(Arrays.asList(orders));
        }
        return this;
    }

    public void setPage(Integer pagenum, Integer pagesize) {
        this.page = new Page(pagenum, pagesize);
    }

    public void setPage(String idName, Integer pagenum, Integer pagesize) {
        this.page = new Page(idName, pagenum, pagesize);
    }

    public Page getPage() {
        return this.page;
    }

    public String[] getFilterFields() {
        return this.filterFields;
    }

    public void setFilterFields(String ... filterField) {
        this.filterFields = filterField;
    }

    public Select copy() throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(this);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        return (Select)ois.readObject();
    }
}

