package cn.vonce.sql.processor;

import cn.vonce.sql.annotation.SqlColumn;
import cn.vonce.sql.annotation.SqlTable;
import cn.vonce.sql.uitls.StringUtil;

import javax.annotation.processing.*;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import java.io.*;
import java.util.Set;

/**
 * 生成表字段常量处理器
 *
 * @author Jovi
 * @version 1.0
 * @email imjovi@qq.com
 * @date 2020/2/26 14:21
 */
public class SqlConstantProcessor extends AbstractProcessor {
    private Messager messager; //有点像Logger,用于输出信息
    private Filer filer; //可以获得Build Path，用于生成文件
    public static final String PREFIX = "Sql";

    // init做一些初始化操作
    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        try {
            for (TypeElement typeElement : annotations) {
                for (Element element : env.getElementsAnnotatedWith(typeElement)) {
                    SqlTable sqlTable = element.getAnnotation(SqlTable.class);
                    if (sqlTable != null && !sqlTable.constant()) {
                        continue;
                    }
                    Element enclosingElement = element.getEnclosingElement();
                    //获取父元素的全类名,用来生成包名
                    String packageName = ((PackageElement) enclosingElement).getQualifiedName().toString() + ".sql";
                    String schema = "";
                    String tableName = element.getSimpleName().toString();
                    String tableAlias = "";
                    String className = PREFIX + tableName;
                    if (sqlTable != null) {
                        schema = sqlTable.schema();
                        tableName = sqlTable.value();
                        tableAlias = sqlTable.alias();
                    }
                    if (StringUtil.isEmpty(tableAlias)) {
                        tableAlias = tableName;
                    }
                    try {
                        StringBuffer code = new StringBuffer();
                        code.append("/** The code is generated by the Sqlbean. Do not modify!*/\n\n");
                        code.append(String.format("package %s;\n\n", packageName));
                        code.append("import cn.vonce.sql.bean.Column;\n\n");
                        code.append(String.format("public class %s {\n\n", className));
                        code.append(String.format("\tpublic static final String _schema = \"%s\";\n", schema));
                        code.append(String.format("\tpublic static final String _tableName = \"%s\";\n", tableName));
                        code.append(String.format("\tpublic static final String _tableAlias = \"%s\";\n", tableAlias));
                        code.append(String.format("\tpublic static final String _all = \"%s.*\";\n", tableAlias));
                        code.append("\tpublic static final String _count = \"COUNT(*)\";\n");

                        for (Element subElement : element.getEnclosedElements()) {
                            if (subElement.getKind().isField() && !subElement.getModifiers().contains(Modifier.STATIC)) {
                                String sqlFieldName = subElement.getSimpleName().toString();
                                SqlColumn sqlColumn = subElement.getAnnotation(SqlColumn.class);
                                if (sqlColumn != null && StringUtil.isNotEmpty(sqlColumn.value())) {
                                    sqlFieldName = sqlColumn.value();
                                } else {
                                    if (sqlTable != null && sqlTable.mapUsToCc()) {
                                        sqlFieldName = StringUtil.humpToUnderline(sqlFieldName);
                                    }
                                }
                                code.append(String.format("\tpublic static final Column %s = new Column(_schema,_tableAlias,\"%s\",\"\");\n", sqlFieldName, sqlFieldName));
                            }
                        }

                        code.append("\n}");

                        JavaFileObject fileObject = processingEnv.getFiler().createSourceFile(
                                packageName + "." + className, enclosingElement);
                        Writer writer = fileObject.openWriter();
                        //写入java代码
                        writer.write(code.toString());
                        writer.flush();
                        writer.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } catch (Exception e) {
            messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
        return true;
    }

}
