/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.android.helper;

import android.content.Context;
import cn.vonce.sql.android.helper.DatabaseHelper;
import cn.vonce.sql.android.helper.SqlBeanHelper;
import cn.vonce.sql.uitls.SqlBeanUtil;
import java.util.Map;
import java.util.WeakHashMap;

public class SQLiteHelper {
    private static volatile SQLiteHelper defaultSqLiteHelper;
    private static final Map<String, SQLiteHelper> sqLiteHelperMap;
    private final Map<Class<?>, SqlBeanHelper> sqlBeanHelperMap = new WeakHashMap();
    private Context context;
    private String name;
    private int version;
    private DatabaseHelper databaseHelper;

    private SQLiteHelper(Context context, String name, int version) {
        this.context = context;
        this.name = name;
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(Context context, String name, int version) {
        if (defaultSqLiteHelper != null) return;
        Class<SQLiteHelper> clazz = SQLiteHelper.class;
        synchronized (SQLiteHelper.class) {
            if (defaultSqLiteHelper != null) return;
            defaultSqLiteHelper = new SQLiteHelper(context, name, version);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static SQLiteHelper db(Context context, String name, int version) {
        SQLiteHelper sqLiteHelper = sqLiteHelperMap.get(name);
        if (sqLiteHelper == null) {
            sqLiteHelper = new SQLiteHelper(context, name, version);
        } else if (sqLiteHelper.version != version) {
            sqLiteHelper.version = version;
            sqLiteHelper.sqlBeanHelperMap.clear();
            sqLiteHelperMap.put(name, sqLiteHelper);
        }
        return sqLiteHelper;
    }

    public static SQLiteHelper db() {
        SqlBeanUtil.isNull((Object)defaultSqLiteHelper, (String)"\u8bf7\u521d\u59cb\u5316\u9ed8\u8ba4\u6570\u636e\u5e93");
        return defaultSqLiteHelper;
    }

    public <T, ID> SqlBeanHelper<T, ID> get(Class<T> clazz) {
        SqlBeanHelper sqlBeanHelper = this.sqlBeanHelperMap.get(clazz);
        if (sqlBeanHelper == null) {
            if (this.databaseHelper == null) {
                this.databaseHelper = new DatabaseHelper(clazz, this.context, this.name, null, this.version);
            }
            sqlBeanHelper = new SqlBeanHelper(clazz, this.context, this.databaseHelper);
            this.sqlBeanHelperMap.put(clazz, sqlBeanHelper);
        }
        return sqlBeanHelper;
    }

    static {
        sqLiteHelperMap = new WeakHashMap<String, SQLiteHelper>();
    }
}

