/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.android.helper;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Build;
import android.util.Log;
import cn.vonce.sql.android.mapper.RowMapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class SQLiteTemplate {
    private SQLiteDatabase db;

    public SQLiteTemplate(SQLiteDatabase db) {
        this.db = db;
    }

    public <T> List<T> query(String sql, RowMapper<T> rowMapper) {
        ArrayList<T> list = new ArrayList<T>();
        Cursor cursor = this.db.rawQuery(sql, null);
        for (int i = 0; i < cursor.getCount(); ++i) {
            list.add(rowMapper.mapRow(cursor, i));
        }
        cursor.close();
        return list;
    }

    public <T> T queryForObject(String sql, RowMapper<T> rowMapper) {
        Cursor cursor = this.db.rawQuery(sql, null);
        T t = rowMapper.mapRow(cursor, 0);
        cursor.close();
        return t;
    }

    public int update(String sql) {
        int result = 0;
        try {
            Method method = this.db.getClass().getDeclaredMethod("executeSql", String.class, Object[].class);
            method.setAccessible(true);
            result = (Integer)method.invoke((Object)this.db, sql, null);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void execSQL(String sql) {
        this.db.execSQL(sql);
    }

    static {
        if (Build.VERSION.SDK_INT >= 28) {
            try {
                Method forName = Class.class.getDeclaredMethod("forName", String.class);
                Method getDeclaredMethod = Class.class.getDeclaredMethod("getDeclaredMethod", String.class, Class[].class);
                Class vmRuntimeClass = (Class)forName.invoke(null, "dalvik.system.VMRuntime");
                Method getRuntime = (Method)getDeclaredMethod.invoke((Object)vmRuntimeClass, "getRuntime", null);
                Method setHiddenApiExemptions = (Method)getDeclaredMethod.invoke((Object)vmRuntimeClass, "setHiddenApiExemptions", new Class[]{String[].class});
                Object sVmRuntime = getRuntime.invoke(null, new Object[0]);
                setHiddenApiExemptions.invoke(sVmRuntime, new Object[]{new String[]{"L"}});
            }
            catch (Throwable e) {
                Log.e((String)"sqlbean", (String)"reflect bootstrap failed:", (Throwable)e);
            }
        }
    }
}

