/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.android.helper;

import android.content.Context;
import cn.vonce.sql.android.helper.DatabaseHelper;
import cn.vonce.sql.android.service.SqlBeanServiceImpl;
import cn.vonce.sql.helper.SqlHelper;
import java.util.Map;
import java.util.WeakHashMap;

public class SQLiteHelper {
    private static SQLiteHelper defaultSqLiteHelper;
    private static final Map<String, SQLiteHelper> sqLiteHelperMap;
    private final Map<Class<?>, SqlBeanServiceImpl> sqlBeanServiceImplMap = new WeakHashMap();
    private Context context;
    private String name;
    private int version;
    private DatabaseHelper databaseHelper;

    private SQLiteHelper(Context context, String name, int version) {
        this.context = context;
        this.name = name;
        this.version = version;
    }

    public static void init(Context context, String name, int version) {
        if (defaultSqLiteHelper == null) {
            defaultSqLiteHelper = new SQLiteHelper(context, name, version);
        }
    }

    public static SQLiteHelper db(Context context, String name, int version) {
        SQLiteHelper sqLiteHelper = sqLiteHelperMap.get(name);
        if (sqLiteHelper == null) {
            sqLiteHelper = new SQLiteHelper(context, name, version);
        } else if (sqLiteHelper.version != version) {
            sqLiteHelper.version = version;
            sqLiteHelper.sqlBeanServiceImplMap.clear();
            sqLiteHelperMap.put(name, sqLiteHelper);
        }
        return sqLiteHelper;
    }

    public static SQLiteHelper db() {
        SqlHelper.isNull((Object)defaultSqLiteHelper, (String)"\u8bf7\u521d\u59cb\u5316\u9ed8\u8ba4\u6570\u636e\u5e93");
        return defaultSqLiteHelper;
    }

    public <T, ID> SqlBeanServiceImpl<T, ID> get(Class<T> clazz) {
        SqlBeanServiceImpl sqlBeanServiceImpl = this.sqlBeanServiceImplMap.get(clazz);
        if (sqlBeanServiceImpl == null) {
            if (this.databaseHelper == null) {
                this.databaseHelper = new DatabaseHelper(clazz, this.context, this.name, null, this.version);
            }
            sqlBeanServiceImpl = new SqlBeanServiceImpl(clazz, this.databaseHelper);
            this.sqlBeanServiceImplMap.put(clazz, sqlBeanServiceImpl);
        }
        return sqlBeanServiceImpl;
    }

    static {
        sqLiteHelperMap = new WeakHashMap<String, SQLiteHelper>();
    }
}

