/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.common.utils;

public class SHA1 {
    private static final int[] abcde = new int[]{1732584193, -271733879, -1732584194, 271733878, -1009589776};
    private static int[] digestInt = new int[5];
    private static int[] tmpData = new int[80];

    private static int process_input_bytes(byte[] bytedata) {
        System.arraycopy(abcde, 0, digestInt, 0, abcde.length);
        byte[] newbyte = SHA1.byteArrayFormatData(bytedata);
        int MCount = newbyte.length / 64;
        for (int pos = 0; pos < MCount; ++pos) {
            for (int j = 0; j < 16; ++j) {
                SHA1.tmpData[j] = SHA1.byteArrayToInt(newbyte, pos * 64 + j * 4);
            }
            SHA1.encrypt();
        }
        return 20;
    }

    private static byte[] byteArrayFormatData(byte[] bytedata) {
        int zeros = 0;
        int size = 0;
        int n = bytedata.length;
        int m = n % 64;
        if (m < 56) {
            zeros = 55 - m;
            size = n - m + 64;
        } else if (m == 56) {
            zeros = 63;
            size = n + 8 + 64;
        } else {
            zeros = 63 - m + 56;
            size = n + 64 - m + 64;
        }
        byte[] newbyte = new byte[size];
        System.arraycopy(bytedata, 0, newbyte, 0, n);
        int l = n;
        newbyte[l++] = -128;
        for (int i = 0; i < zeros; ++i) {
            newbyte[l++] = 0;
        }
        long N = (long)n * 8L;
        byte h8 = (byte)(N & 0xFFL);
        byte h7 = (byte)(N >> 8 & 0xFFL);
        byte h6 = (byte)(N >> 16 & 0xFFL);
        byte h5 = (byte)(N >> 24 & 0xFFL);
        byte h4 = (byte)(N >> 32 & 0xFFL);
        byte h3 = (byte)(N >> 40 & 0xFFL);
        byte h2 = (byte)(N >> 48 & 0xFFL);
        byte h1 = (byte)(N >> 56);
        newbyte[l++] = h1;
        newbyte[l++] = h2;
        newbyte[l++] = h3;
        newbyte[l++] = h4;
        newbyte[l++] = h5;
        newbyte[l++] = h6;
        newbyte[l++] = h7;
        newbyte[l++] = h8;
        return newbyte;
    }

    private static int f1(int x, int y, int z) {
        return x & y | ~x & z;
    }

    private static int f2(int x, int y, int z) {
        return x ^ y ^ z;
    }

    private static int f3(int x, int y, int z) {
        return x & y | x & z | y & z;
    }

    private static int f4(int x, int y) {
        return x << y | x >>> 32 - y;
    }

    private static void encrypt() {
        int tmp;
        for (int i = 16; i <= 79; ++i) {
            SHA1.tmpData[i] = SHA1.f4(tmpData[i - 3] ^ tmpData[i - 8] ^ tmpData[i - 14] ^ tmpData[i - 16], 1);
        }
        int[] tmpabcde = new int[5];
        for (int i1 = 0; i1 < tmpabcde.length; ++i1) {
            tmpabcde[i1] = digestInt[i1];
        }
        for (int j = 0; j <= 19; ++j) {
            tmp = SHA1.f4(tmpabcde[0], 5) + SHA1.f1(tmpabcde[1], tmpabcde[2], tmpabcde[3]) + tmpabcde[4] + tmpData[j] + 1518500249;
            tmpabcde[4] = tmpabcde[3];
            tmpabcde[3] = tmpabcde[2];
            tmpabcde[2] = SHA1.f4(tmpabcde[1], 30);
            tmpabcde[1] = tmpabcde[0];
            tmpabcde[0] = tmp;
        }
        for (int k = 20; k <= 39; ++k) {
            tmp = SHA1.f4(tmpabcde[0], 5) + SHA1.f2(tmpabcde[1], tmpabcde[2], tmpabcde[3]) + tmpabcde[4] + tmpData[k] + 1859775393;
            tmpabcde[4] = tmpabcde[3];
            tmpabcde[3] = tmpabcde[2];
            tmpabcde[2] = SHA1.f4(tmpabcde[1], 30);
            tmpabcde[1] = tmpabcde[0];
            tmpabcde[0] = tmp;
        }
        for (int l = 40; l <= 59; ++l) {
            tmp = SHA1.f4(tmpabcde[0], 5) + SHA1.f3(tmpabcde[1], tmpabcde[2], tmpabcde[3]) + tmpabcde[4] + tmpData[l] + -1894007588;
            tmpabcde[4] = tmpabcde[3];
            tmpabcde[3] = tmpabcde[2];
            tmpabcde[2] = SHA1.f4(tmpabcde[1], 30);
            tmpabcde[1] = tmpabcde[0];
            tmpabcde[0] = tmp;
        }
        for (int m = 60; m <= 79; ++m) {
            tmp = SHA1.f4(tmpabcde[0], 5) + SHA1.f2(tmpabcde[1], tmpabcde[2], tmpabcde[3]) + tmpabcde[4] + tmpData[m] + -899497514;
            tmpabcde[4] = tmpabcde[3];
            tmpabcde[3] = tmpabcde[2];
            tmpabcde[2] = SHA1.f4(tmpabcde[1], 30);
            tmpabcde[1] = tmpabcde[0];
            tmpabcde[0] = tmp;
        }
        for (int i2 = 0; i2 < tmpabcde.length; ++i2) {
            SHA1.digestInt[i2] = digestInt[i2] + tmpabcde[i2];
        }
        for (int n = 0; n < tmpData.length; ++n) {
            SHA1.tmpData[n] = 0;
        }
    }

    private static int byteArrayToInt(byte[] bytedata, int i) {
        return (bytedata[i] & 0xFF) << 24 | (bytedata[i + 1] & 0xFF) << 16 | (bytedata[i + 2] & 0xFF) << 8 | bytedata[i + 3] & 0xFF;
    }

    private static void intToByteArray(int intValue, byte[] byteData, int i) {
        byteData[i] = (byte)(intValue >>> 24);
        byteData[i + 1] = (byte)(intValue >>> 16);
        byteData[i + 2] = (byte)(intValue >>> 8);
        byteData[i + 3] = (byte)intValue;
    }

    private static String byteToHexString(byte ib) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] ob = new char[]{Digit[ib >>> 4 & 0xF], Digit[ib & 0xF]};
        String s = new String(ob);
        return s;
    }

    private static String byteArrayToHexString(byte[] bytearray) {
        String strDigest = "";
        for (int i = 0; i < bytearray.length; ++i) {
            strDigest = strDigest + SHA1.byteToHexString(bytearray[i]);
        }
        return strDigest;
    }

    public static byte[] getDigestOfBytes(byte[] byteData) {
        SHA1.process_input_bytes(byteData);
        byte[] digest = new byte[20];
        for (int i = 0; i < digestInt.length; ++i) {
            SHA1.intToByteArray(digestInt[i], digest, i * 4);
        }
        return digest;
    }

    public static String getDigestOfString(byte[] byteData) {
        return SHA1.byteArrayToHexString(SHA1.getDigestOfBytes(byteData));
    }

    public static byte[] getDigest(byte[] byteData) {
        return SHA1.getDigestOfBytes(byteData);
    }
}

