/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.common.utils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class BeanToMapUtil {
    public static <T> T toBean(Class<T> clazz, Map map) {
        T obj = null;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            obj = clazz.newInstance();
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor descriptor = propertyDescriptors[i];
                String propertyName = descriptor.getName();
                if (!map.containsKey(propertyName)) continue;
                Object value = map.get(propertyName);
                if ("".equals(value)) {
                    value = null;
                }
                Object[] args = new Object[]{value};
                try {
                    descriptor.getWriteMethod().invoke(obj, args);
                    continue;
                }
                catch (InvocationTargetException e) {
                    System.out.println("\u5b57\u6bb5\u6620\u5c04\u5931\u8d25");
                }
            }
        }
        catch (IllegalAccessException e) {
            System.out.println("\u5b9e\u4f8b\u5316 JavaBean \u5931\u8d25");
        }
        catch (IntrospectionException e) {
            System.out.println("\u5206\u6790\u7c7b\u5c5e\u6027\u5931\u8d25");
        }
        catch (IllegalArgumentException e) {
            System.out.println("\u6620\u5c04\u9519\u8bef");
        }
        catch (InstantiationException e) {
            System.out.println("\u5b9e\u4f8b\u5316 JavaBean \u5931\u8d25");
        }
        return obj;
    }

    public static Map toMap(Object bean) {
        Class<?> clazz = bean.getClass();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor descriptor = propertyDescriptors[i];
                String propertyName = descriptor.getName();
                if (propertyName.equals("class")) continue;
                Method readMethod = descriptor.getReadMethod();
                Object result = null;
                result = readMethod.invoke(bean, new Object[0]);
                if (null != propertyName) {
                    propertyName = propertyName.toString();
                }
                if (null != result) {
                    result = result.toString();
                }
                returnMap.put(propertyName, result);
            }
        }
        catch (IntrospectionException e) {
            System.out.println("\u5206\u6790\u7c7b\u5c5e\u6027\u5931\u8d25");
        }
        catch (IllegalAccessException e) {
            System.out.println("\u5b9e\u4f8b\u5316 JavaBean \u5931\u8d25");
        }
        catch (IllegalArgumentException e) {
            System.out.println("\u6620\u5c04\u9519\u8bef");
        }
        catch (InvocationTargetException e) {
            System.out.println("\u8c03\u7528\u5c5e\u6027\u7684 setter \u65b9\u6cd5\u5931\u8d25");
        }
        return returnMap;
    }
}

