/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.supercode.core.helper;

import cn.vonce.sql.annotation.SqlColumn;
import cn.vonce.sql.annotation.SqlDefaultValue;
import cn.vonce.sql.annotation.SqlTable;
import cn.vonce.sql.bean.ColumnInfo;
import cn.vonce.sql.bean.Create;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.bean.TableInfo;
import cn.vonce.sql.config.SqlBeanConfig;
import cn.vonce.sql.config.SqlBeanMeta;
import cn.vonce.sql.enumerate.DbType;
import cn.vonce.sql.enumerate.FillWith;
import cn.vonce.sql.enumerate.IdType;
import cn.vonce.sql.helper.SqlHelper;
import cn.vonce.sql.service.DbManageService;
import cn.vonce.sql.uitls.DateUtil;
import cn.vonce.sql.uitls.JavaParserUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import cn.vonce.supercode.core.config.GenerateConfig;
import cn.vonce.supercode.core.enumeration.Template;
import cn.vonce.supercode.core.enumeration.TemplateType;
import cn.vonce.supercode.core.map.JdbcMapJava;
import cn.vonce.supercode.core.model.ClassInfo;
import cn.vonce.supercode.core.model.FieldInfo;
import cn.vonce.supercode.core.util.ClassUtil;
import cn.vonce.supercode.core.util.FreemarkerUtil;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.comments.Comment;
import freemarker.template.Configuration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class GenerateHelper {
    public static void build(GenerateConfig config, DbManageService<?> dbManageService) {
        List<TableInfo> tableInfoList = GenerateHelper.getTableInfoList(dbManageService);
        File packDir = GenerateHelper.getFilePaths(config);
        ThreadPoolExecutor pool = new ThreadPoolExecutor(3, 5, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        int num = 10;
        int size = tableInfoList.size() % num == 0 ? tableInfoList.size() / num : tableInfoList.size() / num + 1;
        int i = 0;
        while (i < size) {
            int finalI = i++;
            pool.execute(() -> {
                List<ClassInfo> classInfoList = GenerateHelper.getClassInfoList(config, tableInfoList.subList(num * finalI, finalI == size - 1 ? tableInfoList.size() : num * finalI + num), dbManageService);
                try {
                    GenerateHelper.make(config, packDir, classInfoList);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        pool.shutdown();
    }

    public static void build(GenerateConfig config, TableInfo tableInfo, List<ColumnInfo> columnInfoList) {
        File packDir = GenerateHelper.getFilePaths(config);
        ArrayList<ClassInfo> classInfoList = new ArrayList<ClassInfo>();
        classInfoList.add(GenerateHelper.getClassInfo(config, tableInfo, columnInfoList));
        try {
            GenerateHelper.make(config, packDir, classInfoList);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void build(GenerateConfig config, DbType dbType, String ... packageNames) {
        GenerateHelper.build(config, dbType, false, packageNames);
    }

    public static void build(GenerateConfig config, DbType dbType, boolean sqlToUpperCase, String ... packageNames) {
        if (packageNames == null || packageNames.length == 0) {
            return;
        }
        ArrayList beanClassList = new ArrayList();
        for (String packageName : packageNames) {
            beanClassList.addAll(ClassUtil.getClasses(packageName));
        }
        for (Class clazz : beanClassList) {
            GenerateHelper.build(config, dbType, sqlToUpperCase, clazz);
        }
    }

    public static void build(GenerateConfig config, DbType dbType, List<Class<?>> beanClassList) {
        GenerateHelper.build(config, dbType, false, beanClassList);
    }

    public static void build(GenerateConfig config, DbType dbType, boolean sqlToUpperCase, List<Class<?>> beanClassList) {
        if (beanClassList == null || beanClassList.size() == 0) {
            return;
        }
        for (Class<?> beanClass : beanClassList) {
            GenerateHelper.build(config, dbType, sqlToUpperCase, beanClass);
        }
    }

    public static void build(GenerateConfig config, DbType dbType, Class<?> beanClass) {
        GenerateHelper.build(config, dbType, false, beanClass);
    }

    public static void build(GenerateConfig config, DbType dbType, boolean sqlToUpperCase, Class<?> beanClass) {
        String classPath;
        SqlBeanMeta sqlBeanDB = new SqlBeanMeta();
        sqlBeanDB.setDbType(dbType);
        SqlBeanConfig sqlBeanConfig = new SqlBeanConfig();
        sqlBeanConfig.setToUpperCase(Boolean.valueOf(sqlToUpperCase));
        sqlBeanDB.setSqlBeanConfig(sqlBeanConfig);
        File packDir = GenerateHelper.getFilePaths(config);
        Table table = SqlBeanUtil.getTable(beanClass);
        SqlTable sqlTable = SqlBeanUtil.getSqlTable(beanClass);
        TableInfo tableInfo = new TableInfo();
        tableInfo.setName(table.getName());
        tableInfo.setRemarks(sqlTable != null ? sqlTable.remarks() : "");
        List fieldDeclarationList = null;
        if (StringUtil.isEmpty((Object)tableInfo.getRemarks()) && StringUtil.isNotBlank((Object)(classPath = beanClass.getProtectionDomain().getCodeSource().getLocation().getPath()))) {
            classPath = classPath.replaceFirst("^/", "");
            classPath = classPath.replaceAll("%20", " ");
            String sourceRoot = classPath.substring(0, classPath.lastIndexOf("/target/classes/")) + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator;
            String javaFilePath = sourceRoot + beanClass.getPackage().getName().replace(".", File.separator) + File.separator + beanClass.getSimpleName() + ".java";
            try {
                JavaParserUtil.Declaration declaration = JavaParserUtil.getFieldDeclarationList((String)sourceRoot, (String)javaFilePath);
                TypeDeclaration typeDeclaration = declaration.getTypeDeclaration();
                fieldDeclarationList = declaration.getFieldDeclarationList();
                if (typeDeclaration != null && typeDeclaration.getComment().isPresent()) {
                    tableInfo.setRemarks(JavaParserUtil.getCommentContent((String)((Comment)typeDeclaration.getComment().get()).getContent()));
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        List fieldList = SqlBeanUtil.getBeanAllField(beanClass);
        ArrayList<ColumnInfo> columnInfoList = new ArrayList<ColumnInfo>();
        for (Field field : fieldList) {
            if (SqlBeanUtil.isIgnore((Field)field)) continue;
            ColumnInfo columnInfo = SqlBeanUtil.buildColumnInfo((SqlBeanMeta)sqlBeanDB, (Field)field, (SqlTable)sqlTable, (SqlColumn)field.getAnnotation(SqlColumn.class), null);
            if (StringUtil.isEmpty((Object)columnInfo.getRemarks())) {
                columnInfo.setRemarks(JavaParserUtil.getFieldCommentContent((String)field.getName(), fieldDeclarationList));
            }
            columnInfoList.add(columnInfo);
        }
        ArrayList<ClassInfo> classInfoList = new ArrayList<ClassInfo>();
        ClassInfo classInfo = GenerateHelper.getClassInfo(config, tableInfo, columnInfoList);
        Create create = new Create();
        create.setSqlBeanMeta(sqlBeanDB);
        create.setTable(beanClass);
        create.setBeanClass(beanClass);
        classInfo.setSql(SqlHelper.buildCreateSql((Create)create));
        classInfoList.add(classInfo);
        try {
            GenerateHelper.make(config, packDir, classInfoList);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<TableInfo> getTableInfoList(DbManageService<?> dbManageService) {
        List tableInfoList = dbManageService.getTableList(null);
        if (tableInfoList == null || tableInfoList.isEmpty()) {
            return null;
        }
        return tableInfoList;
    }

    public static List<ClassInfo> getClassInfoList(GenerateConfig config, List<TableInfo> tableInfoList, DbManageService<?> dbManageService) {
        ArrayList<ClassInfo> classInfoList = new ArrayList<ClassInfo>();
        for (TableInfo tableInfo : tableInfoList) {
            List columnInfoList = dbManageService.getColumnInfoList(tableInfo.getName());
            classInfoList.add(GenerateHelper.getClassInfo(config, tableInfo, columnInfoList));
        }
        return classInfoList;
    }

    public static ClassInfo getClassInfo(GenerateConfig config, TableInfo tableInfo, List<ColumnInfo> columnInfoList) {
        Date date = new Date();
        ClassInfo classInfo = new ClassInfo();
        classInfo.setConfig(config);
        String newTableName = config.isBePrefix() && StringUtil.isNotEmpty((Object)config.getPrefix()) && tableInfo.getName().indexOf(config.getPrefix()) == 0 ? tableInfo.getName().substring(config.getPrefix().length()) : (config.isBePrefix() ? tableInfo.getName().substring(tableInfo.getName().indexOf("_") + 1) : tableInfo.getName());
        classInfo.setClassName(newTableName.substring(0, 1).toUpperCase() + StringUtil.underlineToHump((String)newTableName.substring(1)));
        classInfo.setTableInfo(tableInfo);
        classInfo.setDate(date);
        if (columnInfoList != null && !columnInfoList.isEmpty()) {
            ArrayList<FieldInfo> fieldInfoList = new ArrayList<FieldInfo>();
            String baseClassPath = "";
            List<Object> baseClassFiledList = null;
            HashMap<String, Boolean> otherTypeMap = new HashMap<String, Boolean>();
            if (config.getBaseClass() != null) {
                baseClassPath = config.getBaseClass().getName();
                List fieldList = SqlBeanUtil.getBeanAllField(config.getBaseClass());
                baseClassFiledList = fieldList.stream().map(item -> item.getName()).collect(Collectors.toList());
            } else if (StringUtil.isNotBlank((Object)config.getBaseClassName())) {
                baseClassPath = config.getBaseClassName().indexOf(".") > -1 ? config.getBaseClassName() : config.getBasePackage() + (StringUtil.isNotBlank((Object)config.getModule()) ? "." + config.getModule() : "") + "." + config.getBaseClassName();
                baseClassFiledList = Arrays.asList(config.getBaseClassFields());
            }
            if (StringUtil.isNotBlank((Object)baseClassPath)) {
                classInfo.setBaseClassName(baseClassPath.substring(baseClassPath.lastIndexOf(".") + 1));
                otherTypeMap.put(baseClassPath, false);
            }
            for (ColumnInfo columnInfo : columnInfoList) {
                String columnName = StringUtil.underlineToHump((String)columnInfo.getName());
                Class<?> clazz = JdbcMapJava.getJavaType(columnInfo.getType());
                FieldInfo filedInfo = new FieldInfo();
                filedInfo.setColumnInfo(GenerateHelper.handleMybatisType(columnInfo));
                filedInfo.setName(columnName);
                filedInfo.setTypeName(clazz.getSimpleName());
                filedInfo.setTypeFullName(clazz.getName());
                if (columnInfo.getPk().booleanValue()) {
                    classInfo.setId(filedInfo);
                    if (filedInfo.getTypeName().equals("Long") || filedInfo.getTypeName().equals("String")) {
                        otherTypeMap.put(IdType.class.getName(), false);
                    }
                }
                filedInfo.setCreateTime(clazz.getSimpleName().equals("Date") && (columnInfo.getName().toLowerCase().indexOf("create") > -1 || columnInfo.getRemarks().equals("\u521b\u5efa\u65f6\u95f4")));
                filedInfo.setUpdateTime(clazz.getSimpleName().equals("Date") && (columnInfo.getName().toLowerCase().indexOf("update") > -1 || columnInfo.getRemarks().equals("\u66f4\u65b0\u65f6\u95f4")));
                if (filedInfo.getTypeFullName().indexOf("java.lang") == -1) {
                    otherTypeMap.put(filedInfo.getTypeFullName(), true);
                }
                if (filedInfo.isCreateTime() || filedInfo.isUpdateTime()) {
                    otherTypeMap.put(SqlDefaultValue.class.getName(), false);
                    otherTypeMap.put(FillWith.class.getName(), false);
                }
                fieldInfoList.add(filedInfo);
            }
            if (baseClassFiledList != null && baseClassFiledList.size() > 0) {
                block1: for (FieldInfo fieldInfo : fieldInfoList) {
                    for (String string : baseClassFiledList) {
                        if (!fieldInfo.getName().equals(string)) continue;
                        fieldInfo.setIgnore(true);
                        continue block1;
                    }
                }
            }
            if (classInfo.getId() == null) {
                classInfo.setId((FieldInfo)fieldInfoList.get(0));
            }
            classInfo.setFieldInfoList(fieldInfoList);
            classInfo.setOtherTypeMap(otherTypeMap);
        }
        return classInfo;
    }

    private static void make(GenerateConfig config, File targetDir, List<ClassInfo> classInfoList) throws IOException {
        FreemarkerUtil freemarkerUtil = GenerateHelper.getFreemarkerUtil(config);
        String packPath = config.getBasePackage().replace(".", File.separator);
        if (StringUtil.isNotBlank((Object)config.getModule())) {
            packPath = packPath + File.separator + config.getModule();
        }
        for (ClassInfo classInfo : classInfoList) {
            for (Template template : Template.values()) {
                if (template.getType() != TemplateType.JAVA || !config.isMultiProject() && StringUtil.isNotBlank((Object)template.getNamePrefix()) || config.isUseSqlBean() && Template.MAPPER.getName().equals(template.getName()) || config.isMultiProject() && Template.CONTROLLER.getName().equals(template.getName()) || Template.BASE_ENTITY.getName().equals(template.getName()) || Template.RESULT.getName().equals(template.getName())) continue;
                String name = template.getNamePrefix() + classInfo.getClassName();
                if (config.isMultiProject()) {
                    freemarkerUtil.fprint((Object)classInfo, template.getName(), targetDir.getAbsolutePath() + File.separator + template.getProject() + File.separator + packPath + template.getRelativePath() + name + template.getNameSuffix() + template.getFileFormat());
                    continue;
                }
                freemarkerUtil.fprint((Object)classInfo, template.getName(), targetDir.getAbsolutePath() + File.separator + packPath + template.getRelativePath() + name + template.getNameSuffix() + template.getFileFormat());
            }
            freemarkerUtil.fprint((Object)classInfo, config.getSqlDocType().getTemplate().getName(), targetDir.getAbsolutePath() + config.getSqlDocType().getTemplate().getRelativePath() + classInfo.getTableInfo().getName() + config.getSqlDocType().getTemplate().getFileFormat());
            if (!StringUtil.isNotBlank((Object)classInfo.getSql())) continue;
            freemarkerUtil.fprint((Object)classInfo, Template.SQL.getName(), targetDir.getAbsolutePath() + Template.SQL.getRelativePath() + classInfo.getTableInfo().getName() + Template.SQL.getFileFormat());
        }
        String baseEntityName = StringUtil.firstToUpperCase((String)StringUtil.underlineToHump((String)Template.BASE_ENTITY.name().toLowerCase()));
        String resultName = StringUtil.firstToUpperCase((String)StringUtil.underlineToHump((String)Template.RESULT.name().toLowerCase()));
        if (config.isMultiProject()) {
            freemarkerUtil.fprint((Object)classInfoList.get(0), Template.BASE_ENTITY.getName(), targetDir.getAbsolutePath() + File.separator + Template.BASE_ENTITY.getProject() + File.separator + packPath + Template.BASE_ENTITY.getRelativePath() + baseEntityName + Template.BASE_ENTITY.getFileFormat());
            freemarkerUtil.fprint((Object)classInfoList.get(0), Template.RESULT.getName(), targetDir.getAbsolutePath() + File.separator + Template.BASE_ENTITY.getProject() + File.separator + packPath + Template.BASE_ENTITY.getRelativePath() + resultName + Template.BASE_ENTITY.getFileFormat());
        } else {
            freemarkerUtil.fprint((Object)classInfoList.get(0), Template.BASE_ENTITY.getName(), targetDir.getAbsolutePath() + File.separator + packPath + Template.RESULT.getRelativePath() + baseEntityName + Template.RESULT.getFileFormat());
            freemarkerUtil.fprint((Object)classInfoList.get(0), Template.RESULT.getName(), targetDir.getAbsolutePath() + File.separator + packPath + Template.RESULT.getRelativePath() + resultName + Template.RESULT.getFileFormat());
        }
    }

    public static File getFilePaths(GenerateConfig config) {
        String packPath = config.getBasePackage().replace(".", File.separator);
        if (StringUtil.isNotBlank((Object)config.getModule())) {
            packPath = packPath + File.separator + config.getModule();
        }
        String dateString = DateUtil.dateToString((Date)new Date(config.getTimestamp()), (String)"yyyyMMddHHmmss");
        File targetDir = StringUtil.isNotEmpty((Object)config.getTargetPath()) ? new File(config.getTargetPath() + File.separator + dateString) : new File(System.getProperty("user.dir") + File.separator + "generateTarget" + File.separator + dateString);
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        for (Template template : Template.values()) {
            File dir;
            if (template.getType() == TemplateType.JAVA) {
                if (config.isUseSqlBean() && "mapper.ftl".equals(template.getName()) || config.isMultiProject() && "controller.ftl".equals(template.getName())) continue;
                dir = config.isMultiProject() ? new File(targetDir.getAbsolutePath() + File.separator + template.getProject() + File.separator + packPath + template.getRelativePath()) : new File(targetDir.getAbsolutePath() + File.separator + packPath + template.getRelativePath());
            } else {
                dir = new File(targetDir.getAbsolutePath() + template.getRelativePath());
            }
            if (dir.exists()) continue;
            dir.mkdirs();
        }
        return targetDir;
    }

    public static FreemarkerUtil getFreemarkerUtil(GenerateConfig config) throws IOException {
        FreemarkerUtil freemarkerUtil = null;
        if (StringUtil.isNotEmpty((Object)config.getTemplatePath())) {
            File file = new File(config.getTemplatePath());
            freemarkerUtil = FreemarkerUtil.getInstance(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS.toString(), file);
        } else {
            freemarkerUtil = FreemarkerUtil.getInstance(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS.toString(), "/template/");
        }
        return freemarkerUtil;
    }

    public static ColumnInfo handleMybatisType(ColumnInfo columnInfo) {
        if ("DATETIME".equalsIgnoreCase(columnInfo.getType()) || "DATETIME2".equalsIgnoreCase(columnInfo.getType())) {
            columnInfo.setType("TIMESTAMP");
        }
        if ("INT".equalsIgnoreCase(columnInfo.getType())) {
            columnInfo.setType("INTEGER");
        }
        return columnInfo;
    }
}

