/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.solon.config;

import cn.vonce.sql.config.SqlBeanConfig;
import cn.vonce.sql.config.SqlBeanMeta;
import cn.vonce.sql.java.annotation.DbSwitch;
import cn.vonce.sql.java.dao.MybatisSqlBeanDao;
import cn.vonce.sql.java.mapper.MybatisSqlBeanMapperInterceptor;
import cn.vonce.sql.solon.annotation.EnableAutoConfigMultiDataSource;
import cn.vonce.sql.solon.config.AutoConfigMultiDataSource;
import cn.vonce.sql.solon.config.SolonAutoCreateTableListener;
import cn.vonce.sql.solon.datasource.DataSourceInterceptor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ibatis.solon.MybatisAdapter;
import org.apache.ibatis.solon.integration.MybatisAdapterManager;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.aspect.Interceptor;

public class AutoConfigSolon
implements Plugin {
    public void start(AppContext context) {
        context.beanBuilderAdd(EnableAutoConfigMultiDataSource.class, (BeanBuilder)new AutoConfigMultiDataSource());
        context.subWrapsOfType(DataSource.class, bw -> AutoConfigSolon.init(bw));
    }

    protected static void init(BeanWrap bw) {
        MybatisAdapter mybatisAdapter = MybatisAdapterManager.get((BeanWrap)bw);
        if (mybatisAdapter != null) {
            mybatisAdapter.getConfiguration().addMapper(MybatisSqlBeanDao.class);
            mybatisAdapter.getConfiguration().addInterceptor((org.apache.ibatis.plugin.Interceptor)new MybatisSqlBeanMapperInterceptor());
        }
        bw.context().beanMake(SolonAutoCreateTableListener.class);
        bw.context().beanInterceptorAdd(DbSwitch.class, (Interceptor)new DataSourceInterceptor());
        try {
            Connection connection = mybatisAdapter.getConfiguration().getEnvironment().getDataSource().getConnection();
            SqlBeanConfig sqlBeanConfig = (SqlBeanConfig)bw.context().getBean(SqlBeanConfig.class);
            SqlBeanMeta sqlBeanMeta = SqlBeanMeta.build((SqlBeanConfig)sqlBeanConfig, (DatabaseMetaData)connection.getMetaData());
            connection.close();
            BeanWrap beanWrap = bw.context().wrap("sqlBeanMeta", (Object)sqlBeanMeta);
            bw.context().putWrap(SqlBeanMeta.class, beanWrap);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

