/*
 * Decompiled with CFR 0.152.
 */
package cn.virens.common.apifox;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.virens.common.apifox.build.ApiFoxCollection;
import cn.virens.common.exception.APIException;
import cn.virens.common.utils.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class ApifoxTree
extends ConcurrentHashMap<String, ApiFoxCollection> {
    private static final String ROOT = "ROOT";

    public boolean addApi(String groupKey, ApiFoxCollection api) {
        return this.getGroup(ApifoxTree.group0(groupKey)).getItems().add(api);
    }

    private static String group0(String groupKey) throws APIException {
        String str = FileUtil.normalize((String)ApifoxTree.group1(groupKey));
        str = StrUtil.removeSuffix((CharSequence)str, (CharSequence)"/");
        str = StrUtil.removePrefix((CharSequence)str, (CharSequence)"/");
        return str;
    }

    private static String group1(String groupKey) throws APIException {
        if (groupKey != null && !groupKey.isEmpty()) {
            return "ROOT/" + groupKey;
        }
        return ROOT;
    }

    private ApiFoxCollection getGroup(String groupKey) throws APIException {
        ApiFoxCollection collection = (ApiFoxCollection)this.get(Assert.isEmpty((Object)groupKey));
        if (collection == null || collection.getItems() == null) {
            ApiFoxCollection temp = new ApiFoxCollection();
            temp.setItems(new ArrayList<ApiFoxCollection>());
            temp.setName(ApifoxTree.toName(groupKey));
            return this.save(groupKey, temp);
        }
        return collection;
    }

    private ApiFoxCollection save(String groupKey, ApiFoxCollection collection) {
        if (groupKey != null && !StrUtil.equals((CharSequence)groupKey, (CharSequence)ROOT)) {
            this.getParent(groupKey).getItems().add(collection);
        }
        this.put(groupKey, collection);
        return collection;
    }

    private ApiFoxCollection getParent(String groupKey) throws APIException {
        return this.getGroup(StrUtil.subBefore((CharSequence)groupKey, (char)'/', (boolean)true));
    }

    private static String toName(String groupKey) throws APIException {
        return StrUtil.subAfter((CharSequence)groupKey, (char)'/', (boolean)true);
    }

    public List<ApiFoxCollection> toList() throws APIException {
        return Optional.ofNullable((ApiFoxCollection)this.get(ROOT)).map(root -> root != null ? root.getItems() : null).orElseGet(Collections::emptyList);
    }
}

