/*
 * Decompiled with CFR 0.152.
 */
package cn.virens.common.apifox;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.virens.common.apifox.ApifoxDoc;
import cn.virens.common.apifox.ApifoxTree;
import cn.virens.common.apifox.ApifoxType;
import cn.virens.common.apifox.build.ApiFoxCollection;
import cn.virens.common.apifox.build.ApiFoxCollectionApi;
import cn.virens.common.apifox.build.ApiFoxCollectionParam;
import cn.virens.common.apifox.build.ApiFoxCollectionParamItem;
import cn.virens.common.apifox.util.ApifoxUtil;
import cn.virens.common.exception.APIException;
import cn.virens.common.web.BaseController;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.web.bind.annotation.RequestMapping;

public class ApifoxScanner {
    public String apifoxHeader;
    public String apifoxQuery;

    public List<ApiFoxCollection> scanPackage(String pkg, ApifoxTree tree) throws APIException {
        for (Class clazz : ClassUtil.scanPackageBySuper((String)pkg, BaseController.class)) {
            RequestMapping mapping0 = clazz.getAnnotation(RequestMapping.class);
            ApifoxDoc postman0 = clazz.getAnnotation(ApifoxDoc.class);
            Arrays.stream(ReflectUtil.getMethods((Class)clazz)).forEach(method -> {
                RequestMapping mapping1 = method.getAnnotation(RequestMapping.class);
                ApifoxDoc postman1 = method.getAnnotation(ApifoxDoc.class);
                if (postman1 == null || mapping1 == null) {
                    return;
                }
                String group = ApifoxScanner.normalize(ApifoxScanner.group(postman0), ApifoxScanner.group(postman1));
                this.parseDoc(mapping0, mapping1, postman1).forEach(c -> tree.addApi(group, ApifoxUtil.fill(method, c)));
            });
        }
        return tree.toList();
    }

    public void setApifoxHeader(String apifoxHeader) {
        this.apifoxHeader = apifoxHeader;
    }

    public void setApifoxQuery(String apifoxQuery) {
        this.apifoxQuery = apifoxQuery;
    }

    public String getApifoxHeader() {
        return this.apifoxHeader;
    }

    public String getApifoxQuery() {
        return this.apifoxQuery;
    }

    private Stream<ApiFoxCollection> parseDoc(RequestMapping parent, RequestMapping mapping, ApifoxDoc doc) {
        return Optional.ofNullable(ApifoxScanner.path(parent)).map(paths -> Arrays.stream(paths).flatMap(path0 -> Optional.ofNullable(ApifoxScanner.path(mapping)).map(p1s -> Arrays.stream(p1s).map(path1 -> {
            ApiFoxCollectionParam param = new ApiFoxCollectionParam();
            param.setHeader(this.pasreHeader(doc.header()));
            param.setQuery(this.pasreQuery(doc.query()));
            ApiFoxCollectionApi api = new ApiFoxCollectionApi();
            api.setDescription(doc.description());
            api.setPath(ApifoxScanner.normalize(path0, path1));
            api.setMethod(ApifoxScanner.method(mapping));
            api.setStatus("developing");
            api.setParameters(param);
            ApiFoxCollection collection = new ApiFoxCollection();
            collection.setDescription(doc.description());
            collection.setName(doc.name());
            collection.setApi(api);
            return collection;
        })).get())).get();
    }

    private List<ApiFoxCollectionParamItem> pasreParamList(String[] define) throws APIException {
        return Arrays.stream(define).map(p -> StrUtil.split((CharSequence)p, (char)',')).map(list -> {
            if (list != null && list.size() == 5) {
                return this.pasreOne((List<String>)list);
            }
            if (list != null && list.size() == 3) {
                return this.pasreTwo((List<String>)list);
            }
            return null;
        }).filter(a -> a != null).collect(Collectors.toList());
    }

    private List<ApiFoxCollectionParamItem> pasreHeader(String[] header) throws APIException {
        int index;
        List<String> defHeader = ApifoxScanner.toLine(StrUtil.nullToEmpty((CharSequence)this.apifoxHeader));
        String[] temp = new String[header.length + defHeader.size()];
        for (index = 0; index < defHeader.size(); ++index) {
            temp[index + header.length] = defHeader.get(index);
        }
        for (index = 0; index < header.length; ++index) {
            temp[index] = header[index];
        }
        return this.pasreParamList(temp);
    }

    private List<ApiFoxCollectionParamItem> pasreQuery(String[] query) throws APIException {
        int index;
        List<String> defQuery = ApifoxScanner.toLine(StrUtil.nullToEmpty((CharSequence)this.apifoxQuery));
        String[] temp = new String[query.length + defQuery.size()];
        for (index = 0; index < defQuery.size(); ++index) {
            temp[index + query.length] = defQuery.get(index);
        }
        for (index = 0; index < query.length; ++index) {
            temp[index] = query[index];
        }
        return this.pasreParamList(temp);
    }

    private ApiFoxCollectionParamItem pasreTwo(List<String> value) throws APIException {
        ApiFoxCollectionParamItem item = new ApiFoxCollectionParamItem();
        item.setDescription(Convert.toStr((Object)value.get(2)));
        item.setExample(Convert.toStr((Object)value.get(1)));
        item.setName(Convert.toStr((Object)value.get(0)));
        item.setRequired(Boolean.TRUE);
        item.setType("string");
        return item;
    }

    private ApiFoxCollectionParamItem pasreOne(List<String> value) throws APIException {
        ApiFoxCollectionParamItem item = new ApiFoxCollectionParamItem();
        item.setType(ApifoxType.formatType(value.get(1)));
        item.setDescription(Convert.toStr((Object)value.get(4)));
        item.setRequired(Convert.toBool((Object)value.get(2)));
        item.setExample(Convert.toStr((Object)value.get(3)));
        item.setName(Convert.toStr((Object)value.get(0)));
        return item;
    }

    private static String normalize(String ... path) throws APIException {
        return FileUtil.normalize((String)ArrayUtil.join((Object[])path, (CharSequence)"/"));
    }

    protected static List<String> toLine(String string) {
        return string.lines().filter(line -> StrUtil.isNotEmpty((CharSequence)line)).collect(Collectors.toList());
    }

    protected static String[] path(RequestMapping mp) {
        if (mp == null) {
            return new String[]{""};
        }
        if (mp.path().length == 0) {
            return mp.value();
        }
        return mp.path();
    }

    protected static String method(RequestMapping mp) {
        if (mp != null && mp.method().length > 0) {
            return mp.method()[0].name();
        }
        return "GET";
    }

    protected static String group(ApifoxDoc doc) {
        if (doc != null && doc.group() != null) {
            return doc.group();
        }
        return "";
    }
}

