/*
 * Decompiled with CFR 0.152.
 */
package cn.virens.common.apifox;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.StrUtil;
import cn.virens.common.apifox.ApifoxScanner;
import cn.virens.common.apifox.ApifoxTree;
import cn.virens.common.apifox.build.ApiFoxCollection;
import cn.virens.common.exception.APIException;
import com.alibaba.fastjson2.JSON;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;

public class ApifoxScan {
    public static final String APIFOX_DEF_HEADER = "classpath:META-INF/apifox_def_header.tpl";
    public static final String APIFOX_DEF_QUERY = "classpath:META-INF/apifox_def_query.tpl";
    public static final String APIFOX_PROC_POST = "classpath:META-INF/apifox_proc_post.tpl";
    public static final String APIFOX_PROC_PRE = "classpath:META-INF/apifox_proc_pre.tpl";
    public static final String APIFOX = "classpath:META-INF/apifox.tpl";

    public static String readFile(String url) throws APIException {
        String string;
        block8: {
            InputStream in = ResourceUtil.getStream((String)url);
            try {
                string = IoUtil.readUtf8((InputStream)in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw APIException.warp((Throwable)e);
                }
            }
            in.close();
        }
        return string;
    }

    public static String scanPackageToDocs(String pkg) throws APIException {
        return ApifoxScan.scanPackageTpl(pkg, ApifoxScan.readFile(APIFOX));
    }

    public static List<ApiFoxCollection> scanPackage(String pkg) throws APIException {
        return ApifoxScan.scanPackage(pkg, new ApifoxTree());
    }

    public static List<ApiFoxCollection> scanPackage(String pkg, ApifoxTree tree) throws APIException {
        ApifoxScanner apifoxScanner = new ApifoxScanner();
        apifoxScanner.setApifoxHeader(ApifoxScan.readFile(APIFOX_DEF_HEADER));
        apifoxScanner.setApifoxQuery(ApifoxScan.readFile(APIFOX_DEF_QUERY));
        return apifoxScanner.scanPackage(pkg, tree);
    }

    private static String scanPackageTpl(String packageName, String baseFile) throws APIException {
        String procPostFile = StringEscapeUtils.escapeJava((String)ApifoxScan.readFile(APIFOX_PROC_POST));
        String procPreFile = StringEscapeUtils.escapeJava((String)ApifoxScan.readFile(APIFOX_PROC_PRE));
        baseFile = StrUtil.replace((CharSequence)baseFile, (CharSequence)"_API_DOCS_", (CharSequence)ApifoxScan.scanPackageStr(packageName));
        baseFile = StrUtil.replace((CharSequence)baseFile, (CharSequence)"_APIFOX_PROC_POST_", (CharSequence)procPostFile);
        baseFile = StrUtil.replace((CharSequence)baseFile, (CharSequence)"_APIFOX_PROC_PRE_", (CharSequence)procPreFile);
        return baseFile;
    }

    private static String scanPackageStr(String pkg) throws APIException {
        return JSON.toJSONString(ApifoxScan.scanPackage(pkg));
    }
}

