/*
 * Decompiled with CFR 0.152.
 */
package cn.virens.common.web;

import cn.hutool.core.util.StrUtil;
import cn.virens.common.entity.param.PageParam;
import cn.virens.common.exception.APIException;
import cn.virens.common.utils.network.RequestUtil;
import cn.virens.common.utils.network.SessionUtil;
import java.util.function.Supplier;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ApplicationObjectSupport;

public class BaseController
extends ApplicationObjectSupport {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected String baseTemplateUrl = "";

    protected BaseController(String url) throws APIException {
        this.baseTemplateUrl = url != null && !StrUtil.endWith((CharSequence)url, (char)'/') ? url + "/" : url;
    }

    protected final String returnUrl(String url) throws APIException {
        return this.baseTemplateUrl + StrUtil.emptyToDefault((CharSequence)url, (String)"index");
    }

    protected final String redirectUrl(String url) throws APIException {
        if (url != null && !StrUtil.endWith((CharSequence)url, (CharSequence)".jspx")) {
            return "redirect:" + url + ".jspx";
        }
        return "redirect:" + url;
    }

    protected final String forwardUrl(String url) {
        return "forward:" + url;
    }

    protected final Object getAttribute(HttpServletRequest request, String name) {
        return SessionUtil.useSession((ServletRequest)request, (boolean)false, session -> session != null ? session.getAttribute(name) : null);
    }

    protected final <T> T getAttribute(HttpServletRequest request, String name, Class<T> clazz) {
        return (T)SessionUtil.useSession((ServletRequest)request, (boolean)false, session -> this.getAttribute((HttpSession)session, name, clazz));
    }

    protected final <T> T getAttribute(HttpSession session, String name, Class<T> clazz) {
        if (session != null && name != null && clazz != null) {
            Object obj = session.getAttribute(name);
            if (clazz == String.class && obj != null) {
                return (T)String.valueOf(obj);
            }
            if (BaseController.isAssignableFrom(obj, clazz)) {
                return (T)obj;
            }
            return null;
        }
        return null;
    }

    private static boolean isAssignableFrom(Object obj, Class<?> clazz) throws APIException {
        return clazz != null && obj != null && clazz.isAssignableFrom(obj.getClass());
    }

    protected final <T> T getAttribute(HttpServletRequest request, String name, Class<T> clazz, Supplier<T> supplier) {
        return (T)SessionUtil.useSession((ServletRequest)request, (boolean)false, session -> {
            if (session == null || clazz == null) {
                return null;
            }
            Object obj = this.getAttribute((HttpSession)session, name, clazz);
            if (obj == null && supplier != null && (obj = supplier.get()) != null) {
                session.setAttribute(name, obj);
            }
            return obj;
        });
    }

    protected final <T> T setAttribute(HttpServletRequest request, String name, T value) {
        return (T)SessionUtil.useSession((ServletRequest)request, (boolean)false, session -> {
            if (session != null && name != null && value != null) {
                session.setAttribute(name, value);
            } else if (session != null && name != null) {
                session.removeAttribute(name);
            } else {
                return null;
            }
            return value;
        });
    }

    protected PageParam getParam(HttpServletRequest request) throws APIException {
        Integer pageSize = RequestUtil.getValueInt((HttpServletRequest)request, (String)"limit", (Integer)10);
        Integer pageNum = RequestUtil.getValueInt((HttpServletRequest)request, (String)"page", (Integer)1);
        PageParam pageParam = new PageParam();
        pageParam.setPageSize(pageSize);
        pageParam.setPageNum(pageNum);
        return pageParam;
    }
}

