/*
 * Decompiled with CFR 0.152.
 */
package cn.virens.common.apifox.util;

import cn.hutool.core.util.StrUtil;
import cn.virens.common.apifox.ApifoxType;
import cn.virens.common.apifox.build.ApiFoxCollectionParamItem;
import cn.virens.common.exception.APIException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.RequestParam;

public class ApifoxUtilParam {
    public static List<ApiFoxCollectionParamItem> getParamItem(Method method) throws APIException {
        return Arrays.stream(method.getParameters()).map(parameter -> {
            RequestParam param = parameter.getAnnotation(RequestParam.class);
            if (param == null || StrUtil.isEmpty((CharSequence)ApifoxUtilParam.name(param))) {
                return null;
            }
            ApiFoxCollectionParamItem item = new ApiFoxCollectionParamItem();
            item.setType(ApifoxType.formatType(parameter.getType()));
            item.setRequired(param.required());
            item.setExample(ApifoxUtilParam.value(param));
            item.setName(ApifoxUtilParam.name(param));
            return item;
        }).filter(a -> a != null).collect(Collectors.toList());
    }

    private static String value(RequestParam rp) throws APIException {
        if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(rp.defaultValue())) {
            return rp.defaultValue();
        }
        return "";
    }

    private static String name(RequestParam rp) throws APIException {
        if (StrUtil.isNotEmpty((CharSequence)rp.value())) {
            return rp.value();
        }
        return rp.name();
    }
}

