/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.util;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertiesUtil {
    private static final String[] FILES = new String[]{"/jdbc.properties", "/redis.properties", "/common.properties"};
    private static final Map<String, Object> PROPERTIES = new HashMap<String, Object>();

    public static Object get(String key) {
        return PROPERTIES.get(key);
    }

    public static String getString(String key) {
        Object o = PropertiesUtil.get(key);
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    public static String getString(String key, String defaultVal) {
        Object o = PropertiesUtil.get(key);
        if (o == null) {
            return defaultVal;
        }
        return o.toString();
    }

    public static int getInt(String key) {
        String s = PropertiesUtil.getString(key);
        if (s == null || "".equals(s)) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public static long getLong(String key) {
        String s = PropertiesUtil.getString(key);
        if (s == null || "".equals(s)) {
            return 0L;
        }
        return Long.parseLong(s);
    }

    public static boolean getBoolean(String key) {
        String s = PropertiesUtil.getString(key);
        if (s == null || "".equals(s)) {
            return false;
        }
        return Boolean.parseBoolean(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream is = null;
        try {
            for (int i = 0; i < FILES.length; ++i) {
                URL url = PropertiesUtil.class.getResource(FILES[i]);
                if (url == null) continue;
                is = url.openStream();
                Properties pro = new Properties();
                pro.load(is);
                Enumeration<?> e = pro.propertyNames();
                while (e.hasMoreElements()) {
                    String key = e.nextElement().toString();
                    PROPERTIES.put(key, pro.get(key));
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

