/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.util;

import cn.virde.nymph.Nym;
import cn.virde.nymph.text.TextOut;
import cn.virde.nymph.util.LogPrint;
import java.util.Date;

public class Log {
    public static final String MODE_FILEOUT = "fileOut";
    public static final String MODE_CONSOLE = "console";
    public static final String MODE_CONSOLE_FILE = "console_and_file";
    private static volatile String mode = "console";
    private static volatile String logFile;
    private static volatile LogPrint logPrint;
    public static final int LEVEL_INFO = 1;
    public static final int LEVEL_ALERT = 2;
    private static volatile int level;
    private static boolean isDev;

    public static synchronized void info(String msg) {
        if (level < 2) {
            return;
        }
        String traceInfo = Log.getTraceInfo(new Throwable().getStackTrace());
        String time = Nym.time.toString(new Date(), "hh:mm:ss");
        Log.syso(time + " " + msg);
        Log.syso(traceInfo);
    }

    public static synchronized void info(String msg, Exception e) {
        if (level < 2) {
            return;
        }
        String traceInfo = Log.getTraceInfo(new Throwable().getStackTrace());
        String time = Nym.time.toString(new Date(), "hh:mm:ss");
        Log.syso(time + " " + msg + "\u3002 \u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        Log.syso(traceInfo);
    }

    public static synchronized void info(String msg, String alert) {
        if (level < 2) {
            return;
        }
        String traceInfo = Log.getTraceInfo(new Throwable().getStackTrace());
        String time = Nym.time.toString(new Date(), "hh:mm:ss");
        Log.syso(time + " " + msg);
        Log.syso("\u5f02\u5e38\u63d0\u793a\u4fe1\u606f\uff1a" + alert);
        Log.syso(traceInfo);
    }

    public static synchronized void alert(String msg) {
        String time = Nym.time.toString(new Date(), "hh:mm:ss");
        Log.syso(time + " " + msg);
    }

    public static synchronized void debug(String msg) {
        if (isDev) {
            Log.alert(msg);
        }
    }

    public static synchronized void error(String msg, Exception e) {
        String traceInfo = Log.getTraceInfo(new Throwable().getStackTrace());
        String time = Nym.time.toString(new Date(), "hh:mm:ss");
        Log.syso("==================\u9519\u8bef\u63d0\u793a=====================");
        Log.syso(time + " " + msg + "\u3002 \u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        Log.syso(traceInfo);
        Log.syso("============================================");
    }

    public static synchronized void error(String msg, String alert) {
        String traceInfo = Log.getTraceInfo(new Throwable().getStackTrace());
        String time = Nym.time.toString(new Date(), "hh:mm:ss");
        Log.syso("========\u9519\u8bef\u63d0\u793a======\u9519\u8bef\u63d0\u793a=======\u9519\u8bef\u63d0\u793a=======");
        Log.syso(time + " " + msg);
        Log.syso("\u5f02\u5e38\u63d0\u793a\u4fe1\u606f\uff1a" + alert);
        Log.syso(traceInfo);
        Log.syso("============================================");
    }

    public static synchronized void setFileOutMode(String file) {
        logFile = file;
        mode = MODE_FILEOUT;
    }

    public static synchronized void setDoubleMode(String file) {
        logFile = file;
        mode = MODE_CONSOLE_FILE;
    }

    private static synchronized String getTraceInfo(StackTraceElement[] stacks) {
        StringBuffer sb = new StringBuffer();
        sb.append("class: ").append(stacks[1].getClassName()).append("; method: ").append(stacks[1].getMethodName()).append("; number: ").append(stacks[1].getLineNumber());
        return sb.toString();
    }

    private static synchronized void syso(String text) {
        switch (mode) {
            case "console": {
                Log.println(text);
                break;
            }
            case "fileOut": {
                new TextOut(logFile).putln(text);
                break;
            }
            case "console_and_file": {
                Log.println(text);
                new TextOut(logFile).putln(text);
                break;
            }
        }
    }

    public static void setLogPrint(LogPrint print) {
        logPrint = print;
    }

    public static void println(String text) {
        if (logPrint == null) {
            System.out.println(text);
        } else {
            logPrint.println(text);
        }
    }

    public static int getLevel() {
        return level;
    }

    public static void setLevel(int level) {
        Log.level = level;
    }

    public static void isDev(boolean isDev) {
        Log.isDev = isDev;
    }

    static {
        level = 1;
        isDev = true;
    }
}

