/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.text;

import cn.virde.nymph.util.Log;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public class NymProperties {
    private String file;

    public NymProperties(String filePath) {
        this.file = filePath;
    }

    public String getValue(String key) {
        return NymProperties.getValueByKey(this.file, key);
    }

    public void setValue(String key, String value) {
        try {
            NymProperties.writeProperties(this.file, key, value);
        }
        catch (IOException e) {
            Log.info("\u5199\u914d\u7f6e\u6587\u4ef6\u65f6\u51fa\u73b0IO\u5f02\u5e38", e);
        }
    }

    private static String getValueByKey(String filePath, String key) {
        Properties pps = new Properties();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(filePath));
            pps.load(in);
            String value = pps.getProperty(key);
            return value;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void writeProperties(String filePath, String pKey, String pValue) throws IOException {
        Properties pps = new Properties();
        FileInputStream in = new FileInputStream(filePath);
        pps.load(in);
        FileOutputStream out = new FileOutputStream(filePath);
        pps.setProperty(pKey, pValue);
        pps.store(out, "Update " + pKey + " name");
    }

    private static void getAllProperties(String filePath) throws IOException {
        Properties pps = new Properties();
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(filePath));
        pps.load(in);
        Enumeration<?> en = pps.propertyNames();
        while (en.hasMoreElements()) {
            String strKey = (String)en.nextElement();
            String strValue = pps.getProperty(strKey);
            System.out.println(strKey + "=" + strValue);
        }
    }
}

