/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.system;

import cn.virde.nymph.util.Log;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;

public class SystemInfo {
    private InetAddress inet = null;

    public SystemInfo() {
        try {
            this.inet = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            Log.info("InetAddress\u521d\u59cb\u5316\u5931\u8d25", e);
        }
    }

    public String getMac() {
        if (this.isInetNull()) {
            return "";
        }
        byte[] mac = this.getMacByte();
        if (mac == null) {
            return "";
        }
        return this.macByteToString(mac);
    }

    private byte[] getMacByte() {
        try {
            return NetworkInterface.getByInetAddress(this.inet).getHardwareAddress();
        }
        catch (SocketException e) {
            Log.info("\u83b7\u53d6mac byte\u6570\u7ec4\u65f6\u53d1\u751f\u5f02\u5e38,\u64cd\u4f5c\u5df2\u7ecf\u7ec8\u6b62\uff0c\u5c06\u8fd4\u56de\u7a7a\u5b57\u7b26", e);
            return null;
        }
    }

    private String macByteToString(byte[] mac) {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < mac.length; ++i) {
            int temp;
            String str;
            if (i != 0) {
                sb.append("-");
            }
            if ((str = Integer.toHexString(temp = mac[i] & 0xFF)).length() == 1) {
                sb.append("0" + str);
                continue;
            }
            sb.append(str);
        }
        return sb.toString().toUpperCase();
    }

    public String getHostName() {
        if (this.isInetNull()) {
            return "";
        }
        return this.inet.getHostName();
    }

    public String getLANIP() {
        if (this.isInetNull()) {
            return "";
        }
        return this.inet.getHostAddress();
    }

    private boolean isInetNull() {
        if (this.inet == null) {
            Log.info("InetAddress \u4e3a\u7a7a\uff0c\u4e0d\u80fd\u6210\u529f\u83b7\u53d6\u4fe1\u606f,\u5c06\u8fd4\u56de\u7a7a\u5b57\u7b26");
        }
        return this.inet == null;
    }
}

