/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.office;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Excel {
    private int currRowIndex = 0;
    private XSSFWorkbook book;
    private XSSFSheet sheet;
    private int sheetIndex;
    private String filePath;

    public Excel(String filePath, int sheetIndex) throws IOException {
        this.filePath = filePath;
        this.sheetIndex = sheetIndex;
        this.init();
    }

    public Excel(String filePath) throws IOException {
        this.filePath = filePath;
        this.sheetIndex = 1;
        this.init();
    }

    public void init() throws IOException {
        this.createFileIfNotExist();
        this.initSheet();
    }

    public void initBook() throws IOException {
        FileInputStream is = new FileInputStream(this.filePath);
        this.book = new XSSFWorkbook((InputStream)is);
    }

    public void initSheet() {
        this.sheet = this.getSheet(this.sheetIndex);
    }

    private XSSFSheet getSheet(String sheetName) {
        XSSFSheet sheet = this.book.getSheet(sheetName);
        if (sheet == null) {
            sheet = this.book.createSheet(sheetName);
        }
        return sheet;
    }

    private XSSFSheet getSheet(int sheetIndex) {
        String sheetName = "Sheet" + sheetIndex;
        return this.getSheet(sheetName);
    }

    private void createFileIfNotExist() throws IOException {
        try {
            this.initBook();
            return;
        }
        catch (IOException e) {
            this.book = new XSSFWorkbook();
            this.save();
            this.initBook();
            return;
        }
    }

    public void appendRow(String ... strings) {
        XSSFRow row = this.sheet.createRow(this.currRowIndex++);
        int cellIndex = 0;
        for (String str : strings) {
            row.createCell(cellIndex++).setCellValue(str);
        }
    }

    public void setHeader(String ... strings) {
    }

    public void nextSheet() {
        ++this.sheetIndex;
        this.sheet = this.getSheet(this.sheetIndex);
    }

    public void save() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.filePath);
        this.book.write((OutputStream)fos);
        System.out.println(new Date() + ": \u5199\u5165\u6210\u529f");
        fos.close();
    }

    public static void main(String[] args) throws IOException {
        Excel e = new Excel("D://test33.xlsx", 12);
        e.sheet.createRow(0).createCell(0).setCellValue("asdfasd");
        e.save();
    }
}

