/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.net.weather;

import cn.virde.nymph.Nym;
import cn.virde.nymph.config.Config;
import cn.virde.nymph.entity.base.LocationEntity;
import cn.virde.nymph.entity.weather.ForecastWeatherEntity;
import cn.virde.nymph.entity.weather.RealtimeWeatherEntity;
import com.alibaba.fastjson.JSON;
import java.io.IOException;

public class WeatherDeal {
    protected final RealtimeWeatherEntity getRealtimeWeather(LocationEntity location) throws IOException {
        String realtimeWeather = Nym.http.get(this.createRequestUrl(location, "realtime.json"));
        return (RealtimeWeatherEntity)JSON.parseObject((String)realtimeWeather, RealtimeWeatherEntity.class);
    }

    protected final ForecastWeatherEntity getForecastWeather(LocationEntity location) throws IOException {
        String forecastWeather = Nym.http.get(this.createRequestUrl(location, "forecast.json"));
        return (ForecastWeatherEntity)JSON.parseObject((String)forecastWeather, ForecastWeatherEntity.class);
    }

    private String createRequestUrl(LocationEntity location, String requestType) {
        return this.createRequestUrl(location.toStringLngLat(), requestType);
    }

    private String createRequestUrl(String location, String requestType) {
        return this.createRequestUrl(Config.weather.url, Config.weather.key, location, requestType);
    }

    private String createRequestUrl(String url, String key, String location, String requestType) {
        StringBuffer sb = new StringBuffer();
        sb.append(url);
        sb.append(key);
        sb.append("/" + location);
        sb.append("/" + requestType);
        sb.append("?unit=metric:v2");
        return sb.toString();
    }
}

