/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.net.weather;

import cn.virde.nymph.Nym;
import cn.virde.nymph.entity.base.LocationEntity;
import cn.virde.nymph.entity.weather.ForecastWeatherEntity;
import cn.virde.nymph.entity.weather.RealtimeWeatherEntity;
import cn.virde.nymph.exception.LocationException;
import cn.virde.nymph.net.weather.WeatherDeal;
import java.io.IOException;

public class Weather
extends WeatherDeal {
    private LocationEntity location;
    private String address;

    public Weather(LocationEntity location) throws LocationException, IOException {
        this.location = location;
        this.address = Nym.geocoding.getConverseGeocodingEntity(location).getResult().getAddressComponent().getCity();
    }

    public Weather(String addressOrIp) throws LocationException, IOException {
        if (Nym.string.isIP(addressOrIp)) {
            this.location = Nym.position.getLocationByIp(addressOrIp);
            this.address = Nym.geocoding.getConverseGeocodingEntity(this.location).getResult().getAddressComponent().getCity();
        } else {
            this.location = Nym.geocoding.addressToLocation(addressOrIp);
            this.address = addressOrIp;
        }
    }

    public Weather(double lng, double lat) throws LocationException, IOException {
        this.location.setLng(lng);
        this.location.setLat(lat);
        this.address = Nym.geocoding.getConverseGeocodingEntity(this.location).getResult().getAddressComponent().getCity();
    }

    public final RealtimeWeatherEntity getRealtimeWeather() throws IOException {
        RealtimeWeatherEntity entity = this.getRealtimeWeather(this.location);
        if (entity.getStatus().equals("ok")) {
            return entity;
        }
        System.out.println("Weaher - getRealtimeWeather \u83b7\u53d6\u5b9e\u65f6\u5929\u6c14\u5931\u8d25 \n" + entity.toErrorString());
        return null;
    }

    public final ForecastWeatherEntity getForecastWeather() throws IOException {
        ForecastWeatherEntity entity = this.getForecastWeather(this.location);
        if (entity.getStatus().equals("ok")) {
            return entity;
        }
        System.out.println("Weaher - getForecastWeather \u83b7\u53d6\u5b9e\u65f6\u5929\u6c14\u5931\u8d25 \n " + entity.toErrorString());
        return null;
    }

    public LocationEntity getLocation() {
        return this.location;
    }

    public String getAddress() {
        return this.address;
    }
}

